/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.BaseSubPane;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostMouseInputAdapter;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class DroppableTaskPane
extends BaseSubPane
implements GhostActionable,
CommandListener {
    public static final DataFlavor DROPPABLE_PANE_FLAVOR = new DataFlavor(DroppableTaskPane.class, "DroppablePane");
    protected String desc = null;
    protected List<DataFlavor> dropFlavors = new ArrayList<DataFlavor>();
    protected GhostMouseInputAdapter mouseDropAdapter = null;

    public DroppableTaskPane(String name, Taskable task, String desc) {
        super(name, task);
        this.desc = desc;
        this.removeAll();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.desc != null) {
            Dimension size = this.getSize();
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(this.desc);
            g.drawString(this.desc, (size.width - width) / 2, (size.height - fm.getHeight()) / 2);
        }
    }

    @Override
    public abstract void doCommand(CommandAction var1);

    @Override
    public abstract void doAction(GhostActionable var1);

    @Override
    public void setData(Object data) {
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public Object getDataForClass(Class<?> classObj) {
        return null;
    }

    @Override
    public void createMouseInputAdapter() {
        this.mouseDropAdapter = new GhostMouseInputAdapter(UIRegistry.getGlassPane(), "action", this);
        this.addMouseListener(this.mouseDropAdapter);
        this.addMouseMotionListener(this.mouseDropAdapter);
    }

    @Override
    public GhostMouseInputAdapter getMouseInputAdapter() {
        return null;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return null;
    }

    @Override
    public List<DataFlavor> getDropDataFlavors() {
        return this.dropFlavors;
    }

    @Override
    public List<DataFlavor> getDragDataFlavors() {
        return null;
    }
}

