/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.GraphicsUtils;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Calendar;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;

public class BaseSubPane
extends JTiledPanel
implements SubPaneIFace,
Printable {
    protected String name;
    protected Taskable task;
    protected Long createTime = Calendar.getInstance().getTime().getTime();
    protected JProgressBar progressBar;
    protected JLabel progressLabel;
    protected JPanel progressBarPanel;
    protected JButton progressCancelBtn = null;

    public BaseSubPane(String name, Taskable task) {
        this(name, task, true, false);
    }

    public BaseSubPane(String name, Taskable task, boolean buildProgressUI) {
        this(name, task, buildProgressUI, false);
    }

    public BaseSubPane(String name, Taskable task, boolean buildProgressUI, boolean includeProgressCancelBtn) {
        SkinItem skinItem;
        this.name = name;
        this.task = task;
        this.setLayout(new BorderLayout());
        if (buildProgressUI) {
            this.progressBar = UIHelper.createProgressBar();
            this.progressBar.setIndeterminate(true);
            FormLayout formLayout = new FormLayout("f:max(100px;p):g", "center:p:g, p, center:p:g");
            PanelBuilder builder = new PanelBuilder(formLayout);
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.progressBar, cc.xy(1, 1));
            this.progressLabel = UIHelper.createLabel("", 0);
            builder.add((Component)this.progressLabel, cc.xy(1, 3));
            PanelBuilder builder2 = includeProgressCancelBtn ? new PanelBuilder(new FormLayout("center:p:g", "center:p:g, p, top:p")) : new PanelBuilder(new FormLayout("center:p:g", "center:p:g"));
            builder2.add((Component)builder.getPanel(), cc.xy(1, 1));
            if (includeProgressCancelBtn) {
                this.progressCancelBtn = UIHelper.createButton(UIRegistry.getResourceString("CANCEL"));
                builder2.add((Component)this.progressCancelBtn, cc.xy(1, 3));
            }
            this.progressBarPanel = builder2.getPanel();
            this.add((Component)this.progressBarPanel, "Center");
        }
        if ((skinItem = SkinsMgr.getSkinItem("SubPane")) != null) {
            skinItem.setupPanel(this);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }

    public JPanel getProgressBarPanel() {
        return this.progressBarPanel;
    }

    public JButton getProgressCancelBtn() {
        return this.progressCancelBtn;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int index) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (index >= 1) {
            return 1;
        }
        double imgWidth = pf.getImageableWidth();
        double imgHeight = pf.getImageableHeight();
        Dimension size = this.getSize();
        BufferedImage fullSizeImg = new BufferedImage(size.width, size.height, 1);
        Graphics fsG = ((Image)fullSizeImg).getGraphics();
        this.printAll(fsG);
        fsG.dispose();
        int imgW = (int)imgWidth;
        int imgH = (int)imgHeight;
        Image scaledImg = GraphicsUtils.getScaledImage(new ImageIcon(fullSizeImg), imgW, imgH, true);
        g2.drawImage(scaledImg, 0, 0, null);
        return 0;
    }

    protected void printStats(Printable printable) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(printable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BaseSubPane.class, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    protected void registerPrintContextMenu() {
        if (this instanceof Printable) {
            this.addMouseListener(new MouseAdapter(){

                private void displayMenu(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem printMenu = new JMenuItem(UIRegistry.getResourceString("Print"));
                        menu.add(printMenu);
                        menu.show(e.getComponent(), e.getX(), e.getY());
                        printMenu.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ev) {
                                BaseSubPane.this.printStats(BaseSubPane.this);
                            }
                        });
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    this.displayMenu(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    this.displayMenu(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    this.displayMenu(e);
                }
            });
        }
    }

    @Override
    public Long getCreateTime() {
        return this.createTime;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.task.getIcon(16);
    }

    @Override
    public String getPaneName() {
        return this.name;
    }

    @Override
    public void setPaneName(String name) {
        this.name = name;
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public Component getFirstFocusable() {
        return null;
    }

    @Override
    public MultiView getMultiView() {
        return null;
    }

    @Override
    public Taskable getTask() {
        return this.task;
    }

    @Override
    public RecordSetIFace getRecordSet() {
        return null;
    }

    @Override
    public void showingPane(boolean show) {
    }

    @Override
    public String getHelpTarget() {
        return this.task != null ? this.task.getHelpTarget() : null;
    }

    @Override
    public boolean aboutToShutdown() {
        return true;
    }

    @Override
    public void shutdown() {
    }

    protected boolean allowProgressCancel() {
        return false;
    }
}

