/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks.subpane;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.tasks.subpane.ChartPane;
import edu.ku.brc.dbsupport.QueryResultsContainerIFace;
import edu.ku.brc.dbsupport.QueryResultsHandlerIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChartPane
extends ChartPane {
    private QueryResultsHandlerIFace handler = null;

    public BarChartPane(String name, Taskable task) {
        super(name, task);
        this.progressLabel.setText(UIRegistry.getResourceString("BarChartPane.BUILD_BARCHART"));
    }

    @Override
    public Icon getIcon() {
        return IconManager.getIcon("Bar_Chart", IconManager.IconSize.Std16);
    }

    @Override
    public void setHandler(QueryResultsHandlerIFace handler) {
        this.handler = handler;
    }

    @Override
    public QueryResultsHandlerIFace getHandler() {
        return this.handler;
    }

    protected void addCompletedComp(JComponent comp) {
        this.removeAll();
        this.add((Component)comp, "Center");
        if (this.handler != null) {
            this.handler.cleanUp();
            this.handler = null;
        }
        this.doLayout();
        this.repaint();
    }

    @Override
    public synchronized void allResultsBack(QueryResultsContainerIFace qrc) {
        String cat = "";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        List<Object> list = this.handler.getDataObjects();
        int i = 0;
        while (i < list.size()) {
            Object descObj = list.get(i++);
            Object valObj = list.get(i);
            dataset.addValue((double)UIHelper.getInt(valObj), (Comparable)((Object)UIHelper.getString(descObj)), (Comparable)((Object)cat));
            ++i;
        }
        list.clear();
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.title, (String)this.xAxisTitle, (String)this.yAxisTitle, (CategoryDataset)dataset, (PlotOrientation)(this.isVertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL), (boolean)true, (boolean)true, (boolean)false);
        ChartPanel panel = new ChartPanel(chart, true, true, true, true, true);
        panel.setMaximumSize(new Dimension(100, 100));
        panel.setPreferredSize(new Dimension(100, 100));
        this.addCompletedComp((JComponent)panel);
    }

    @Override
    public void resultsInError(QueryResultsContainerIFace qrc) {
        JLabel lbl = UIHelper.createLabel(UIRegistry.getResourceString("BarChartPane.ERROR_CREATNG_BARCHART"), 0);
        this.addCompletedComp(lbl);
    }
}

