/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks;

import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DataProviderFactory;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.SwingWorker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StatsTrackerTask
extends BaseTask {
    private static final Logger log = Logger.getLogger(StatsTrackerTask.class);
    public static final String STATS_TRACKER = "StatsTracker";
    protected StatsSwingWorker<?, ?> worker;
    protected boolean isSendSecondaryStatsAllowed = false;

    public StatsTrackerTask() {
        super(STATS_TRACKER, UIRegistry.getResourceString(STATS_TRACKER));
        if (UIRegistry.isTesting()) {
            CommandDispatcher.register("Database", this);
        }
    }

    public StatsTrackerTask(String name, String title) {
        super(name, title);
    }

    public void setSendSecondaryStatsAllowed(boolean isSendSecondaryStatsAllowed) {
        this.isSendSecondaryStatsAllowed = isSendSecondaryStatsAllowed;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    protected void showClosingFrame() {
    }

    protected PropertyChangeListener getPCLForWorker() {
        return null;
    }

    protected boolean starting() {
        return true;
    }

    protected void completed() {
    }

    public void sendStats(final boolean doExit, boolean doSilent, final boolean doSendDoneEvent) {
        if (!doSilent) {
            this.showClosingFrame();
        }
        if (this.starting()) {
            PropertyChangeListener pcl;
            this.worker = new StatsSwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    StatsTrackerTask.this.sendStats();
                    return null;
                }

                @Override
                protected void done() {
                    super.done();
                    StatsTrackerTask.this.completed();
                    if (doExit) {
                        AppPreferences.shutdownAllPrefs();
                        DataProviderFactory.getInstance().shutdown();
                        DBConnection.shutdown();
                        System.exit(0);
                    } else if (doSendDoneEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                CommandDispatcher.dispatch(new CommandAction("App", "STATS_SEND_DONE", null));
                            }
                        });
                    }
                }
            };
            if (!doSilent && (pcl = this.getPCLForWorker()) != null) {
                this.worker.addPropertyChangeListener(pcl);
            }
            this.worker.execute();
        }
    }

    @Override
    public SubPaneIFace getStarterPane() {
        return null;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        return null;
    }

    protected void connectToServerNow(boolean isUserInitiatedUpdateCheck) {
        SwingWorker workerThread = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    StatsTrackerTask.this.sendStats();
                    return null;
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(StatsTrackerTask.class, e);
                    return e;
                }
            }

            @Override
            public void finished() {
            }
        };
        workerThread.start();
    }

    protected void sendStats() throws Exception {
        StatsTrackerTask.sendStats(this.getVersionCheckURL(), this.createPostParameters(this.isSendSecondaryStatsAllowed), this.getClass().getName());
    }

    public static void sendStats(String url, Vector<NameValuePair> postParams, String userAgentName) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)userAgentName);
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestBody(StatsTrackerTask.buildNamePairArray(postParams));
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
            String responseString = postMethod.getResponseBodyAsString();
        }
        catch (UnknownHostException ex) {
            log.debug((Object)"Couldn't reach host.");
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    protected String getVersionCheckURL() {
        String baseURL = UIRegistry.getResourceString("StatsTrackerTask.URL");
        return baseURL;
    }

    protected static String fixParam(String value) {
        return value == null ? "" : value;
    }

    protected int addStat(String statName, Vector<NameValuePair> statsList, String sql) {
        Integer count = 0;
        if (sql != null) {
            count = BasicSQLUtils.getCount(sql);
            if (count != null) {
                statsList.add(new NameValuePair(statName, Integer.toString(count)));
            } else {
                return 0;
            }
        }
        return count;
    }

    protected Vector<NameValuePair> collectSecondaryStats(boolean doSendSecondaryStats) {
        return null;
    }

    public static NameValuePair[] buildNamePairArray(Vector<NameValuePair> postParams) {
        NameValuePair[] paramArray = new NameValuePair[postParams.size()];
        int i = 0;
        while (i < paramArray.length) {
            paramArray[i] = postParams.get(i);
            ++i;
        }
        return paramArray;
    }

    protected Vector<NameValuePair> createPostParameters(boolean doSendSecondaryStats) {
        Vector<NameValuePair> postParams = new Vector<NameValuePair>();
        try {
            String installID = UsageTracker.getInstallId();
            postParams.add(new NameValuePair("id", installID));
            postParams.add(new NameValuePair("os_name", System.getProperty("os.name")));
            postParams.add(new NameValuePair("os_version", System.getProperty("os.version")));
            postParams.add(new NameValuePair("java_version", System.getProperty("java.version")));
            postParams.add(new NameValuePair("java_vendor", System.getProperty("java.vendor")));
            postParams.add(new NameValuePair("user_name", System.getProperty("user.name")));
            try {
                postParams.add(new NameValuePair("ip", InetAddress.getLocalHost().getHostAddress()));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            postParams.add(new NameValuePair("tester", AppPreferences.getLocalPrefs().getBoolean("tester", false) != false ? "true" : "false"));
            String resAppVersion = UIRegistry.getAppVersion();
            if (StringUtils.isEmpty((String)resAppVersion)) {
                resAppVersion = "Unknown";
            }
            postParams.add(new NameValuePair("app_version", resAppVersion));
            Vector<NameValuePair> extraStats = this.collectSecondaryStats(doSendSecondaryStats);
            if (extraStats != null) {
                postParams.addAll(extraStats);
            }
            List<Pair<String, Integer>> statistics = UsageTracker.getUsageStats();
            for (Pair<String, Integer> stat : statistics) {
                postParams.add(new NameValuePair((String)stat.first, Integer.toString((Integer)stat.second)));
            }
            return postParams;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(StatsTrackerTask.class, ex);
            return null;
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        Object dataObj;
        if (UIRegistry.isTesting() && cmdAction.isType("Database") && (dataObj = cmdAction.getData()) != null) {
            UsageTracker.incrUsageCount("DB." + cmdAction.getAction() + "." + dataObj.getClass().getSimpleName());
        }
        super.doCommand(cmdAction);
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    public static class ConnectionException
    extends IOException {
        public ConnectionException(Throwable e) {
        }
    }

    public abstract class StatsSwingWorker<T, V>
    extends javax.swing.SwingWorker<T, V> {
        public void setProgressValue(int value) {
            this.setProgress(value);
        }
    }
}

