/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks;

import edu.ku.brc.af.auth.BasicPermisionPanel;
import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.tasks.BaseTask;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.af.tasks.subpane.StatsPane;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.stats.StatsMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class StatsTask
extends BaseTask {
    public static final String STATISTICS = "Statistics";
    private static final Logger log = Logger.getLogger(StatsTask.class);
    protected static final String DISPLAY = "display";
    protected static final String BAR_CHART = "bar chart";
    protected static final String PIE_CHART = "pie chart";
    protected static final String TABLE = "table";
    protected static final String FORM = "form";
    protected Element panelDOM;

    public StatsTask() {
        super(STATISTICS, UIRegistry.getResourceString(STATISTICS));
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            super.initialize();
            try {
                this.panelDOM = AppContextMgr.getInstance().getResourceAsDOM("StatisticsPanel");
                if (this.panelDOM == null) {
                    log.error((Object)"Couldn't load StatisticsPanel");
                    return;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(StatsTask.class, ex);
                log.error((Object)("Couldn't load `StatisticsPanel` " + ex));
            }
            StatsMgr.getDOM();
            boolean hasResBundle = false;
            if (StringUtils.isNotEmpty((String)StatsMgr.getResourceName())) {
                hasResBundle = UIRegistry.loadAndPushResourceBundle(StatsMgr.getResourceName()) != null;
            }
            try {
                List boxes = this.panelDOM.selectNodes("/boxes/box");
                for (Element box : boxes) {
                    NavBox navBox = new NavBox(UIRegistry.getResourceString(box.attributeValue("title")));
                    List items = box.selectNodes("item");
                    for (Element item : items) {
                        String boxName = item.attributeValue("name");
                        String boxTitle = item.attributeValue("title");
                        String type = item.attributeValue("type");
                        DisplayAction action = null;
                        if (type.toLowerCase().equals(PIE_CHART)) {
                            type = "Pie_Chart";
                            action = new DisplayAction(boxName);
                        } else if (type.toLowerCase().equals(BAR_CHART)) {
                            type = "Bar_Chart";
                            action = new DisplayAction(boxName);
                        }
                        String tooltip = StatsMgr.getTooltipForStat(boxName);
                        navBox.add(NavBox.createBtnWithTT(boxTitle, type, tooltip, IconManager.STD_ICON_SIZE, action));
                    }
                    this.navBoxes.add(navBox);
                }
            }
            finally {
                if (hasResBundle) {
                    UIRegistry.popResourceBundle();
                }
            }
        }
        this.isShowDefault = true;
    }

    @Override
    public SubPaneIFace getStarterPane() {
        if (this.starterPane == null) {
            this.starterPane = new StatsPane(this.title, this, "StatsSummaryPanel", true, null, null);
        }
        return this.starterPane;
    }

    public void createStatPane(String statName) {
        JPanel panel = StatsMgr.createStatPane(statName);
        if (panel != null) {
            SimpleDescPane pane = new SimpleDescPane(this.title, (Taskable)this, panel);
            this.addSubPaneToMgr(pane);
        }
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return new BasicPermisionPanel(STATISTICS, "ENABLE", null, null, null);
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        this.toolbarItems = new Vector();
        String label = UIRegistry.getResourceString(STATISTICS);
        String hint = UIRegistry.getResourceString("stats_hint");
        ToolBarDropDownBtn btn = this.createToolbarButton(label, this.iconName, hint);
        this.toolbarItems.add(new ToolBarItemDesc(btn));
        return this.toolbarItems;
    }

    public Class<? extends StatsTask> getTaskClass() {
        return this.getClass();
    }

    @Override
    protected void doProcessAppCommands(CommandAction cmdAction) {
        super.doProcessAppCommands(cmdAction);
        if (cmdAction.isAction("AppRestart")) {
            this.starterPane = null;
        }
    }

    @Override
    protected boolean[][] getPermsArray() {
        boolean[][] blArrayArray = new boolean[4][];
        blArrayArray[0] = new boolean[]{true, true, true, true};
        blArrayArray[1] = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArrayArray[2] = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArrayArray[3] = blArray2;
        return blArrayArray;
    }

    class DisplayAction
    implements ActionListener {
        private String statName;

        public DisplayAction(String statName) {
            this.statName = statName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsageTracker.incrUsageCount("ST." + this.statName);
            StatsTask.this.createStatPane(this.statName);
        }
    }
}

