/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.tasks;

import edu.ku.brc.af.auth.PermissionEditorIFace;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.auth.SecurityOptionIFace;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.NavBox;
import edu.ku.brc.af.core.NavBoxAction;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgr;
import edu.ku.brc.af.core.SubPaneMgrListener;
import edu.ku.brc.af.core.TaskCommandDef;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.FormPane;
import edu.ku.brc.af.ui.db.CommandActionForDB;
import edu.ku.brc.af.ui.forms.FormDataObjIFace;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.MultiView;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.specify.SpecifyUserTypes;
import edu.ku.brc.specify.datamodel.Workbench;
import edu.ku.brc.specify.tasks.RecordSetTask;
import edu.ku.brc.specify.ui.db.AskForNumbersDlg;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandActionWrapper;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.MemoryDropDownButton;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolBarDropDownBtn;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.util.Pair;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;

public abstract class BaseTask
implements Taskable,
CommandListener,
SubPaneMgrListener {
    protected static final String securityPrefix = "Task";
    public static final String APP_CMD_TYPE = "App";
    public static final String APP_START_ACT = "StartUp";
    public static final String APP_RESTART_ACT = "AppRestart";
    public static final String APP_SHUTDOWN_ACT = "Shutdown";
    public static final String DB_CMD_TYPE = "Database";
    public static final String APP_REQ_RESTART = "AppReqRestart";
    public static final String APP_REQ_EXIT = "AppReqExit";
    public static final String SAVE_CMD_ACT = "Save";
    public static final String INSERT_CMD_ACT = "Insert";
    public static final String DELETE_CMD_ACT = "Delete";
    public static final String UPDATE_CMD_ACT = "Update";
    public static final String OPEN_FORM_CMD_ACT = "OPEN_FORM";
    protected static Font toolbarBtnFont = null;
    protected String name;
    protected String title;
    protected String shortDesc;
    protected String iconName;
    protected List<NavBoxIFace> navBoxes = new Vector<NavBoxIFace>();
    protected boolean isInitialized = false;
    protected List<TaskCommandDef> commands = null;
    protected List<SubPaneIFace> subPanes = new ArrayList<SubPaneIFace>();
    protected boolean taskCentricPanesOnly = true;
    protected boolean closeOnLastPane = false;
    protected SubPaneIFace starterPane = null;
    protected boolean isVisible = true;
    protected FormPane recentFormPane = null;
    protected boolean isShowDefault = false;
    protected boolean isEnabled = true;
    protected Vector<ToolBarItemDesc> toolbarItems = null;
    protected Vector<MenuItemDesc> menuItems = null;
    protected PermissionIFace permissions = null;
    protected Hashtable<String, PermissionIFace> defPermsHash = new Hashtable();

    public BaseTask() {
        ContextMgr.register(this);
        SubPaneMgr.getInstance().addListener(this);
        CommandDispatcher.register(APP_CMD_TYPE, this);
    }

    public BaseTask(String name, String title) {
        this();
        this.name = name;
        this.title = title;
        this.iconName = name;
    }

    public void finalize() {
        ContextMgr.unregister(this);
        SubPaneMgr.getInstance().removeListener(this);
    }

    public static Font getToolbarBtnFont() {
        return toolbarBtnFont;
    }

    public static void setToolbarBtnFont(Font toolbarBtnFont) {
        BaseTask.toolbarBtnFont = toolbarBtnFont;
    }

    @Override
    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    protected ToolBarDropDownBtn createToolbarButton(String label, String iconNameArg, String hint) {
        return this.createToolbarButton(label, iconNameArg, hint, null);
    }

    protected ToolBarDropDownBtn createToolbarButton(String label, String iconNameArg, String hint, List<JComponent> menus, ActionListener actionListener) {
        ImageIcon buttonIcon = IconManager.getIcon(iconNameArg, IconManager.IconSize.Std24);
        ToolBarDropDownBtn btn = new ToolBarDropDownBtn(label, buttonIcon, 3, menus);
        if (toolbarBtnFont != null) {
            btn.setFont(toolbarBtnFont);
        }
        btn.setStatusBarHintText(hint);
        btn.addActionListener(actionListener);
        return btn;
    }

    protected MemoryDropDownButton createMemoryToolbarButton(String label, String iconNameArg, String hint, List<JComponent> menus) {
        ImageIcon buttonIcon = IconManager.getIcon(iconNameArg, IconManager.IconSize.Std24);
        MemoryDropDownButton btn = new MemoryDropDownButton(label, buttonIcon, 3, menus);
        btn.setStatusBarHintText(hint);
        return btn;
    }

    protected ToolBarDropDownBtn createToolbarButton(String catName, String imageName, String hint, List<JComponent> menus) {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseTask.this.requestContext();
            }
        };
        return this.createToolbarButton(catName, imageName, hint, menus, al);
    }

    protected NavBoxItemIFace addNavBoxItem(NavBox navBox, String labelText, String iconNameArg, CommandAction delCmdAction, Object data, int position) {
        NavBoxItemIFace nbi = BaseTask.makeDnDNavBtn(navBox, labelText, iconNameArg, null, null, delCmdAction, true, position, false);
        if (nbi instanceof GhostActionable) {
            ((GhostActionable)((Object)nbi)).setData(data != null ? data : this);
        }
        return nbi;
    }

    public static NavBoxItemIFace makeDnDNavBtn(NavBox navBox, String labelText, String iconNameArg, CommandAction cmdAction, CommandAction delCmdAction, Class<?> flavorClass, String dragFlavor, String dropFlavor) {
        RolloverCommand roc = (RolloverCommand)((Object)BaseTask.makeDnDNavBtn(navBox, labelText, null, iconNameArg, cmdAction, delCmdAction, true, -1, false));
        roc.addDragDataFlavor(new DataFlavor(Workbench.class, dragFlavor));
        roc.addDropDataFlavor(new DataFlavor(flavorClass, dropFlavor));
        return (NavBoxItemIFace)((Object)roc);
    }

    public static NavBoxItemIFace makeDnDNavBtn(NavBox navBox, String labelText, String iconNameArg, CommandAction cmdAction, CommandAction delCmdAction, boolean makeDraggable, boolean addSorted) {
        return BaseTask.makeDnDNavBtn(navBox, labelText, iconNameArg, null, cmdAction, delCmdAction, makeDraggable, -1, addSorted);
    }

    public static NavBoxItemIFace makeDnDNavBtn(NavBox navBox, String labelText, String iconNameArg, String toolTip, CommandAction cmdAction, CommandAction delCmdAction, boolean makeDraggable, boolean addSorted) {
        return BaseTask.makeDnDNavBtn(navBox, labelText, iconNameArg, toolTip, cmdAction, delCmdAction, makeDraggable, -1, addSorted);
    }

    public static NavBoxItemIFace makeDnDNavBtn(NavBox navBox, String labelText, String iconNameArg, String toolTip, CommandAction cmdAction, CommandAction delCmdAction, boolean makeDraggable, int position, boolean addSorted) {
        NavBoxItemIFace nb = NavBox.createBtn(labelText, iconNameArg, IconManager.STD_ICON_SIZE);
        if (StringUtils.isNotEmpty((String)toolTip)) {
            ((RolloverCommand)((Object)nb)).setToolTip(toolTip);
        }
        if (cmdAction != null) {
            NavBoxButton nbb = (NavBoxButton)nb;
            nbb.addActionListener(new CommandActionWrapper(cmdAction));
            nbb.setData(cmdAction);
        }
        if (delCmdAction != null) {
            ((NavBoxButton)nb).setDeleteCommandAction(delCmdAction);
        }
        if (addSorted) {
            navBox.insertSorted(nb);
        } else if (position == -1) {
            navBox.add(nb);
        } else {
            navBox.insert(nb, false, false, position);
        }
        if (nb instanceof GhostActionable) {
            GhostActionable ga = (GhostActionable)((Object)nb);
            if (makeDraggable) {
                ga.createMouseInputAdapter();
                ((RolloverCommand)((Object)nb)).setCursor(new Cursor(12));
            }
        }
        return nb;
    }

    protected void deleteDnDBtn(NavBoxIFace box, NavBoxItemIFace nbi) {
        RolloverCommand roc = (RolloverCommand)((Object)nbi);
        if (nbi instanceof GhostActionable) {
            UIRegistry.getGlassPane().remove(roc);
            box.remove(nbi);
            NavBoxMgr.getInstance().validate();
            NavBoxMgr.getInstance().invalidate();
            NavBoxMgr.getInstance().doLayout();
            NavBoxMgr.getInstance().repaint();
            UIRegistry.forceTopFrameRepaint();
        }
    }

    protected boolean deleteDnDBtn(String btnTitle) {
        Pair<NavBoxIFace, NavBoxItemIFace> btn = this.findDnDBtn(btnTitle);
        if (btn != null) {
            this.deleteDnDBtn(btn.getFirst(), btn.getSecond());
            return true;
        }
        return false;
    }

    protected Pair<NavBoxIFace, NavBoxItemIFace> findDnDBtn(String btnTitle) {
        for (NavBoxIFace navBox : this.navBoxes) {
            for (NavBoxItemIFace nbi : navBox.getItems()) {
                if (!nbi.getTitle().equals(btnTitle)) continue;
                return new Pair<NavBoxIFace, NavBoxItemIFace>(navBox, nbi);
            }
        }
        return null;
    }

    protected NavBoxItemIFace addNavBoxItem(NavBox navBox, String labelText, String iconNameArg, CommandAction delCmdAction, Object data) {
        return this.addNavBoxItem(navBox, labelText, iconNameArg, delCmdAction, data, -1);
    }

    protected void setUpDraggable(NavBoxItemIFace nbi, DataFlavor[] flavors) {
        this.setUpDraggable(nbi, flavors, null);
    }

    protected void setUpDraggable(NavBoxItemIFace nbi, DataFlavor[] flavors, NavBoxAction navBoxAction) {
        NavBoxButton roc = (NavBoxButton)nbi;
        DataFlavor[] dataFlavorArray = flavors;
        int n = flavors.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor df = dataFlavorArray[n2];
            roc.addDragDataFlavor(df);
            ++n2;
        }
        if (navBoxAction != null) {
            roc.addActionListener(navBoxAction);
        }
    }

    protected SubPaneIFace addSubPaneToMgr(SubPaneIFace subPane) {
        if (this.starterPane != null) {
            SubPaneMgr.getInstance().replacePane(this.starterPane, subPane);
            this.starterPane = null;
        } else {
            SubPaneMgr.getInstance().addPane(subPane);
        }
        return subPane;
    }

    protected void removeSubPaneFromMgr(SubPaneIFace subPane) {
        SubPaneMgr.getInstance().removePane(subPane);
    }

    @Override
    public abstract SubPaneIFace getStarterPane();

    @Override
    public void setStarterPane(SubPaneIFace pane) {
        this.starterPane = pane;
    }

    public Class<? extends BaseTask> getTaskClass() {
        return this.getClass();
    }

    protected FormPane getFormPane(String viewSetName, String viewName, Object data) {
        for (SubPaneIFace sp : this.subPanes) {
            if (!(sp instanceof FormPane)) continue;
            FormPane fp = (FormPane)sp;
            if (viewSetName != null && !viewSetName.equals(fp.getViewSetName()) || viewName != fp.getViewName() || data != fp.getData()) continue;
            return fp;
        }
        return null;
    }

    protected FormPane createFormPanel(String tabName, String mode, FormDataObjIFace formData, ImageIcon paneIcon) {
        return this.createFormPanel(tabName, mode, formData, formData.getDataClass(), paneIcon);
    }

    protected FormPane createFormPanel(String tabName, String mode, FormDataObjIFace formData, Class<?> dataClass, ImageIcon paneIcon) {
        if (formData != null) {
            return this.createFormPanel(tabName, null, dataClass.getSimpleName(), mode, formData, 2, paneIcon);
        }
        return null;
    }

    protected FormPane createFormPanel(String tabName, String mode, RecordSetIFace recordSet, ImageIcon paneIcon) {
        DBTableInfo ti;
        if (recordSet != null && (ti = DBTableIdMgr.getInstance().getInfoById(recordSet.getDbTableId())) != null) {
            FormPane fp = this.createFormPanel(tabName, null, ti.getShortClassName(), mode, null, 3, paneIcon);
            fp.setRecordSet(recordSet);
            return fp;
        }
        return null;
    }

    protected FormPane createFormPanel(String tabName, String viewsetName, String viewName, String mode, Object data, ImageIcon paneIcon) {
        return this.createFormPanel(tabName, viewsetName, viewName, mode, data, 2, paneIcon);
    }

    protected FormPane createFormPanel(String tabName, String viewsetName, String viewName, String mode, Object data, int options, ImageIcon paneIcon) {
        return this.createFormPanel(tabName, viewsetName, viewName, mode, data, options, paneIcon, null);
    }

    protected FormPane createFormPanel(String tabName, String viewsetName, String viewName, String mode, Object data, int options, ImageIcon paneIcon, FormPane.FormPaneAdjusterIFace adjuster) {
        ImageIcon iconImg = paneIcon == null ? this.getIcon(16) : paneIcon;
        FormPane fp = null;
        if (this.recentFormPane != null && this.recentFormPane.getComponentCount() == 0) {
            this.recentFormPane.createForm(viewsetName, viewName, null, null, options, adjuster);
            this.recentFormPane.getMultiView().setData(data);
            fp = this.recentFormPane;
            fp.setIcon(iconImg);
        } else {
            fp = this.getFormPane(viewsetName, viewName, data);
            if (fp != null) {
                fp.setIcon(iconImg);
                SubPaneMgr.getInstance().showPane(fp.getName());
            } else {
                this.recentFormPane = new FormPane(tabName, (Taskable)this, viewsetName, viewName, mode, null, options, adjuster);
                this.recentFormPane.setPaneName(tabName);
                this.recentFormPane.setIcon(iconImg);
                if (data instanceof RecordSetIFace) {
                    this.recentFormPane.setRecordSet((RecordSetIFace)data);
                } else {
                    this.recentFormPane.getMultiView().setData(data);
                }
                SubPaneMgr.replaceSimplePaneForTask(this.recentFormPane);
                fp = this.recentFormPane;
            }
        }
        return fp;
    }

    protected void removePanelForData(String viewSetName, String viewName, Object data) {
        FormPane currPane = null;
        FormPane fp = null;
        int cnt = 0;
        for (SubPaneIFace subPane : this.subPanes) {
            fp = (FormPane)subPane;
            if (!viewSetName.equals(fp.getViewSetName()) || viewName != fp.getViewName()) continue;
            if (fp.getData() == data) {
                currPane = fp;
            }
            ++cnt;
        }
        if (cnt == 1) {
            if (currPane != null) {
                currPane.clearForm();
            }
        } else if (cnt > 0) {
            SubPaneMgr.getInstance().removePane(fp);
        }
    }

    public static NavBoxItemIFace getBoxByTitle(NavBox navBox, String boxName) {
        for (NavBoxItemIFace nbi : navBox.getItems()) {
            if (!nbi.getTitle().equals(boxName)) continue;
            return nbi;
        }
        return null;
    }

    public NavBoxItemIFace getBoxByTitle(String boxName) {
        for (NavBoxIFace navBox : this.navBoxes) {
            for (NavBoxItemIFace nbi : navBox.getItems()) {
                if (!nbi.getTitle().equals(boxName)) continue;
                return nbi;
            }
        }
        return null;
    }

    protected FormViewObj getCurrentFormViewObj() {
        Viewable currentViewable;
        MultiView mv;
        FormViewObj formViewObj = null;
        SubPaneIFace subPane = SubPaneMgr.getInstance().getCurrentSubPane();
        if (subPane != null && (mv = subPane.getMultiView()) != null && (currentViewable = mv.getCurrentView()) != null && currentViewable instanceof FormViewObj) {
            formViewObj = (FormViewObj)currentViewable;
        }
        return formViewObj;
    }

    @Override
    public void preInitialize() {
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.navBoxes.clear();
            if (this.commands != null) {
                this.commands.clear();
            }
        }
    }

    @Override
    public List<NavBoxIFace> getNavBoxes() {
        this.initialize();
        return this.navBoxes;
    }

    @Override
    public ImageIcon getIcon(int size) {
        switch (size) {
            case 32: {
                return IconManager.getIcon(this.iconName, IconManager.IconSize.Std32);
            }
            case 24: {
                return IconManager.getIcon(this.iconName, IconManager.IconSize.Std24);
            }
            case 20: {
                return IconManager.getIcon(this.iconName, IconManager.IconSize.Std20);
            }
            case 16: {
                return IconManager.getIcon(this.iconName, IconManager.IconSize.Std16);
            }
        }
        return IconManager.getIcon(this.iconName);
    }

    @Override
    public void requestContext() {
        if (this.canRequestContext()) {
            ContextMgr.requestContext(this);
            SubPaneIFace newPane = this.getStarterPane();
            SubPaneMgr.getInstance().addPane(newPane);
        }
    }

    protected boolean canRequestContext() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<ToolBarItemDesc> getToolBarItems() {
        return null;
    }

    @Override
    public List<MenuItemDesc> getMenuItems() {
        return null;
    }

    @Override
    public void initialize(List<TaskCommandDef> cmds, boolean isVisibleArg) {
        this.commands = cmds;
        this.isVisible = isVisibleArg;
        this.initialize();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isShowDefault() {
        return AppPreferences.getRemote().getBoolean("task.isShowDefault." + this.name, this.isShowDefault);
    }

    @Override
    public boolean isStarterPane() {
        return this.starterPane != null;
    }

    protected void doProcessAppCommands(CommandAction cmdAction) {
        if (cmdAction.isAction(APP_RESTART_ACT)) {
            ContextMgr.removeServicesByTask(this);
        }
    }

    @Override
    public void doCommand(CommandAction cmdActionArg) {
        CommandAction cmdAction = cmdActionArg;
        if (cmdAction.getData() instanceof CommandActionForDB) {
            cmdAction = (CommandAction)cmdAction.getData();
        }
        if (cmdAction.isAction(OPEN_FORM_CMD_ACT)) {
            FormDataObjIFace formData = null;
            if (cmdAction instanceof CommandActionForDB) {
                formData = (FormDataObjIFace)((CommandActionForDB)cmdAction).getDataObj();
            } else if (cmdAction.getData() instanceof FormDataObjIFace) {
                formData = (FormDataObjIFace)cmdAction.getData();
            }
            if (formData != null) {
                if (formData instanceof RecordSetIFace) {
                    RecordSetIFace rs = (RecordSetIFace)((Object)formData);
                    this.createFormPanel(formData.getIdentityTitle(), "edit", formData, rs.getDataClassFormItems(), this.getIcon(16));
                } else {
                    this.createFormPanel(formData.getIdentityTitle(), "edit", formData, this.getIcon(16));
                }
                cmdActionArg.setConsumed(true);
            }
        } else if (cmdAction.isType(APP_CMD_TYPE)) {
            this.doProcessAppCommands(cmdActionArg);
        }
    }

    @Override
    public void subPaneAdded(SubPaneIFace subPane) {
        if (!this.taskCentricPanesOnly || subPane.getTask() == this) {
            this.subPanes.add(subPane);
        }
    }

    @Override
    public void subPaneRemoved(SubPaneIFace subPane) {
        this.subPanes.remove(subPane);
    }

    @Override
    public void subPaneShown(SubPaneIFace subPane) {
    }

    @Override
    public boolean isSingletonPane() {
        return false;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public void doConfigure() {
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem(UIRegistry.getResourceString("BaseTask.CONFIGURE"));
        popupMenu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseTask.this.doConfigure();
            }
        });
        return popupMenu;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        if (this.toolbarItems != null) {
            for (ToolBarItemDesc tbi : this.toolbarItems) {
                tbi.getComp().setEnabled(enabled);
            }
        }
        if (this.menuItems != null) {
            for (MenuItemDesc mi : this.menuItems) {
                if (!(mi.getMenuItem() instanceof JMenuItem)) continue;
                ((JMenuItem)mi.getMenuItem()).setEnabled(enabled);
            }
        }
    }

    protected void addAppResourcesToCommandsByMimeType(String mimeType, String reportType, String defaultIcon, Integer classTableId) {
        List<TaskCommandDef> cmds = BaseTask.getAppResourceCommandsByMimeType(mimeType, reportType, defaultIcon, classTableId);
        if (cmds.size() > 0) {
            if (this.commands == null) {
                throw new RuntimeException("this should never have happened.");
            }
            this.commands.addAll(cmds);
        }
    }

    public static List<TaskCommandDef> getAppResourceCommandsByMimeType(String mimeType, String reportType, String defaultIcon, Integer classTableId) {
        LinkedList<TaskCommandDef> result = new LinkedList<TaskCommandDef>();
        for (AppResourceIFace ap : AppContextMgr.getInstance().getResourceByMimeType(mimeType)) {
            Properties params = ap.getMetaDataMap();
            String tableid = params.getProperty("tableid");
            String rptType = params.getProperty("reporttype");
            if ((!StringUtils.isNotEmpty((String)tableid) || classTableId != null && Integer.parseInt(tableid) != classTableId || !StringUtils.isEmpty((String)reportType)) && (!StringUtils.isNotEmpty((String)rptType) || !reportType.equals(rptType))) continue;
            params.put("name", ap.getName());
            params.put("title", ap.getDescription());
            params.put("file", ap.getName());
            params.put("mimetype", mimeType);
            String iconNameStr = params.getProperty("icon");
            if (StringUtils.isEmpty((String)iconNameStr)) {
                iconNameStr = defaultIcon;
            }
            result.add(new TaskCommandDef(ap.getDescription(), iconNameStr, params));
        }
        return result;
    }

    protected NavBoxItemIFace addToNavBoxAndRegisterAsDroppable(DataFlavor dataFlavor, NavBox navBox, NavBoxItemIFace nbi, Properties params) {
        NavBoxButton roc = (NavBoxButton)nbi;
        roc.setData(params);
        roc.addDragDataFlavor(Trash.TRASH_FLAVOR);
        roc.addDragDataFlavor(dataFlavor);
        roc.addDropDataFlavor(RecordSetTask.RECORDSET_FLAVOR);
        navBox.add(nbi);
        return nbi;
    }

    public ASK_TYPE askSourceOfObjects(Class<? extends FormDataObjIFace> classForSrc) {
        Object[] options = new Object[]{UIRegistry.getResourceString("NEW_BT_USE_RS"), UIRegistry.getResourceString("NEW_BT_ENTER_" + classForSrc.getSimpleName())};
        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("NEW_BT_CHOOSE_RS_" + classForSrc.getSimpleName()), UIRegistry.getResourceString("NEW_BT_CHOOSE_RSOPT_TITLE"), 1, 3, null, options, options[0]);
        if (userChoice == 1) {
            return ASK_TYPE.EnterDataObjs;
        }
        if (userChoice == 0) {
            return ASK_TYPE.ChooseRS;
        }
        return ASK_TYPE.Cancel;
    }

    public RecordSetIFace askForDataObjRecordSet(Class<? extends FormDataObjIFace> classForSrc, String field) {
        String titleKey = "BT_TITLE_" + classForSrc.getSimpleName();
        String labelKey = "BT_LABEL_" + classForSrc.getSimpleName();
        AskForNumbersDlg dlg = new AskForNumbersDlg(titleKey, labelKey, classForSrc, field);
        dlg.setVisible(true);
        if (!dlg.isCancelled()) {
            return dlg.getRecordSet();
        }
        return null;
    }

    public RecordSetIFace getRecordSetOfDataObjs(RecordSetIFace recordSetArg, Class<? extends FormDataObjIFace> classForSrc, String fieldName, int numObjRS) {
        RecordSetIFace recordSetFromDB = recordSetArg;
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(classForSrc.getName());
        if (tblInfo != null && recordSetFromDB == null) {
            if (numObjRS > 0) {
                ASK_TYPE rv = this.askSourceOfObjects(classForSrc);
                if (rv == ASK_TYPE.ChooseRS) {
                    recordSetFromDB = recordSetArg == null ? RecordSetTask.askForRecordSet(tblInfo.getTableId()) : recordSetArg;
                } else if (rv == ASK_TYPE.EnterDataObjs) {
                    recordSetFromDB = this.askForDataObjRecordSet(classForSrc, fieldName);
                }
            } else {
                recordSetFromDB = this.askForDataObjRecordSet(classForSrc, fieldName);
            }
        }
        return recordSetFromDB;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public PermissionIFace getPermissions() {
        if (this.permissions == null) {
            this.permissions = SecurityMgr.getInstance().getPermission(this.buildTaskPermissionName(this.getPermissionName()));
        }
        return this.permissions;
    }

    protected String buildTaskPermissionName(String baseName) {
        return "Task." + baseName;
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc == null ? this.title : this.shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    @Override
    public String getPermissionName() {
        return this.name;
    }

    @Override
    public String getPermissionTitle() {
        return this.title;
    }

    @Override
    public void setPermissions(PermissionIFace permissions) {
        this.permissions = permissions;
    }

    @Override
    public List<SecurityOptionIFace> getAdditionalSecurityOptions() {
        return null;
    }

    @Override
    public PermissionEditorIFace getPermEditorPanel() {
        return null;
    }

    @Override
    public PermissionIFace getDefaultPermissions(String userType) {
        if (this.defPermsHash.size() == 0) {
            this.loadDefaultPerms();
        }
        return this.defPermsHash.get(userType);
    }

    @Override
    public boolean isPermissionsSettable() {
        return true;
    }

    protected boolean[][] getPermsArray() {
        return new boolean[][]{new boolean[4], new boolean[4], new boolean[4], new boolean[4]};
    }

    protected void loadDefaultPerms() {
        boolean[][] perms = this.getPermsArray();
        int utInx = 0;
        SpecifyUserTypes.UserType[] userTypeArray = SpecifyUserTypes.UserType.values();
        int n = userTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpecifyUserTypes.UserType userType = userTypeArray[n2];
            this.defPermsHash.put(userType.toString(), new PermissionSettings(perms[utInx][0], perms[utInx][1], perms[utInx][2], perms[utInx][3]));
            ++utInx;
            ++n2;
        }
    }

    @Override
    public String getHelpTarget() {
        return this.name;
    }

    @Override
    public void shutdown() {
    }

    public static enum ASK_TYPE {
        Cancel,
        EnterDataObjs,
        ChooseRS;

    }
}

