/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsPanelMgrIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

public class PrefsToolbar
extends JPanel {
    private static final Logger log = Logger.getLogger(PrefsToolbar.class);
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String PANEL_CLASS = "panelClass";
    public static final String ICON_PATH = "iconPath";
    protected PrefsPanelMgrIFace prefsPanelMgr;
    protected int iconSize = 24;
    protected int numPrefs = 0;
    protected RolloverCommand prevBtn = null;

    public PrefsToolbar(PrefsPanelMgrIFace prefsDlg) {
        super(new ToolbarLayoutManager(2, 4));
        this.prefsPanelMgr = prefsDlg;
        this.init();
    }

    public int getNumPrefs() {
        return this.numPrefs;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color base = this.getBackground();
        Dimension size = this.getSize();
        Color grad_top = base;
        Color grad_bot = UIHelper.makeDarker(base, UIHelper.isMacOS() ? 0.15 : 0.1);
        GradientPaint bg = new GradientPaint(new Point(0, 0), grad_top, new Point(0, size.height), grad_bot);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(bg);
        g2.fillRect(0, 0, size.width, size.height);
        g.setColor(UIHelper.makeDarker(base, 0.5));
        g.drawLine(0, size.height - 1, size.width, size.height - 1);
    }

    protected void init() {
        try {
            Element root = XMLHelper.readDOMFromConfigDir("prefs_init.xml");
            if (root == null) {
                return;
            }
            Node prefsNode = root.selectSingleNode("/prefs");
            String i18NResourceName = XMLHelper.getAttr((Element)prefsNode, "i18nresname", null);
            ResourceBundle resBundle = null;
            if (StringUtils.isNotEmpty((String)i18NResourceName)) {
                resBundle = UIRegistry.getResourceBundle(i18NResourceName);
            }
            List sections = root.selectNodes("/prefs/section");
            this.numPrefs = sections.size();
            for (Element section : sections) {
                String title = XMLHelper.getAttr(section, TITLE, null);
                if (!StringUtils.isNotEmpty((String)title) || XMLHelper.getAttr(section, "isApp", false)) continue;
                this.loadSectionPrefs(section, resBundle);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PrefsToolbar.class, ex);
            ex.printStackTrace();
        }
    }

    protected void loadSectionPrefs(Element sectionElement, ResourceBundle resBundle) {
        RolloverCommand.setVertGap(2);
        try {
            try {
                List prefs = sectionElement.selectNodes("pref");
                for (Element pref : prefs) {
                    ImageIcon icon;
                    PermissionSettings perm;
                    String prefName = pref.attributeValue(NAME);
                    String prefTitle = pref.attributeValue(TITLE);
                    String iconPath = pref.attributeValue("icon");
                    String panelClass = pref.attributeValue(PANEL_CLASS);
                    String viewSetName = pref.attributeValue("viewsetname");
                    String viewName = pref.attributeValue("viewname");
                    String hContext = pref.attributeValue("help");
                    if (AppContextMgr.isSecurityOn() && !(perm = SecurityMgr.getInstance().getPermission("Prefs." + prefName)).canView() || !StringUtils.isNotEmpty((String)prefTitle) || !StringUtils.isNotEmpty((String)iconPath) || !StringUtils.isNotEmpty((String)panelClass)) continue;
                    if (resBundle != null) {
                        try {
                            prefTitle = resBundle.getString(prefTitle);
                        }
                        catch (MissingResourceException ex) {
                            log.error((Object)("Couldn't find key[" + prefTitle + "]"));
                            UsageTracker.incrHandledUsageCount();
                            ExceptionTracker.getInstance().capture(PrefsToolbar.class, ex);
                        }
                    }
                    if ((icon = iconPath.startsWith("http") || iconPath.startsWith("file") ? new ImageIcon(new URL(iconPath)) : IconManager.getImage(iconPath)) != null && (icon.getIconWidth() > this.iconSize || icon.getIconHeight() > this.iconSize)) {
                        icon = new ImageIcon(icon.getImage().getScaledInstance(this.iconSize, this.iconSize, 4));
                    }
                    if (icon == null) {
                        log.error((Object)("Icon was created - path[" + iconPath + "]"));
                    }
                    NavBoxButton btn = new NavBoxButton(UIRegistry.getResourceString(prefTitle), icon);
                    btn.setOpaque(false);
                    btn.setVerticalLayout(true);
                    btn.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
                    try {
                        Class<?> panelClassObj = Class.forName(panelClass);
                        Component comp = (Component)panelClassObj.newInstance();
                        if (comp instanceof PrefsPanelIFace) {
                            PrefsPanelIFace prefPanel = (PrefsPanelIFace)((Object)comp);
                            prefPanel.setName(prefName);
                            prefPanel.setTitle(prefTitle);
                            prefPanel.setHelpContext(hContext);
                            if (!prefPanel.isOKToLoad() || AppContextMgr.isSecurityOn() && !prefPanel.getPermissions().canView()) continue;
                            prefPanel.setPrefsPanelMgr(this.prefsPanelMgr);
                        }
                        if (panelClassObj == GenericPrefsPanel.class) {
                            if (StringUtils.isNotEmpty((String)viewSetName) && StringUtils.isNotEmpty((String)viewName)) {
                                GenericPrefsPanel genericPrefsPanel = (GenericPrefsPanel)comp;
                                genericPrefsPanel.createForm(viewSetName, viewName);
                            } else {
                                log.error((Object)("ViewSetName[" + viewSetName + "] or ViewName[" + viewName + "] is empty!"));
                            }
                        }
                        this.prefsPanelMgr.addPanel(prefTitle, comp);
                        this.add(btn.getUIComponent());
                    }
                    catch (Exception ex) {
                        UsageTracker.incrHandledUsageCount();
                        ExceptionTracker.getInstance().capture(PrefsToolbar.class, ex);
                        log.error((Object)ex);
                        ex.printStackTrace();
                    }
                    btn.addActionListener(new ShowAction(prefTitle, btn));
                }
                if (this.getComponentCount() > 0) {
                    this.prevBtn = (RolloverCommand)this.getComponent(0);
                    this.prevBtn.setActive(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(PrefsToolbar.class, ex);
                throw new RuntimeException(ex);
            }
        }
        finally {
            RolloverCommand.setVertGap(0);
        }
    }

    protected void showPanel(String panelName) {
        this.prefsPanelMgr.showPanel(panelName);
    }

    class ShowAction
    implements ActionListener {
        private String panelName;
        private RolloverCommand btn;

        public ShowAction(String panelName, RolloverCommand btn) {
            this.btn = btn;
            this.panelName = panelName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PrefsToolbar.this.prevBtn != null) {
                PrefsToolbar.this.prevBtn.setActive(false);
            }
            this.btn.setActive(true);
            PrefsToolbar.this.prevBtn = this.btn;
            PrefsToolbar.this.showPanel(this.panelName);
        }
    }
}

