/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.GenericPrefsPanel;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.ui.UIHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PrefsPanel
extends GenericPrefsPanel {
    protected AppPreferences appPrefs;
    protected boolean doLocalPrefs;
    protected HashMap<String, JComponent> fieldHash = new HashMap();
    protected ArrayList<ItemInfo> items = new ArrayList();
    protected FormValidator formValidator = new FormValidator(null);

    public PrefsPanel(boolean doLocalPrefs) {
        this.appPrefs = doLocalPrefs ? AppPreferences.getLocalPrefs() : AppPreferences.getRemote();
    }

    @Override
    public void createForm(String viewSetName, String viewName) {
        CellConstraints cc = new CellConstraints();
        String rowDef = UIHelper.createDuplicateJGoodiesDef("p", "4px", this.items.size());
        PanelBuilder pb = new PanelBuilder(new FormLayout("p,2px,f:p:g", rowDef), (JPanel)this);
        int y = 1;
        for (ItemInfo item : this.items) {
            JComponent cb;
            if (item.getCompType() == CompType.eSep) {
                pb.addSeparator(item.getTitle(), cc.xyw(1, y, 3));
                y += 2;
                continue;
            }
            if (item.getCompType() == CompType.eCheckbox) {
                cb = UIHelper.createCheckBox(item.getTitle());
                item.setComp(cb);
                pb.add((Component)UIHelper.createLabel(" "), cc.xy(1, y));
                pb.add((Component)cb, cc.xy(3, y));
                y += 2;
                ((AbstractButton)cb).setSelected(this.appPrefs.getBoolean(item.getPrefName(), (Boolean)item.getDefaultVal()));
                this.formValidator.createValidator(cb, UIValidator.Type.Changed);
                continue;
            }
            if (item.getCompType() != CompType.eComboBox) continue;
            cb = UIHelper.createComboBox(item.getItemsTitles());
            item.setComp(cb);
            pb.add((Component)UIHelper.createFormLabel(item.getTitle()), cc.xy(1, y));
            pb.add((Component)cb, cc.xy(3, y));
            y += 2;
            ((JComboBox)cb).setSelectedIndex(this.appPrefs.getInt(item.getPrefName(), (Integer)item.getDefaultVal()));
            this.formValidator.createValidator(cb, UIValidator.Type.Changed);
        }
        pb.setDefaultDialogBorder();
    }

    public void add(CompType compType, String title, String prefName, Class<?> cls, Object defVal) {
        this.items.add(new ItemInfo(compType, title, prefName, cls, defVal));
    }

    public void add(CompType compType, String title, String prefName, Class<?> cls, String[] titles, Object defVal) {
        this.items.add(new ItemInfo(compType, title, prefName, cls, titles, defVal));
    }

    public void add(String title) {
        this.items.add(new ItemInfo(CompType.eSep, title));
    }

    @Override
    public FormValidator getValidator() {
        return this.formValidator;
    }

    @Override
    public boolean isFormValid() {
        return this.getValidator() != null ? this.getValidator().getState() == UIValidatable.ErrorType.Valid : false;
    }

    @Override
    public boolean isOKToLoad() {
        return true;
    }

    @Override
    public void savePrefs() {
        for (ItemInfo item : this.items) {
            JComponent cb;
            if (item.getCompType() == CompType.eCheckbox) {
                cb = (JCheckBox)item.getComp();
                this.appPrefs.putBoolean(item.getPrefName(), ((AbstractButton)cb).isSelected());
                continue;
            }
            if (item.getCompType() != CompType.eComboBox) continue;
            cb = (JComboBox)item.getComp();
            this.appPrefs.putInt(item.getPrefName(), ((JComboBox)cb).getSelectedIndex());
        }
        try {
            this.appPrefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static enum CompType {
        eSep,
        eCheckbox,
        eComboBox;

    }

    class ItemInfo {
        CompType compType;
        String title;
        String prefName;
        Class<?> clazz;
        boolean isSep = false;
        Object defaultVal;
        String[] itemTitles = null;
        JComponent comp = null;

        public ItemInfo(CompType compType, String title, String prefName, Class<?> clazz, Object defaultVal) {
            this.compType = compType;
            this.title = title;
            this.prefName = prefName;
            this.clazz = clazz;
            this.defaultVal = defaultVal;
        }

        public ItemInfo(CompType compType, String title, String prefName, Class<?> clazz, String[] itemTitles, Object defaultVal) {
            this.compType = compType;
            this.title = title;
            this.prefName = prefName;
            this.clazz = clazz;
            this.itemTitles = itemTitles;
            this.defaultVal = defaultVal;
        }

        public ItemInfo(CompType compType, String title) {
            this.compType = compType;
            this.title = title;
            this.prefName = null;
            this.clazz = null;
            this.isSep = true;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPrefName() {
            return this.prefName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public JComponent getComp() {
            return this.comp;
        }

        public void setComp(JComponent comp) {
            this.comp = comp;
        }

        public boolean isSep() {
            return this.isSep;
        }

        public CompType getCompType() {
            return this.compType;
        }

        public String[] getItemsTitles() {
            return this.itemTitles;
        }

        public Object getDefaultVal() {
            return this.defaultVal;
        }
    }
}

