/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.prefs.PrefPanelRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class PrefsPaneLayoutManager
implements LayoutManager,
LayoutManager2 {
    private List<Component> comps = new ArrayList<Component>();
    private Dimension preferredSize = new Dimension();
    private Dimension actualCellSize = new Dimension(32, 32);
    private Dimension actualRowSize = new Dimension(0, 0);
    private int maxNumItems = 0;

    public void setActualCellSize(Dimension actualCellSize) {
        this.actualCellSize = actualCellSize;
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
        if (arg1 == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        if (arg1 instanceof PrefPanelRow) {
            this.comps.add(arg1);
        }
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Null component in removeLayoutComponent");
        }
        this.comps.remove(arg0);
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this.preferredSize.width == 0 || this.preferredSize.height == 0) {
                this.calcPreferredSize();
            }
            int x = 0;
            int y = 0;
            this.actualRowSize.width = Math.max(this.actualRowSize.width, target.getSize().width);
            for (Component comp : this.comps) {
                PrefPanelRow ppr = (PrefPanelRow)comp;
                ppr.setActualCellSize(this.actualCellSize);
                ppr.setActualRowSize(this.actualRowSize);
                ppr.setMaxNumItems(this.maxNumItems);
                comp.setBounds(x, y, this.actualRowSize.width, this.actualRowSize.height);
                y += this.actualRowSize.height;
            }
        }
    }

    protected void calcPreferredSize() {
        PrefPanelRow ppr;
        this.preferredSize.width = 0;
        this.actualCellSize.width = 0;
        this.actualCellSize.height = 0;
        int rowHeight = 0;
        for (Component comp : this.comps) {
            ppr = (PrefPanelRow)comp;
            Dimension size = ppr.getPreferredSize();
            Dimension preferredCellSize = ppr.getPreferredCellSize();
            this.actualCellSize.width = Math.max(this.actualCellSize.width, preferredCellSize.width);
            this.actualCellSize.height = Math.max(this.actualCellSize.height, preferredCellSize.height);
            rowHeight = Math.max(rowHeight, size.height);
            this.maxNumItems = Math.max(ppr.getComponentCount() - 1, this.maxNumItems);
        }
        for (Component comp : this.comps) {
            ppr = (PrefPanelRow)comp;
            this.preferredSize.width = Math.max(this.preferredSize.width, ppr.getActualWidth(this.actualCellSize));
        }
        this.actualRowSize.width = this.preferredSize.width;
        this.actualRowSize.height = rowHeight;
        this.preferredSize.height = rowHeight * this.comps.size();
    }

    public List<Component> getComponentList() {
        return this.comps;
    }

    public void removeAll() {
        this.comps.clear();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        if (comp instanceof PrefPanelRow) {
            this.comps.add(comp);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.preferredSize.setSize(0, 0);
        this.calcPreferredSize();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.calcPreferredSize();
        return new Dimension(this.preferredSize);
    }
}

