/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.PrefIndicatorPanel;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsPanelMgrIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.prefs.PrefsToolbar;
import edu.ku.brc.af.ui.SearchBox;
import edu.ku.brc.af.ui.db.JAutoCompTextField;
import edu.ku.brc.af.ui.forms.validation.DataChangeListener;
import edu.ku.brc.af.ui.forms.validation.DataChangeNotifier;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.DocumentAdaptor;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PreferencesDlg
extends CustomDialog
implements DataChangeListener,
PrefsPanelMgrIFace {
    protected static final Logger log = Logger.getLogger(PreferencesDlg.class);
    protected int MILLI_SEC_DELAY = 10;
    protected int MAX_DELAY = (int)((double)this.MILLI_SEC_DELAY * 1.5);
    public static final String PREFERENCES = "Preferences";
    protected SimpleGlassPane glassPane;
    protected JAutoCompTextField searchText;
    protected PrefsToolbar prefsToolbar = null;
    protected PrefsToolbar prefsPane = null;
    protected PrefIndicatorPanel delegateRenderer = new PrefIndicatorPanel();
    protected Color textBGColor = null;
    protected Color badSearchColor = new Color(255, 235, 235);
    protected Component currentComp = null;
    protected SkinItem skinItem = null;
    protected Hashtable<String, Component> compsHash = new Hashtable();
    protected String firstPanelName = null;
    protected Hashtable<String, PrefsPanelIFace> prefPanelsHash = new Hashtable();

    public PreferencesDlg(boolean addSearchUI) {
        super((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("PreferencesDlg.PREFERENCES"), true, 7, null);
        this.skinItem = SkinsMgr.getSkinItem("PrefDlg");
        this.glassPane = new SimpleGlassPane("", 24, false);
        this.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
        this.glassPane.setFillColor(new Color(0, 0, 0, 96));
        this.glassPane.setDelegateRenderer(this.delegateRenderer);
        this.createUI();
        this.initAsToolbar(addSearchUI);
        this.pack();
        this.okBtn.setEnabled(false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @Override
    protected JPanel createMainPanel() {
        JTiledPanel panel = new JTiledPanel();
        if (this.skinItem != null) {
            this.skinItem.setupPanel(panel);
        }
        panel.setLayout(new BorderLayout());
        return panel;
    }

    protected void initAsToolbar(boolean addSearchUI) {
        this.prefsToolbar = new PrefsToolbar(this);
        this.prefsToolbar.setOpaque(false);
        if (this.prefsToolbar.getNumPrefs() > 1) {
            JPanel panel = new JPanel();
            if (this.skinItem != null) {
                this.skinItem.setupPanel(panel);
            }
            PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "p"), panel);
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.prefsToolbar, cc.xy(1, 1));
            if (addSearchUI) {
                ((ToolbarLayoutManager)this.prefsToolbar.getLayout()).setAdjustRightLastComp(true);
                this.prefsToolbar.add(this.createSearchPanel());
            }
            this.mainPanel.add((Component)builder.getPanel(), "North");
            this.prefsToolbar.setPreferredSize(this.prefsToolbar.getPreferredSize());
            this.prefsToolbar.setSize(this.prefsToolbar.getPreferredSize());
        }
        this.showPanel(this.firstPanelName);
        this.addDataChangeListeners();
    }

    @Override
    protected void cancelButtonPressed() {
        this.removeDataChangeListeners();
        super.cancelButtonPressed();
    }

    @Override
    protected void okButtonPressed() {
        final Properties changesHash = new Properties();
        if (!this.saveChangedPrefs(changesHash)) {
            return;
        }
        super.okButtonPressed();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandAction cmdAction = new CommandAction(PreferencesDlg.PREFERENCES, "Updated", AppPreferences.getRemote());
                cmdAction.addProperties(changesHash);
                CommandDispatcher.dispatch(cmdAction);
            }
        });
    }

    protected void removeDataChangeListeners() {
        for (PrefsPanelIFace pp : this.prefPanelsHash.values()) {
            if (pp.getValidator() == null) continue;
            pp.getValidator().removeDataChangeListener(this);
        }
    }

    protected synchronized boolean saveChangedPrefs(Properties changesHash) {
        for (PrefsPanelIFace pp : this.prefPanelsHash.values()) {
            if (((PrefsSavable)((Object)pp)).isOKToSave()) continue;
            return false;
        }
        for (PrefsPanelIFace pp : this.prefPanelsHash.values()) {
            pp.getChangedFields(changesHash);
            ((PrefsSavable)((Object)pp)).savePrefs();
        }
        try {
            AppPreferences.getRemote().flush();
        }
        catch (BackingStoreException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(PreferencesDlg.class, ex);
            log.error((Object)ex);
        }
        return true;
    }

    protected void initAsGrid(boolean addSearchUI) {
        PanelBuilder builder = new PanelBuilder(new FormLayout("l:p", "p"));
        CellConstraints cc = new CellConstraints();
        JButton showAllBtn = UIHelper.createButton(UIRegistry.getResourceString("PreferencesDlg.SHOW_ALL"));
        builder.add((Component)showAllBtn, cc.xy(1, 1));
        if (addSearchUI) {
            ((ToolbarLayoutManager)this.prefsToolbar.getLayout()).setAdjustRightLastComp(true);
            this.prefsToolbar.add(this.createSearchPanel());
        }
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mainPanel.add((Component)builder.getPanel(), "North");
        this.prefsPane = new PrefsToolbar(this);
        this.firstPanelName = "Main";
        this.addPanel(this.firstPanelName, this.prefsPane);
        this.showPanel(this.firstPanelName);
        showAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDlg.this.showPanel(PreferencesDlg.this.firstPanelName);
            }
        });
    }

    @Override
    public void showPanel(String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            Component comp = this.compsHash.get(name);
            if (comp == this.currentComp) {
                log.error((Object)String.format("The pref pane by the name '%s' is was not found.", name));
                return;
            }
            boolean makeVis = false;
            Dimension oldSize = null;
            if (this.currentComp != null) {
                oldSize = this.currentComp.getSize();
            } else {
                makeVis = true;
            }
            String hContext = this.prefPanelsHash.get(name).getHelpContext();
            if (StringUtils.isNotEmpty((String)hContext)) {
                HelpMgr.registerComponent((AbstractButton)this.helpBtn, hContext);
            }
            if (comp != null) {
                if (this.currentComp == null) {
                    comp.setVisible(makeVis);
                    this.mainPanel.add(comp, "Center");
                    comp.invalidate();
                    this.doLayout();
                    this.repaint();
                    this.currentComp = comp;
                    return;
                }
                if (oldSize != null) {
                    ((PrefsPanelIFace)((Object)this.currentComp)).setShadeColor(new Color(255, 255, 255, 0));
                    new Timer(this.MILLI_SEC_DELAY, new FadeOutAnimation(comp, oldSize, 12)).start();
                }
            }
        }
    }

    @Override
    public boolean addPanel(String name, Component comp) {
        if (this.compsHash.get(name) != null) {
            log.error((Object)String.format("PrePanel with name '%s'has already been added.", name));
            return false;
        }
        this.compsHash.put(name, comp);
        if (!(comp instanceof PrefsSavable) || !(comp instanceof PrefsPanelIFace)) {
            return false;
        }
        if (comp instanceof PrefsPanelIFace) {
            PrefsPanelIFace pp = (PrefsPanelIFace)((Object)comp);
            this.prefPanelsHash.put(name, pp);
        } else {
            log.error((Object)String.format("PrePanel with name '%s' doesn't implement the xxx interface.", name));
        }
        if (this.firstPanelName == null) {
            this.firstPanelName = name;
        }
        return true;
    }

    protected void addDataChangeListeners() {
        for (PrefsPanelIFace pp : this.prefPanelsHash.values()) {
            if (pp.getValidator() == null) continue;
            pp.getValidator().addDataChangeListener(this);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            this.doLayout();
            Dimension size = this.getPreferredSize();
            size.width = Math.max(size.width, 400);
            size.height = Math.max(size.height, 250);
            this.setPreferredSize(size);
            this.setSize(size);
            UIHelper.centerWindow(this);
        }
        super.setVisible(visible);
    }

    protected void doPrefSearch() {
    }

    protected JPanel createSearchPanel() {
        DocumentAdaptor searchDL = new DocumentAdaptor(){

            @Override
            protected void changed(DocumentEvent e) {
                PreferencesDlg.this.delegateRenderer.clearArrows();
                int i = 0;
                while (i < PreferencesDlg.this.prefsToolbar.getComponentCount()) {
                    Component c = PreferencesDlg.this.prefsToolbar.getComponent(i);
                    if (c instanceof RolloverCommand) {
                        Rectangle r = c.getBounds();
                        PreferencesDlg.this.delegateRenderer.addArrow(r.x + r.width / 2, 10);
                        PreferencesDlg.this.delegateRenderer.setIndexVisible(i, true);
                    }
                    ++i;
                }
                PreferencesDlg.this.glassPane.setMargin(new Insets(PreferencesDlg.this.prefsToolbar.getSize().height, 0, 0, 0));
                PreferencesDlg.this.glassPane.setVisible(true);
                PreferencesDlg.this.glassPane.setUseBGImage(true);
                PreferencesDlg.this.glassPane.setHideOnClick(true);
            }
        };
        this.searchText = new JAutoCompTextField(UIHelper.isMacOS() ? 15 : 22);
        this.searchText.getDocument().addDocumentListener(searchDL);
        SearchBox searchBox = new SearchBox(this.searchText, null);
        return searchBox;
    }

    public void startAnimation(Window window, Component comp, int delta, boolean fullStep) {
        new Timer(10, new SlideInOutAnimation(window, comp, delta, fullStep)).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean closePrefs() {
        if (this.okBtn.isEnabled()) {
            Object[] options = new Object[]{UIRegistry.getResourceString("PrefsDlg.SAVE_PREFS"), UIRegistry.getResourceString("PrefsDlg.DONT_SAVE_PREFS"), UIRegistry.getResourceString("CANCEL")};
            int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("PrefsDlg.MSG"), UIRegistry.getResourceString("PREFERENCES"), 1, 3, null, options, options[0]);
            if (userChoice == 0) {
                this.okButtonPressed();
                return true;
            } else {
                if (userChoice != 1) return false;
                this.cancelButtonPressed();
            }
            return true;
        } else {
            this.cancelButtonPressed();
        }
        return true;
    }

    protected boolean areThePrefsOK() {
        boolean okToEnable = true;
        for (PrefsPanelIFace pp : this.prefPanelsHash.values()) {
            if (pp.isFormValid() || pp.getValidator() == null || !pp.getValidator().hasChanged()) continue;
            log.debug((Object)("false=" + pp.getValidator().getName() + " " + pp.isFormValid() + "  " + pp.getValidator() + "  " + pp.getValidator().hasChanged()));
            okToEnable = false;
            break;
        }
        return okToEnable;
    }

    protected void showAndResizePane(Component comp, Dimension oldSize) {
        this.mainPanel.remove(this.currentComp);
        this.currentComp.setVisible(false);
        this.mainPanel.add(comp, "Center");
        comp.invalidate();
        comp.validate();
        comp.invalidate();
        comp.doLayout();
        comp.repaint();
        this.doLayout();
        this.repaint();
        this.currentComp = comp;
        this.currentComp.setVisible(true);
        Dimension oldWinDim = this.getSize();
        Dimension winDim = this.getSize();
        winDim.width += this.currentComp.getPreferredSize().width - oldSize.width;
        winDim.width = Math.max(winDim.width, 400);
        winDim.height = Math.max(winDim.height, 250);
        Dimension pSize = this.prefsToolbar.getPreferredSize();
        winDim.width = Math.max(winDim.width, pSize.width + 30);
        if (winDim.equals(oldWinDim)) {
            winDim.height += 2;
        }
        this.setSize(winDim);
        this.currentComp.setSize(new Dimension(this.currentComp.getPreferredSize().width, oldSize.height));
        this.mainPanel.invalidate();
        this.mainPanel.validate();
        this.mainPanel.invalidate();
        this.mainPanel.doLayout();
        this.mainPanel.repaint();
        this.invalidate();
        this.validate();
        this.invalidate();
        this.doLayout();
        this.doLayout();
        this.repaint();
        ((PrefsPanelIFace)((Object)comp)).setShadeColor(null);
        comp.setVisible(true);
        winDim.height += this.currentComp.getPreferredSize().height - oldSize.height;
        winDim.height = Math.max(winDim.height, 250);
        this.setSize(winDim);
    }

    @Override
    public void dataChanged(String name, Component comp, DataChangeNotifier dcn) {
        this.okBtn.setEnabled(this.areThePrefsOK());
    }

    private class FadeInAnimation
    implements ActionListener {
        private int delta;
        private Component comp;
        private int alpha = 255;
        private Long startTime = null;

        FadeInAnimation(Component comp, int delta) {
            this.delta = delta;
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int elapsedTime;
            this.alpha -= this.delta;
            if (this.startTime != null && (elapsedTime = (int)(System.currentTimeMillis() - this.startTime)) > PreferencesDlg.this.MAX_DELAY) {
                this.alpha = 0;
            }
            this.startTime = System.currentTimeMillis();
            ((PrefsPanelIFace)((Object)this.comp)).setShadeColor(new Color(255, 255, 255, Math.max(this.alpha, 0)));
            if (this.alpha <= 0) {
                ((PrefsPanelIFace)((Object)this.comp)).setShadeColor(null);
                ((Timer)e.getSource()).stop();
            }
            this.comp.repaint();
        }
    }

    private class FadeOutAnimation
    implements ActionListener {
        private int delta;
        private int alpha = 0;
        private Component comp;
        private Dimension oldSize;
        private Long startTime = null;

        FadeOutAnimation(Component comp, Dimension oldSize, int delta) {
            this.delta = delta;
            this.comp = comp;
            this.oldSize = oldSize;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int elapsedTime;
                this.alpha += this.delta;
                if (this.startTime != null && (elapsedTime = (int)(System.currentTimeMillis() - this.startTime)) > PreferencesDlg.this.MAX_DELAY) {
                    this.alpha = 255;
                }
                this.startTime = System.currentTimeMillis();
                Color bc = PreferencesDlg.this.currentComp.getBackground();
                ((PrefsPanelIFace)((Object)PreferencesDlg.this.currentComp)).setShadeColor(new Color(bc.getRed(), bc.getGreen(), bc.getBlue(), Math.min(this.alpha, 255)));
                if (this.alpha >= 255) {
                    ((PrefsPanelIFace)((Object)PreferencesDlg.this.currentComp)).setShadeColor(null);
                    ((Timer)e.getSource()).stop();
                    PreferencesDlg.this.showAndResizePane(this.comp, this.oldSize);
                }
                PreferencesDlg.this.currentComp.validate();
                PreferencesDlg.this.currentComp.repaint();
                this.comp.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class SlideInOutAnimation
    implements ActionListener {
        private int endHeight;
        private int delta;
        private int pixelStep;
        private Window window;
        private Rectangle rect;
        private Component comp;

        SlideInOutAnimation(Window window, Component comp, int delta, boolean fullStep) {
            this.window = window;
            this.delta = delta;
            this.comp = comp;
            this.rect = window.getBounds();
            this.endHeight = this.rect.height + delta;
            this.pixelStep = fullStep ? delta : delta / 10;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.rect.height += this.pixelStep;
            this.delta -= this.pixelStep;
            if (this.delta < 0 && this.pixelStep > 0) {
                this.rect.height = this.endHeight;
                this.comp.setVisible(true);
                ((Timer)e.getSource()).stop();
            } else if (this.delta > 0 && this.pixelStep < 0) {
                this.rect.height = this.endHeight;
                this.comp.setVisible(true);
                ((Timer)e.getSource()).stop();
            }
            this.window.setBounds(this.rect);
        }
    }
}

