/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class PrefPanelRowLayoutManager
implements LayoutManager,
LayoutManager2 {
    private List<Component> comps = new ArrayList<Component>();
    private Dimension preferredSize = new Dimension();
    private Dimension preferredCellSize = new Dimension(32, 32);
    private Dimension actualCellSize = null;
    private Dimension actualRowSize = null;
    private int ySeparation = 5;
    private int xSeparation = 10;
    private int titleSeparation = 2;
    private int maxNumItems = 0;
    private JLabel title = null;

    public PrefPanelRowLayoutManager(JLabel title) {
        this.title = title;
    }

    public void setActualCellSize(Dimension actualCellSize) {
        this.actualCellSize = actualCellSize;
    }

    public void setActualRowSize(Dimension actualRowSize) {
        this.actualRowSize = actualRowSize;
    }

    public Dimension getPreferredCellSize() {
        return this.preferredCellSize;
    }

    public void setMaxNumItems(int maxNumItems) {
        this.maxNumItems = maxNumItems;
    }

    public int getActualWidth(Dimension cellSize) {
        return Math.max(this.comps.size() * (cellSize.width + this.xSeparation) + this.xSeparation, this.title.getPreferredSize().width + 2 * this.xSeparation);
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
        if (arg1 == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        if (arg1 != this.title) {
            this.comps.add(arg1);
        }
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Null component in removeLayoutComponent");
        }
        this.comps.remove(arg0);
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int x = this.xSeparation;
            int y = this.ySeparation;
            int xSep = (this.actualRowSize.width - this.actualCellSize.width * this.maxNumItems) / (this.maxNumItems + 1);
            Dimension size = this.title.getPreferredSize();
            this.title.setBounds(x, y, size.width, size.height);
            int height = this.actualRowSize.height - (y += size.height + this.titleSeparation);
            y += (height - this.actualCellSize.height) / 2;
            for (Component comp : this.comps) {
                comp.setBounds(x, y, this.actualCellSize.width, this.actualCellSize.height);
                x += this.actualCellSize.width + xSep;
            }
        }
    }

    protected void calcPreferredSize() {
        Dimension titleSize = this.title.getPreferredSize();
        int labelWidth = titleSize.width + 2 * this.xSeparation;
        this.preferredSize.setSize(this.xSeparation, titleSize.height + 2 * this.ySeparation + this.titleSeparation);
        this.preferredCellSize.setSize(0, 0);
        int maxHeight = 0;
        for (Component comp : this.comps) {
            Dimension size = comp.getPreferredSize();
            this.preferredCellSize.width = Math.max(this.preferredCellSize.width, size.width);
            this.preferredCellSize.height = Math.max(this.preferredCellSize.height, size.height);
            this.preferredSize.width += size.width + this.xSeparation;
            maxHeight = Math.max(maxHeight, size.height);
        }
        this.preferredSize.width = Math.max(this.preferredSize.width, labelWidth);
        this.preferredSize.height += maxHeight;
    }

    public List<Component> getComponentList() {
        return this.comps;
    }

    public void removeAll() {
        this.comps.clear();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        if (comp != this.title) {
            this.comps.add(comp);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.preferredSize.setSize(0, 0);
        this.calcPreferredSize();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.calcPreferredSize();
        return new Dimension(this.preferredSize);
    }
}

