/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.Pair;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class PrefIndicatorPanel
implements SimpleGlassPane.DelegateRenderer {
    private Vector<Pair<Shape, Boolean>> arrows = new Vector();

    public void clearArrows() {
        this.arrows.clear();
    }

    public void addArrow(int x, int y) {
        GeneralPath gp = new GeneralPath();
        int sz = 10;
        int[] xpnts = new int[]{x, x + sz, x + sz / 4, x + sz / 2, x - sz / 2, x - sz / 4, x - sz, x};
        int[] ypnts = new int[]{y, y + sz * 2, y + sz * 2, y + sz * 4, y + sz * 4, y + sz * 2, y + sz * 2, y};
        gp.moveTo(xpnts[0], ypnts[0]);
        int i = 0;
        while (i < xpnts.length) {
            gp.lineTo(xpnts[i], ypnts[i]);
            ++i;
        }
        gp.closePath();
        this.arrows.add(new Pair<GeneralPath, Boolean>(gp, false));
    }

    public void setIndexVisible(int inx, boolean visible) {
        Pair<Shape, Boolean> pair = this.arrows.get(inx);
        pair.second = visible;
    }

    @Override
    public void render(Graphics2D compG, Graphics2D imgG, BufferedImage bufImg) {
        imgG.setComposite(AlphaComposite.Src);
        imgG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        imgG.setColor(new Color(0, 0, 0, 0));
        for (Pair<Shape, Boolean> shape : this.arrows) {
            if (!((Boolean)shape.second).booleanValue()) continue;
            imgG.fill((Shape)shape.first);
            UIHelper.paintBorderGlow(imgG, (Shape)shape.first, 6);
        }
    }
}

