/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.auth.SecurityMgr;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.PrefsPanelIFace;
import edu.ku.brc.af.prefs.PrefsPanelMgrIFace;
import edu.ku.brc.af.prefs.PrefsSavable;
import edu.ku.brc.af.ui.forms.FormViewObj;
import edu.ku.brc.af.ui.forms.ViewFactory;
import edu.ku.brc.af.ui.forms.Viewable;
import edu.ku.brc.af.ui.forms.persist.ViewIFace;
import edu.ku.brc.af.ui.forms.validation.FormValidator;
import edu.ku.brc.af.ui.forms.validation.UIValidatable;
import edu.ku.brc.af.ui.forms.validation.UIValidator;
import edu.ku.brc.ui.GetSetValueIFace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GenericPrefsPanel
extends JPanel
implements PrefsSavable,
PrefsPanelIFace {
    private static final Logger log = Logger.getLogger(GenericPrefsPanel.class);
    private static final String prefsPrefix = "Prefs.";
    protected String name;
    protected String title;
    protected ViewIFace formView = null;
    protected Viewable form = null;
    protected String hContext = null;
    protected Color shadeColor = null;
    protected PrefsPanelMgrIFace mgr = null;
    protected PermissionIFace permissions = null;

    public GenericPrefsPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void createForm(String viewSetName, String viewName) {
        this.formView = AppContextMgr.getInstance().getView(viewSetName, viewName);
        if (this.formView != null) {
            UIValidator.setIgnoreAllValidation(this, true);
            ViewFactory.setFormTransparent(true);
            this.form = ViewFactory.createFormView(null, this.formView, null, null, 0, null);
            if (this.form != null) {
                ViewFactory.setFormTransparent(false);
                this.form.setDataObj(AppPreferences.getRemote());
                UIValidator.setIgnoreAllValidation(this, false);
                if (this.form.getUIComponent() instanceof JPanel) {
                    ((JPanel)this.form.getUIComponent()).setOpaque(false);
                }
                this.add(this.form.getUIComponent(), "Center");
                this.form.getValidator().validateForm();
            }
        } else {
            log.error((Object)("Couldn't load form with name [" + viewSetName + "] Id [" + viewName + "]"));
        }
    }

    @Override
    public void getChangedFields(Properties changeHash) {
        FormViewObj fvo = (FormViewObj)this.form;
        if (this.form != null) {
            Hashtable<String, String> idToNameHash = fvo.getIdToNameHash();
            Vector<String> ids = new Vector<String>();
            fvo.getFieldIds(ids);
            for (String id : ids) {
                String value;
                String nameForHash;
                Component comp = (Component)fvo.getCompById(id);
                if (!(comp instanceof UIValidatable) || !((UIValidatable)((Object)comp)).isChanged() || !StringUtils.isNotEmpty((String)(nameForHash = idToNameHash.get(id)))) continue;
                String string = value = comp instanceof GetSetValueIFace ? ((GetSetValueIFace)((Object)comp)).getValue() : "";
                if (value == null) continue;
                changeHash.put(nameForHash, value);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.shadeColor != null) {
            Dimension size = this.getSize();
            g.setColor(this.shadeColor);
            g.fillRect(0, 0, size.width, size.height);
        }
    }

    @Override
    public boolean isOKToSave() {
        return true;
    }

    @Override
    public void savePrefs() {
        if (this.form != null && (this.form.getValidator() == null || this.form.getValidator().hasChanged())) {
            this.form.getDataFromUI();
        }
    }

    @Override
    public FormValidator getValidator() {
        return this.form != null ? this.form.getValidator() : null;
    }

    @Override
    public boolean isFormValid() {
        return this.form != null ? this.form.getValidator().getState() == UIValidatable.ErrorType.Valid : false;
    }

    @Override
    public boolean isOKToLoad() {
        return true;
    }

    @Override
    public PermissionIFace getPermissions() {
        if (this.permissions == null) {
            this.permissions = SecurityMgr.getInstance().getPermission(prefsPrefix + this.getPermissionName());
        }
        return this.permissions;
    }

    protected String getPermissionName() {
        return this.name;
    }

    @Override
    public void setPermissions(PermissionIFace permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setPrefsPanelMgr(PrefsPanelMgrIFace mgrArg) {
        this.mgr = mgrArg;
    }

    @Override
    public String getHelpContext() {
        return this.hContext;
    }

    @Override
    public void setHelpContext(String context) {
        this.hContext = context;
    }

    @Override
    public void setShadeColor(Color color) {
        this.shadeColor = color;
    }
}

