/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.BiColorTableCellRenderer;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class AppPrefsEditor
extends JPanel
implements TableModelListener,
ListSelectionListener {
    protected boolean doRemote = false;
    protected JTable table;
    protected PropertyTableModel model;
    protected Vector<String> items = new Vector();
    protected AppPreferences appPrefs;
    protected JButton removeBtn;
    protected JButton addBtn;

    public AppPrefsEditor(AppPreferences preferences) {
        this.appPrefs = preferences;
        Enumeration<Object> enumerator = this.appPrefs.getProperties().keys();
        while (enumerator.hasMoreElements()) {
            this.items.add((String)enumerator.nextElement());
        }
        Collections.sort(this.items);
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    protected void createUI() {
        this.model = new PropertyTableModel(this.items);
        this.table = new JTable(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.add((Component)UIHelper.createScrollPane(this.table), "Center");
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setDefaultRenderer(String.class, new BiColorTableCellRenderer(false));
        this.addBtn = UIHelper.createButton(UIRegistry.getResourceString("AppPrefsEditor.ADD_PROPERTY"));
        this.removeBtn = UIHelper.createButton(UIRegistry.getResourceString("AppPrefsEditor.REMOVE_PROPERTY"));
        this.removeBtn.setEnabled(false);
        PanelBuilder pb = new PanelBuilder(new FormLayout("f:p:g,p,f:p:g,p,f:p:g", "p,10px"));
        CellConstraints cc = new CellConstraints();
        pb.add((Component)this.addBtn, cc.xy(2, 1));
        pb.add((Component)this.removeBtn, cc.xy(4, 1));
        this.add((Component)pb.getPanel(), "South");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPrefsEditor.this.removeItem();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPrefsEditor.this.addItem();
            }
        });
    }

    public void removeItem() {
        int inx = this.table.getSelectedRow();
        if (inx != -1) {
            this.appPrefs.remove((String)this.model.getValueAt(inx, 0));
            this.items.remove(this.table.getSelectedRow());
            this.removeBtn.setEnabled(false);
            this.table.repaint();
            this.appPrefs.setChanged(true);
            this.table.getSelectionModel().clearSelection();
            try {
                this.appPrefs.flush();
            }
            catch (BackingStoreException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AppPrefsEditor.class, ex);
            }
        }
    }

    protected void addItem() {
        String newKey = "New Item" + this.items.size();
        this.items.add(newKey);
        this.model.fireChange();
        int row = this.items.size() - 1;
        Rectangle rect = this.table.getCellRect(row, 0, true);
        this.table.scrollRectToVisible(rect);
        this.table.clearSelection();
        this.table.setRowSelectionInterval(row, row);
        this.appPrefs.setChanged(true);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.removeBtn.setEnabled(this.table.getSelectedRow() != -1);
        }
    }

    public class PropertyTableModel
    extends DefaultTableModel {
        protected Vector<String> rowData = null;
        protected String[] header = new String[]{"Property", "Value"};

        public PropertyTableModel(Vector<String> rowData) {
            this.rowData = rowData;
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.header[column];
        }

        @Override
        public int getRowCount() {
            return this.rowData == null ? 0 : this.rowData.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            String key = this.rowData.get(row);
            return column == 0 ? key : AppPrefsEditor.this.appPrefs.get(key, "");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return this.rowData.get(row).startsWith("New Item");
            }
            return true;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String key = this.rowData.get(rowIndex);
            if (columnIndex == 0) {
                this.rowData.remove(rowIndex);
                this.rowData.insertElementAt((String)aValue, rowIndex);
            } else {
                AppPrefsEditor.this.appPrefs.put(key, aValue.toString());
            }
        }

        public void fireChange() {
            this.fireTableDataChanged();
        }
    }
}

