/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.BackingStoreException;

public class AppPrefsDiskIOIImpl
implements AppPreferences.AppPrefsIOIFace {
    protected AppPreferences appPrefsMgr = null;

    @Override
    public void setAppPrefsMgr(AppPreferences appPrefsMgr) {
        this.appPrefsMgr = appPrefsMgr;
    }

    @Override
    public boolean isAvailable() {
        return this.appPrefsMgr.getDirPath() != null && this.appPrefsMgr.getDirPath().length() > 0;
    }

    protected void checkForAppPrefs() {
        if (this.appPrefsMgr == null) {
            throw new RuntimeException("The AppPreferences is null for " + this.getClass().getCanonicalName());
        }
    }

    protected void checkPath() {
        this.checkForAppPrefs();
        if (!this.isAvailable()) {
            throw new RuntimeException("The directory path for the prefs [" + this.appPrefsMgr.getDirPath() + "] [" + this.appPrefsMgr.getLocalFileName() + "] cannot be empty!");
        }
    }

    @Override
    public boolean exists() {
        this.checkPath();
        File file = new File(String.valueOf(this.appPrefsMgr.getDirPath()) + File.separator + this.appPrefsMgr.getLocalFileName());
        return file.exists();
    }

    @Override
    public Date lastSavedDate() {
        this.checkPath();
        File file = new File(String.valueOf(this.appPrefsMgr.getDirPath()) + File.separator + this.appPrefsMgr.getLocalFileName());
        return file.exists() ? new Date(file.lastModified()) : null;
    }

    @Override
    public void load() {
        this.checkPath();
        if (this.appPrefsMgr.getProperties() != null) {
            if (!this.appPrefsMgr.getDirPath().equals(this.appPrefsMgr.getDirPath())) {
                throw new RuntimeException("The AppPrefs have already been loaded! [" + this.appPrefsMgr.getDirPath() + "]");
            }
        } else {
            String fullName = String.valueOf(this.appPrefsMgr.getDirPath()) + File.separator + this.appPrefsMgr.getLocalFileName();
            Properties properties = new Properties();
            this.appPrefsMgr.setProperties(properties);
            if (new File(fullName).exists()) {
                try {
                    properties.load(new FileInputStream(fullName));
                }
                catch (IOException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(AppPrefsDiskIOIImpl.class, ex);
                    throw new RuntimeException(ex);
                }
            }
            this.appPrefsMgr.setProperties(properties);
        }
    }

    @Override
    public void flush() throws BackingStoreException {
        this.checkPath();
        if (this.appPrefsMgr.getProperties() == null) {
            throw new RuntimeException("AppPrefs properties has not been initialized or loaded. " + this.appPrefsMgr.getLocalFileName());
        }
        if (this.appPrefsMgr.isChanged()) {
            try {
                String fullName = String.valueOf(this.appPrefsMgr.getDirPath()) + File.separator + this.appPrefsMgr.getLocalFileName();
                this.appPrefsMgr.getProperties().store(new FileOutputStream(fullName), "User Prefs");
                this.appPrefsMgr.setChanged(false);
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AppPrefsDiskIOIImpl.class, ex);
                throw new BackingStoreException(ex);
            }
        }
    }
}

