/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.prefs.AppPrefsCacheEntry;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.ui.ColorWrapper;
import edu.ku.brc.ui.DateWrapper;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;

public class AppPrefsCache {
    protected static final String NOT_INIT = "AppPrefs have not been initialized.";
    protected static final String BAD_ARGS = "Empty fully qualified pref name.";
    protected static AppPrefsCache instance = new AppPrefsCache();
    protected static boolean useLocalOnly = false;
    protected Hashtable<String, AppPrefsCacheEntry> hash = new Hashtable();

    protected AppPrefsCache() {
    }

    public static AppPrefsCache getInstance() {
        return instance;
    }

    public static void reset() {
        AppPrefsCache.instance.hash.clear();
    }

    protected static String makeKey(String section, String pref, String attrName) {
        return String.valueOf(section) + "." + pref + "." + attrName;
    }

    protected static void checkName(String section, String pref, String attrName) {
        if (StringUtils.isEmpty((String)section) || StringUtils.isEmpty((String)pref) || StringUtils.isEmpty((String)attrName)) {
            throw new RuntimeException(BAD_ARGS);
        }
    }

    protected static AppPreferences getPref() {
        return useLocalOnly ? AppPreferences.getLocalPrefs() : AppPreferences.getRemote();
    }

    public static void setUseLocalOnly(boolean useLocalOnly) {
        AppPrefsCache.useLocalOnly = useLocalOnly;
    }

    public static void addChangeListener(String name, AppPrefsChangeListener l) {
        AppPrefsCache.getPref().addChangeListener(name, l);
    }

    public static void removeChangeListener(String name, AppPrefsChangeListener l) {
        AppPrefsCache.getPref().removeChangeListener(name, l);
    }

    protected AppPrefsCacheEntry registerInternal(String section, String pref, String attrName, String defValue) {
        AppPrefsCache.checkName(section, pref, attrName);
        String name = AppPrefsCache.makeKey(section, pref, attrName);
        AppPrefsCacheEntry prefsCacheEntry = this.hash.get(name);
        if (prefsCacheEntry == null) {
            prefsCacheEntry = new AppPrefsCacheEntry(attrName, AppPreferences.getRemote().get(name, defValue), defValue);
            AppPrefsCache.getPref().addChangeListener(name, prefsCacheEntry);
            this.hash.put(AppPrefsCache.makeKey(section, pref, attrName), prefsCacheEntry);
        }
        return prefsCacheEntry;
    }

    public static void register(String section, String pref, String attrName, String defValue) {
        AppPrefsCache.getInstance().registerInternal(section, pref, attrName, defValue);
    }

    public static boolean remove(String section, String pref, String attrName) {
        AppPrefsCache.checkName(section, pref, attrName);
        String name = AppPrefsCache.makeKey(section, pref, attrName);
        AppPrefsCache.getPref().remove(name);
        AppPrefsCache.getInstance().hash.remove(name);
        return true;
    }

    public static String getValue(String section, String pref, String attrName) {
        AppPrefsCache.checkName(section, pref, attrName);
        AppPrefsCacheEntry prefsCacheEntry = AppPrefsCache.getInstance().hash.get(AppPrefsCache.makeKey(section, pref, attrName));
        return prefsCacheEntry != null ? prefsCacheEntry.getValue() : "";
    }

    protected String checkForPref(String fullName, String defValue) {
        String prefVal;
        AppPreferences appPrefs = AppPrefsCache.getPref();
        if (!appPrefs.exists(fullName)) {
            appPrefs.put(fullName, defValue);
            prefVal = defValue;
        } else {
            prefVal = appPrefs.get(fullName, defValue);
        }
        return prefVal;
    }

    public void registerInternal(ColorWrapper colorWrapper, String section, String pref, String attrName) {
        AppPreferences appPrefs = AppPrefsCache.getPref();
        AppPrefsCache.checkName(section, pref, attrName);
        String fullName = AppPrefsCache.makeKey(section, pref, attrName);
        if (this.hash.get(fullName) == null) {
            String defValue = colorWrapper.toString();
            String prefVal = this.checkForPref(fullName, defValue);
            colorWrapper.setRGB(prefVal);
            ColorCacheEntry colorEntry = new ColorCacheEntry(colorWrapper, fullName, prefVal, defValue);
            appPrefs.addChangeListener(fullName, colorEntry);
            this.hash.put(fullName, colorEntry);
        }
    }

    public static void register(ColorWrapper color, String section, String pref, String attrName) {
        AppPrefsCache.getInstance().registerInternal(color, section, pref, attrName);
    }

    public static ColorWrapper getColorWrapper(String section, String pref, String attrName) {
        AppPrefsCache.checkName(section, pref, attrName);
        return AppPrefsCache.getColorWrapper(AppPrefsCache.makeKey(section, pref, attrName));
    }

    public static ColorWrapper getColorWrapper(String fullName) {
        ColorCacheEntry colorEntry = (ColorCacheEntry)AppPrefsCache.getInstance().hash.get(fullName);
        if (colorEntry != null) {
            return colorEntry.getColorWrapper();
        }
        return null;
    }

    public void registerInternal(SimpleDateFormat simpleFormat, String section, String pref, String attrName) {
        AppPrefsCache.checkName(section, pref, attrName);
        String fullName = AppPrefsCache.makeKey(section, pref, attrName);
        if (this.hash.get(fullName) == null) {
            String defValue = simpleFormat.toPattern();
            String prefVal = this.checkForPref(fullName, defValue);
            if (prefVal.length() == 8 && StringUtils.countMatches((String)prefVal, (String)"yyyy") == 0) {
                prefVal = StringUtils.replace((String)prefVal, (String)"yy", (String)"yyyy");
            }
            simpleFormat.applyPattern(prefVal);
            DateFormatCacheEntry dateEntry = new DateFormatCacheEntry(simpleFormat, fullName, prefVal, defValue);
            AppPrefsCache.getPref().addChangeListener(fullName, dateEntry);
            this.hash.put(fullName, dateEntry);
        }
    }

    public static void register(SimpleDateFormat simpleFormat, String section, String pref, String attrName) {
        AppPrefsCache.getInstance().registerInternal(simpleFormat, section, pref, attrName);
    }

    public static SimpleDateFormat getDefaultDatePattern() {
        boolean debug = AppPreferences.getLocalPrefs().getBoolean("DEBUG.DATES", false);
        SimpleDateFormat sdf = new SimpleDateFormat();
        String[] pieces = sdf.toPattern().split(" ");
        if (pieces != null) {
            String pattern = pieces[0];
            if (debug) {
                System.out.println("[" + pattern + "][" + sdf.toPattern() + "]");
                System.out.println("Months: " + StringUtils.countMatches((String)pattern, (String)"M"));
                System.out.println("Days:   " + StringUtils.countMatches((String)pattern, (String)"d"));
                System.out.println("Years:  " + StringUtils.countMatches((String)pattern, (String)"y"));
            }
            int months = StringUtils.countMatches((String)pattern, (String)"M");
            int days = StringUtils.countMatches((String)pattern, (String)"d");
            int years = StringUtils.countMatches((String)pattern, (String)"y");
            if (months == 1) {
                pattern = pattern.replace("M", "MM");
            }
            if (days == 1) {
                pattern = pattern.replace("d", "dd");
            }
            if (years == 2) {
                pattern = pattern.replace("yy", "yyyy");
            }
            if (debug) {
                System.out.println(pattern);
                System.out.println("Months: " + StringUtils.countMatches((String)pattern, (String)"M"));
                System.out.println("Days:   " + StringUtils.countMatches((String)pattern, (String)"d"));
                System.out.println("Years:  " + StringUtils.countMatches((String)pattern, (String)"y"));
            }
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat("MM/dd/yyyy");
    }

    public static DateWrapper getDateWrapper(String section, String pref, String attrName) {
        AppPrefsCache.checkName(section, pref, attrName);
        DateFormatCacheEntry dateEntry = (DateFormatCacheEntry)AppPrefsCache.getInstance().hash.get(AppPrefsCache.makeKey(section, pref, attrName));
        if (dateEntry != null) {
            return dateEntry.getDateWrapper();
        }
        AppPrefsCache appPrefsCache = instance;
        appPrefsCache.getClass();
        dateEntry = appPrefsCache.new DateFormatCacheEntry(AppPrefsCache.getDefaultDatePattern(), section, pref, attrName);
        AppPrefsCache.getInstance().hash.put(AppPrefsCache.makeKey(section, pref, attrName), dateEntry);
        return dateEntry.getDateWrapper();
    }

    public class ColorCacheEntry
    extends AppPrefsCacheEntry {
        protected ColorWrapper colorWrapper;

        public ColorCacheEntry(ColorWrapper colorWrapper, String attrName, String value, String defValue) {
            super(attrName, value, defValue);
            this.colorWrapper = colorWrapper;
        }

        @Override
        public void preferenceChange(AppPrefsChangeEvent evt) {
            super.preferenceChange(evt);
            this.colorWrapper.setRGB(this.getValue());
        }

        public ColorWrapper getColorWrapper() {
            return this.colorWrapper;
        }
    }

    public class DateFormatCacheEntry
    extends AppPrefsCacheEntry {
        protected DateWrapper dateWrapper;

        public DateFormatCacheEntry(SimpleDateFormat simpleDateFormat, String attrName, String value, String defValue) {
            super(attrName, value, defValue);
            this.dateWrapper = new DateWrapper(simpleDateFormat);
        }

        public DateFormatCacheEntry(DateWrapper dateWrapper, String attrName, String value, String defValue) {
            super(attrName, value, defValue);
            this.dateWrapper = dateWrapper;
        }

        @Override
        public void preferenceChange(AppPrefsChangeEvent evt) {
            super.preferenceChange(evt);
            this.dateWrapper.getSimpleDateFormat().applyPattern(this.getValue());
        }

        public DateWrapper getDateWrapper() {
            return this.dateWrapper;
        }

        public void setDateWrapper(DateWrapper dateWrapper) {
            this.dateWrapper = dateWrapper;
        }
    }
}

