/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.prefs;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPrefsChangeEvent;
import edu.ku.brc.af.prefs.AppPrefsChangeListener;
import edu.ku.brc.af.prefs.AppPrefsDiskIOIImpl;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.BackingStoreException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AppPreferences {
    public static final String factoryName = "edu.ku.brc.af.prefs.AppPrefsIOIFace";
    public static final String factoryGlobalName = "edu.ku.brc.af.prefs.AppPrefsIOIFaceGlobal";
    public static final String LOCALFILENAME = "user.properties";
    private static final String NOT_INIT = "AppPrefs have not been initialized!";
    protected static final Logger log = Logger.getLogger(AppPreferences.class);
    protected static AppPreferences instanceRemote = null;
    protected static AppPreferences instanceLocal = null;
    protected static AppPreferences instanceGlobal = null;
    protected Properties properties = null;
    protected String dirPath;
    protected boolean isChanged = false;
    protected AppPrefType prefType;
    protected String localFileName = null;
    protected String saverClassName = null;
    protected AppPrefsIOIFace appPrefsIO = null;
    protected boolean isEnabled = true;
    protected Hashtable<String, List<AppPrefsChangeListener>> listeners = new Hashtable();
    protected static Timer syncTimer = null;
    protected static boolean connectedToDB = false;
    protected static AtomicBoolean blockTimer = new AtomicBoolean(false);

    protected AppPreferences(AppPrefType prefType) {
        this.prefType = prefType;
        if (prefType == AppPrefType.remote) {
            this.appPrefsIO = this.createFactoryIO(factoryName);
        } else if (prefType == AppPrefType.global) {
            this.appPrefsIO = this.createFactoryIO(factoryGlobalName);
        } else {
            this.localFileName = LOCALFILENAME;
            this.appPrefsIO = new AppPrefsDiskIOIImpl();
            this.appPrefsIO.setAppPrefsMgr(this);
        }
    }

    private AppPrefsIOIFace createFactoryIO(String factoryNm) {
        this.saverClassName = System.getProperty(factoryNm, null);
        if (this.saverClassName == null) {
            throw new InternalError("System Property '" + factoryNm + "' must be set!");
        }
        AppPrefsIOIFace prefIO = null;
        try {
            prefIO = (AppPrefsIOIFace)Class.forName(this.saverClassName).newInstance();
            prefIO.setAppPrefsMgr(this);
        }
        catch (Exception e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AppPreferences.class, e);
            InternalError error = new InternalError("Can't instantiate " + this.saverClassName + " factory for " + factoryNm);
            error.initCause(e);
            throw error;
        }
        return prefIO;
    }

    public static void setBlockTimer() {
        blockTimer.set(true);
    }

    public static boolean hasRemotePrefs() {
        return instanceRemote != null;
    }

    public static AppPreferences getRemote() {
        if (instanceRemote == null) {
            instanceRemote = new AppPreferences(AppPrefType.remote);
        }
        return instanceRemote;
    }

    public static AppPreferences getGlobalPrefs() {
        if (instanceGlobal == null) {
            instanceGlobal = new AppPreferences(AppPrefType.global);
        }
        return instanceGlobal;
    }

    public static void startup() {
        connectedToDB = true;
    }

    public static void shutdownPrefs() {
        if (syncTimer != null) {
            connectedToDB = false;
            syncTimer.cancel();
            syncTimer.purge();
            syncTimer = null;
        }
    }

    private static void shutdownPref(AppPreferences pref) throws BackingStoreException {
        if (pref != null) {
            if (connectedToDB) {
                pref.flush();
            }
            pref.listeners.clear();
            pref.appPrefsIO = null;
        }
    }

    public static void shutdownRemotePrefs() {
        try {
            blockTimer.set(true);
            AppPreferences.shutdownPref(instanceRemote);
            AppPreferences.shutdownPref(instanceGlobal);
            instanceRemote = null;
            instanceGlobal = null;
            blockTimer.set(false);
        }
        catch (BackingStoreException ex) {
            log.error((Object)ex);
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AppPreferences.class, ex);
        }
    }

    public static void shutdownLocalPrefs() {
        try {
            if (instanceLocal != null && !blockTimer.get()) {
                blockTimer.set(true);
                if (instanceLocal != null) {
                    AppPreferences local = instanceLocal;
                    instanceLocal = null;
                    local.flush();
                    local.listeners.clear();
                    local.appPrefsIO = null;
                }
                blockTimer.set(false);
            }
        }
        catch (BackingStoreException ex) {
            log.error((Object)ex);
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AppPreferences.class, ex);
        }
    }

    public static void shutdownAllPrefs() {
        try {
            AppPreferences.getLocalPrefs().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        AppPreferences.shutdownRemotePrefs();
        AppPreferences.shutdownPrefs();
    }

    public static AppPreferences getLocalPrefs() {
        if (instanceLocal == null) {
            instanceLocal = new AppPreferences(AppPrefType.local);
        }
        return instanceLocal;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isRemote() {
        return this.prefType == AppPrefType.remote;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String get(String name, String defaultValue) {
        return this.get(name, defaultValue, false);
    }

    public String get(String name, String defaultValue, boolean doDefVal) {
        String val;
        if (this.properties == null) {
            this.load();
        }
        if ((val = this.properties.getProperty(name)) == null && doDefVal && defaultValue != null) {
            this.put(name, defaultValue);
        }
        return val != null ? val : defaultValue;
    }

    public void put(String name, String value) {
        if (this.properties == null) {
            this.load();
        }
        this.properties.setProperty(name, value);
        this.isChanged = true;
        this.notifyListeners(new AppPrefsChangeEvent(this, name, value.toString()));
    }

    public Integer getInt(String name, Integer defaultValue) {
        return this.getInt(name, defaultValue, false);
    }

    public Integer getInt(String name, Integer defaultValue, boolean doDefVal) {
        String val = this.get(name, null);
        if (val == null && doDefVal && defaultValue != null) {
            this.putInt(name, defaultValue);
        }
        return val == null ? (defaultValue == null ? null : defaultValue) : Integer.valueOf(val);
    }

    public void putInt(String name, Integer value) {
        this.put(name, value.toString());
    }

    public Long getLong(String name, Long defaultValue) {
        String val = this.get(name, defaultValue == null ? null : Long.toString(defaultValue));
        return val == null ? null : Long.valueOf(val);
    }

    public void putLong(String name, Long value) {
        this.put(name, value.toString());
    }

    public Boolean getBoolean(String name, Boolean defaultValue, boolean doDefVal) {
        String val = this.get(name, null);
        if (val == null && doDefVal && defaultValue != null) {
            this.putBoolean(name, defaultValue);
        }
        return val == null ? (defaultValue == null ? null : defaultValue) : Boolean.valueOf(val);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getBoolean(name, defaultValue, false);
    }

    public void putBoolean(String name, Boolean value) {
        this.put(name, value.toString());
    }

    public Double getDouble(String name, Double defaultValue) {
        String val = this.get(name, defaultValue == null ? null : Double.toString(defaultValue));
        return val == null ? null : Double.valueOf(val);
    }

    public void putDouble(String name, Double value) {
        this.put(name, value.toString());
    }

    public Float getFloat(String name, Float defaultValue) {
        String val = this.get(name, defaultValue == null ? null : Float.toString(defaultValue.floatValue()));
        return val == null ? null : Float.valueOf(val);
    }

    public void putFloat(String name, Float value) {
        this.put(name, value.toString());
    }

    public Color getColor(String name, Color defaultColor, boolean doDefVal) {
        String colorStr = this.get(name, null);
        if (StringUtils.isNotEmpty((String)colorStr)) {
            try {
                return UIHelper.parseRGB(colorStr);
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AppPreferences.class, ex);
            }
        } else {
            this.putColor(name, defaultColor);
        }
        return defaultColor;
    }

    public Color getColor(String name, Color defaultColor) {
        return this.getColor(name, defaultColor, false);
    }

    public void putColor(String name, Color color) {
        this.put(name, String.format("%d, %d, %d", color.getRed(), color.getGreen(), color.getBlue()));
    }

    public void putColor(String name, String color) {
        this.put(name, color);
    }

    public void remove(String name) {
        if (this.properties == null) {
            throw new RuntimeException(NOT_INIT);
        }
        List<AppPrefsChangeListener> list = this.listeners.get(name);
        if (list != null) {
            list.clear();
            this.listeners.remove(name);
        }
        this.properties.remove(name);
        this.isChanged = true;
    }

    public boolean exists(String name) {
        if (this.properties == null) {
            this.load();
        }
        return this.properties.get(name) != null;
    }

    public String[] keys(String nodeName) {
        if (this.properties == null) {
            throw new RuntimeException(NOT_INIT);
        }
        String[] keys = null;
        if (nodeName != null && nodeName.length() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            int len = nodeName.length();
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String nm;
                int inx;
                String name = (String)e.nextElement();
                if (!name.startsWith(nodeName) || (inx = (nm = name.substring(len + 1, name.length())).indexOf(46)) != -1) continue;
                names.add(nm);
            }
            keys = new String[names.size()];
            int inx = 0;
            for (String s : names) {
                keys[inx++] = s;
            }
        } else {
            keys = new String[]{};
        }
        return keys;
    }

    public String[] childrenNames(String nodeName) {
        if (this.properties == null) {
            throw new RuntimeException(NOT_INIT);
        }
        int len = nodeName.length();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> e = this.properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            log.info((Object)("[" + name + "]"));
            if (!name.startsWith(nodeName)) continue;
            String nm = name.substring(len + 1, name.length());
            int inx = nm.indexOf(46);
            int inxLast = nm.lastIndexOf(46);
            if (inx <= 0 || inx != inxLast) continue;
            names.add(nm.substring(0, inx));
        }
        String[] childNames = new String[names.size()];
        int inx = 0;
        for (String s : names) {
            childNames[inx++] = s;
        }
        return childNames;
    }

    public AppPreferences load() {
        if (this.properties == null) {
            if (this.appPrefsIO.exists()) {
                this.appPrefsIO.load();
            } else {
                this.properties = new Properties();
            }
        }
        return this;
    }

    public synchronized void flush() throws BackingStoreException {
        if (this.isChanged && this.properties != null && this.appPrefsIO != null) {
            this.appPrefsIO.flush();
        }
    }

    public void addChangeListener(String name, AppPrefsChangeListener l) {
        if (this.properties == null) {
            throw new RuntimeException(NOT_INIT);
        }
        List<AppPrefsChangeListener> list = this.listeners.get(name);
        if (list == null) {
            list = new ArrayList<AppPrefsChangeListener>();
            this.listeners.put(name, list);
        }
        list.add(l);
    }

    public void removeChangeListener(String name, AppPrefsChangeListener l) {
        if (this.properties == null) {
            throw new RuntimeException(NOT_INIT);
        }
        List<AppPrefsChangeListener> list = this.listeners.get(name);
        if (list != null) {
            list.remove(l);
        }
    }

    public static void setConnectedToDB(boolean connectedToDB) {
        AppPreferences.connectedToDB = connectedToDB;
    }

    protected void notifyListeners(AppPrefsChangeEvent e) {
        List<AppPrefsChangeListener> list = this.listeners.get(e.getKey());
        if (list != null) {
            for (AppPrefsChangeListener l : list) {
                l.preferenceChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void syncPrefs() {
        Class<AppPreferences> clazz = AppPreferences.class;
        synchronized (AppPreferences.class) {
            AppPreferences prefsLocal = instanceLocal;
            AppPreferences prefsRemote = instanceRemote;
            // ** MonitorExit[var2] (shouldn't be in output)
            try {
                if (prefsLocal != null) {
                    prefsLocal.flush();
                }
            }
            catch (BackingStoreException e) {
                log.error((Object)("Couldn't flush the local prefs: " + e));
                e.printStackTrace();
            }
            try {
                if (connectedToDB && prefsRemote != null) {
                    prefsRemote.flush();
                }
            }
            catch (BackingStoreException e) {
                log.error((Object)("Couldn't flush the remote prefs: " + e));
                e.printStackTrace();
            }
            return;
        }
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isAvailable() {
        return this.isEnabled && this.appPrefsIO != null && this.appPrefsIO.isAvailable();
    }

    public Date getLastSavedDate() {
        if (this.appPrefsIO != null) {
            return this.appPrefsIO.lastSavedDate();
        }
        return null;
    }

    public static enum AppPrefType {
        local,
        remote,
        global;

    }

    public static interface AppPrefsIOIFace {
        public void setAppPrefsMgr(AppPreferences var1);

        public boolean exists();

        public Date lastSavedDate();

        public void load();

        public void flush() throws BackingStoreException;

        public boolean isAvailable();
    }
}

