/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.TableNameRendererIFace;

public class TableInfoRenderable
implements TableNameRendererIFace,
Comparable<TableInfoRenderable> {
    protected DBTableInfo tableInfo;
    protected DBFieldInfo fieldInfo;
    protected String title;
    protected String iconName;
    protected SortBy sortBy = SortBy.Table;
    protected Object userData = null;

    public TableInfoRenderable(DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
        this.title = tableInfo.getShortClassName();
        this.iconName = tableInfo.getClassObj().getSimpleName();
    }

    public TableInfoRenderable(DBFieldInfo fieldInfo) {
        this.tableInfo = fieldInfo.getTableInfo();
        this.fieldInfo = fieldInfo;
        this.title = fieldInfo.getColumn();
        this.iconName = this.tableInfo.getClassObj().getSimpleName();
    }

    public TableInfoRenderable(DBTableInfo tableInfo, String title, String iconName) {
        this.tableInfo = tableInfo;
        this.title = title;
        this.iconName = iconName;
    }

    public TableInfoRenderable(String title, String iconName) {
        this(null, title, iconName);
        this.fieldInfo = null;
    }

    public DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public DBFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public int compareTo(TableInfoRenderable obj) {
        switch (this.sortBy) {
            case Table: {
                return this.tableInfo.getShortClassName().compareTo(obj.tableInfo.getShortClassName());
            }
            case Field: {
                return this.fieldInfo.getColumn().compareTo(obj.fieldInfo.getColumn());
            }
            case TableAndField: {
                String first = String.valueOf(this.tableInfo.getShortClassName()) + this.fieldInfo.getColumn();
                String second = String.valueOf(obj.tableInfo.getShortClassName()) + obj.fieldInfo.getColumn();
                return first.compareTo(second);
            }
        }
        return this.title.compareTo(obj.title);
    }

    public static enum SortBy {
        Table,
        Field,
        TableAndField;

    }
}

