/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.RelatedQuery;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.core.expresssearch.TableInfoRenderable;

class SearchTableRenderable
extends TableInfoRenderable {
    protected SearchTableConfig table = null;
    protected SearchFieldConfig field = null;
    protected RelatedQuery relatedQuery = null;

    public SearchTableRenderable(SearchFieldConfig field) {
        super(field.getFieldInfo());
        this.field = field;
    }

    public SearchTableRenderable(SearchTableConfig table) {
        super(table.getTableInfo());
        this.table = table;
    }

    public SearchTableRenderable(RelatedQuery rq) {
        super((DBTableInfo)null);
        DBTableInfo ti;
        this.tableInfo = ti = DBTableIdMgr.getInstance().getInfoById(rq.getErti().getTableId());
        this.relatedQuery = rq;
    }

    public void setDisplayOrder(Integer displayOrder) {
        if (this.table != null) {
            this.table.setDisplayOrder(displayOrder);
        } else if (this.relatedQuery != null) {
            this.relatedQuery.setDisplayOrder(displayOrder);
        } else {
            throw new RuntimeException("Can't set display order fields");
        }
    }

    public SearchTableConfig getTable() {
        return this.table;
    }

    public SearchFieldConfig getField() {
        return this.field;
    }

    public RelatedQuery getRelatedQuery() {
        return this.relatedQuery;
    }

    @Override
    public int compareTo(TableInfoRenderable o) {
        SearchTableRenderable sr = (SearchTableRenderable)o;
        if (this.table != null) {
            return this.table.getDisplayOrder().compareTo(sr.getTable().getDisplayOrder());
        }
        if (this.relatedQuery != null) {
            return this.relatedQuery.getDisplayOrder().compareTo(sr.getRelatedQuery().getDisplayOrder());
        }
        throw new RuntimeException("Can't sort fields");
    }
}

