/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.DisplayOrderingIFace;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import edu.ku.brc.af.core.expresssearch.TableNameRendererIFace;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.SearchTermField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class SearchTableConfig
implements DisplayOrderingIFace,
TableNameRendererIFace,
Comparable<SearchTableConfig> {
    protected static SimpleDateFormat dbDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected String tableName;
    protected Integer displayOrder;
    protected Vector<SearchFieldConfig> searchFields = new Vector();
    protected Vector<DisplayFieldConfig> displayFields = new Vector();
    protected Vector<DisplayFieldConfig> wsFields = new Vector();
    protected DBTableInfo tableInfo;

    public SearchTableConfig() {
    }

    public void initialize() {
        this.tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(this.tableName.toLowerCase());
        for (SearchFieldConfig sfc : this.searchFields) {
            sfc.setStc(this);
        }
        for (DisplayFieldConfig dfc : this.displayFields) {
            dfc.setStc(this);
        }
        if (this.wsFields != null) {
            for (DisplayFieldConfig wsfc : this.wsFields) {
                wsfc.setStc(this);
            }
        }
    }

    public SearchTableConfig(String tableName, Integer displayOrder) {
        this.tableName = tableName;
        this.displayOrder = displayOrder;
    }

    public boolean hasConfiguredSearchFields() {
        for (SearchFieldConfig sfc : this.searchFields) {
            if (!sfc.isInUse()) continue;
            return true;
        }
        return false;
    }

    public int getTableId() {
        return this.tableInfo != null ? this.tableInfo.getTableId() : -1;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Vector<SearchFieldConfig> getSearchFields() {
        return this.searchFields;
    }

    public void setSearchFields(Vector<SearchFieldConfig> searchFields) {
        this.searchFields = searchFields;
    }

    public Vector<DisplayFieldConfig> getDisplayFields() {
        return this.displayFields;
    }

    public void setDisplayFields(Vector<DisplayFieldConfig> displayFields) {
        this.displayFields = displayFields;
    }

    public Vector<DisplayFieldConfig> getWsFields() {
        return this.wsFields;
    }

    public void setWsFields(Vector<DisplayFieldConfig> wsFields) {
        this.wsFields = wsFields;
    }

    @Override
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public DBTableInfo getTableInfo() {
        if (this.tableInfo == null) {
            this.tableInfo = DBTableIdMgr.getInstance().getInfoByTableName(this.tableName.toLowerCase());
        }
        return this.tableInfo;
    }

    public void setTableInfo(DBTableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public String getSQL(List<SearchTermField> terms, boolean idsOnly, boolean isHQL) {
        return this.getSQL(terms, idsOnly, null, isHQL);
    }

    public String getSQL(List<SearchTermField> terms, boolean idsOnly, Vector<Integer> ids, boolean isHQL) {
        StringBuilder sqlStr = new StringBuilder("SELECT ");
        DBTableInfo ti = this.getTableInfo();
        String primaryKey = ti.getIdFieldName();
        if (!isHQL) {
            primaryKey = String.valueOf(primaryKey.substring(0, 1).toUpperCase()) + primaryKey.substring(1, primaryKey.length());
            primaryKey = StringUtils.replace((String)primaryKey, (String)"Id", (String)"ID");
        }
        sqlStr.append("DISTINCT ");
        sqlStr.append(this.tableInfo.getAbbrev());
        sqlStr.append('.');
        sqlStr.append(primaryKey);
        if (!idsOnly) {
            for (DisplayFieldConfig field : this.displayFields) {
                sqlStr.append(',');
                sqlStr.append(this.tableInfo.getAbbrev());
                sqlStr.append('.');
                sqlStr.append(field.getFieldInfo().getName());
                if (!field.getFieldInfo().isPartialDate()) continue;
                sqlStr.append(',');
                sqlStr.append(this.tableInfo.getAbbrev());
                sqlStr.append('.');
                sqlStr.append(field.getFieldInfo().getDatePrecisionName());
            }
        }
        sqlStr.append(" FROM ");
        sqlStr.append(isHQL ? ti.getClassObj().getSimpleName() : ti.getName());
        sqlStr.append(" as ");
        sqlStr.append(this.tableInfo.getAbbrev());
        String joinSnipet = QueryAdjusterForDomain.getInstance().getJoinClause(this.tableInfo, isHQL, this.tableInfo.getAbbrev(), false);
        if (joinSnipet != null) {
            sqlStr.append(' ');
            sqlStr.append(joinSnipet);
            sqlStr.append(' ');
        }
        sqlStr.append(" WHERE ");
        boolean addParen = false;
        String sqlSnipet = QueryAdjusterForDomain.getInstance().getSpecialColumns(this.tableInfo, isHQL, false, this.tableInfo.getAbbrev());
        if (StringUtils.isNotEmpty((String)sqlSnipet)) {
            sqlStr.append(sqlSnipet);
            sqlStr.append(" AND (");
            addParen = true;
        }
        if (ids != null || terms.size() == 0) {
            sqlStr.append(this.tableInfo.getAbbrev());
            sqlStr.append('.');
            sqlStr.append(primaryKey);
            sqlStr.append(" IN (");
            int i = 0;
            while (i < ids.size()) {
                if (i > 0) {
                    sqlStr.append(',');
                }
                sqlStr.append(ids.elementAt(i).toString());
                ++i;
            }
            sqlStr.append(") ");
        }
        StringBuilder orderBy = new StringBuilder();
        int orderByCnt = 0;
        int cnt = 0;
        if (terms.size() > 0) {
            for (SearchTermField term : terms) {
                if (term.isSingleChar()) continue;
                String termStr = term.getTerm();
                String abbrev = this.tableInfo.getAbbrev();
                for (SearchFieldConfig searchField : this.searchFields) {
                    String numericTermStr = null;
                    String clause = null;
                    DBFieldInfo fi = searchField.getFieldInfo();
                    boolean isFieldDate = fi.getDataClass() == Date.class || searchField.getFieldInfo().getDataClass() == Calendar.class;
                    String fieldName = isHQL ? fi.getName() : fi.getColumn();
                    boolean isFormatted = false;
                    UIFieldFormatterIFace formatter = fi.getFormatter();
                    if (formatter != null) {
                        if (formatter.isNumeric()) {
                            boolean bl = isFormatted = term.isOn(8) && !term.isOn(16);
                            if (isFormatted) {
                                numericTermStr = (String)formatter.formatFromUI(termStr);
                            }
                        } else if (formatter.isLengthOK(termStr.length())) {
                            isFormatted = true;
                            if (!formatter.isValid(termStr)) continue;
                        }
                    }
                    if (ids == null) {
                        if (isFieldDate) {
                            boolean isDate = term.isOn(2);
                            if (!isDate && !term.isOn(4)) continue;
                            if (isDate) {
                                if (!isFieldDate) continue;
                                clause = String.valueOf(abbrev) + '.' + fieldName + " = " + "'" + termStr + "'";
                            } else {
                                clause = "YEAR(" + abbrev + '.' + fi.getName() + ") = " + termStr;
                            }
                        } else if (fi.getDataClass() == Float.class || fi.getDataClass() == Double.class || fi.getDataClass() == BigDecimal.class) {
                            if (!term.isOn(8)) continue;
                            clause = String.valueOf(fieldName) + " = " + termStr;
                        } else if (fi.getDataClass() == Byte.class || fi.getDataClass() == Short.class || fi.getDataClass() == Integer.class || fi.getDataClass() == Long.class) {
                            if (!term.isOn(8) || term.isOn(16)) continue;
                            clause = String.valueOf(abbrev) + '.' + fieldName + " = " + termStr;
                        } else {
                            clause = isFormatted ? String.valueOf(abbrev) + '.' + fieldName + " = " + "'" + (numericTermStr != null ? numericTermStr : termStr) + "'" : ESTermParser.getInstance().createWhereClause(term, abbrev, fieldName);
                        }
                        if (clause != null) {
                            if (cnt > 0) {
                                sqlStr.append(" OR ");
                            }
                            sqlStr.append(clause);
                        }
                    }
                    ++cnt;
                    if (idsOnly || !searchField.getIsSortable().booleanValue()) continue;
                    if (orderByCnt == 0) {
                        orderBy.append(" ORDER BY ");
                    } else {
                        orderBy.append(", ");
                    }
                    orderBy.append(abbrev);
                    orderBy.append('.');
                    orderBy.append(searchField.getFieldName());
                    orderBy.append(searchField.getIsAscending() != false ? " ASC" : " DESC");
                    ++orderByCnt;
                }
            }
        }
        if (addParen) {
            sqlStr.append(")");
        }
        if (cnt == 0 && terms.size() > 0) {
            return null;
        }
        if (orderByCnt > 0) {
            sqlStr.append((CharSequence)orderBy);
        }
        return sqlStr.toString();
    }

    @Override
    public int compareTo(SearchTableConfig obj) {
        String str2;
        String str1 = this.tableInfo.getTitle();
        if (StringUtils.isEmpty((String)str1)) {
            str1 = this.tableName;
        }
        if (StringUtils.isEmpty((String)(str2 = obj.tableInfo.getTitle()))) {
            str2 = obj.tableName;
        }
        return str1.compareTo(str2);
    }

    public String toString() {
        return this.tableInfo.getTitle();
    }

    @Override
    public String getIconName() {
        return this.tableInfo.getClassObj().getSimpleName();
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    public void dump() {
        System.out.println("\n----------- " + this.tableName + " ------------");
        System.out.println("Order: " + this.displayOrder);
        System.out.println("  --------- Search Fields -__-------");
        for (SearchFieldConfig sfc : this.searchFields) {
            sfc.dump();
        }
        System.out.println("  --------- Display Fields --------");
        for (DisplayFieldConfig dfc : this.displayFields) {
            dfc.dump();
        }
    }
}

