/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.AppResourceIFace;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.helpers.XMLHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class SearchConfigService {
    private static final Logger log = Logger.getLogger(SearchConfigService.class);
    protected static SearchConfigService instance = new SearchConfigService();
    protected static final String resourceName = "ExpressSearchConfig";
    protected SearchConfig searchConfig = null;
    protected SearchTableConfig searchContext = null;
    protected List<PropertyChangeListener> changeListeners = new Vector<PropertyChangeListener>();
    protected Hashtable<String, Hashtable<String, Boolean>> skipFieldHash = new Hashtable();

    protected SearchConfigService() {
    }

    public void reset() {
        if (this.searchConfig != null) {
            this.searchConfig.shutdown();
        }
        this.searchConfig = null;
    }

    public SearchConfig getSearchConfig() {
        if (this.searchConfig == null) {
            this.loadConfig();
        }
        return this.searchConfig;
    }

    public static SearchConfigService getInstance() {
        return instance;
    }

    public SearchTableConfig getSearchContext() {
        return this.searchContext;
    }

    public void setSearchContext(SearchTableConfig searchContext) {
        this.searchContext = searchContext;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.changeListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.changeListeners.remove(pcl);
    }

    protected void loadConfig() {
        Element root = XMLHelper.readDOMFromConfigDir("es_skipfields.xml");
        for (Object tblObj : root.selectNodes("/tables/table")) {
            Element tbl = (Element)tblObj;
            String name = XMLHelper.getAttr(tbl, "name", null);
            Hashtable<String, Boolean> fields = new Hashtable<String, Boolean>();
            for (Object fldObj : tbl.selectNodes("field")) {
                Element fld = (Element)fldObj;
                fields.put(fld.getTextTrim().toLowerCase(), true);
            }
            this.skipFieldHash.put(name, fields);
        }
        XStream xstream = new XStream();
        SearchConfig.configXStream(xstream);
        String xmlStr = null;
        AppResourceIFace escAppRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
        if (escAppRes != null) {
            xmlStr = escAppRes.getDataAsString();
        } else {
            AppResourceIFace newAppRes = AppContextMgr.getInstance().copyToDirAppRes("Personal", resourceName);
            if (newAppRes != null) {
                AppContextMgr.getInstance().saveResource(newAppRes);
                xmlStr = newAppRes.getDataAsString();
            } else {
                log.error((Object)"copyToDirAppRes(\"Personal\", ExpressSearchConfig)");
            }
        }
        this.searchConfig = (SearchConfig)xstream.fromXML(xmlStr);
        if (this.searchConfig == null) {
            this.searchConfig = new SearchConfig();
        } else {
            this.searchConfig.initialize();
        }
    }

    public List<DBFieldInfo> getPruncedFieldList(DBTableInfo tblInfo) {
        List<DBFieldInfo> availFields = tblInfo.getFields();
        Hashtable<String, Boolean> allHash = this.skipFieldHash.get("all");
        Hashtable<String, Boolean> tblHash = this.skipFieldHash.get(tblInfo.getName());
        if (allHash != null || tblHash != null) {
            availFields = new Vector<DBFieldInfo>();
            for (DBFieldInfo fi : tblInfo.getFields()) {
                if (allHash != null && allHash.get(fi.getName().toLowerCase()) != null || tblHash != null && tblHash.get(fi.getName()) != null) continue;
                availFields.add(fi);
            }
        }
        return availFields;
    }

    public void saveConfig() {
        XStream xstream = new XStream();
        SearchConfig.configXStream(xstream);
        AppResourceIFace escAppRes = AppContextMgr.getInstance().getResourceFromDir("Personal", resourceName);
        if (escAppRes != null) {
            escAppRes.setDataAsString(xstream.toXML((Object)this.searchConfig));
            AppContextMgr.getInstance().saveResource(escAppRes);
        } else {
            AppContextMgr.getInstance().putResourceAsXML(resourceName, xstream.toXML((Object)this.searchConfig));
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "contentsChanged", null, null);
        for (PropertyChangeListener pcl : this.changeListeners) {
            pcl.propertyChange(pce);
        }
        boolean foundContext = false;
        for (SearchTableConfig stc : this.searchConfig.getTables()) {
            if (stc != this.searchContext) continue;
            foundContext = true;
            break;
        }
        if (!foundContext) {
            this.searchContext = null;
            pce = new PropertyChangeEvent(this, "noContext", this.searchContext, null);
            for (PropertyChangeListener pcl : this.changeListeners) {
                pcl.propertyChange(pce);
            }
        }
    }
}

