/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.RelatedQuery;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SearchConfig {
    private static final Logger log = Logger.getLogger(SearchConfig.class);
    protected Vector<SearchTableConfig> tables = new Vector();
    protected Vector<RelatedQuery> relatedQueries = new Vector();
    protected SearchTableConfig searcher = new SearchTableConfig();
    protected Hashtable<String, RelatedQuery> relatedQueryIdHash;
    protected Hashtable<String, SearchTableConfig> tableIdHash;
    protected Hashtable<String, SearchTableConfig> tableNameHash;

    public void shutdown() {
        if (this.tables != null) {
            this.tables.clear();
        }
        if (this.relatedQueries != null) {
            this.relatedQueries.clear();
        }
        if (this.relatedQueryIdHash != null) {
            this.relatedQueryIdHash.clear();
        }
        if (this.tableIdHash != null) {
            this.tableIdHash.clear();
        }
        if (this.tableNameHash != null) {
            this.tableNameHash.clear();
        }
    }

    public static void configXStream(XStream xstream) {
        xstream.alias("search", SearchConfig.class);
        xstream.alias("searchtable", SearchTableConfig.class);
        xstream.alias("searchfield", SearchFieldConfig.class);
        xstream.alias("displayfield", DisplayFieldConfig.class);
        xstream.alias("relatedquery", RelatedQuery.class);
        xstream.aliasAttribute(RelatedQuery.class, "isActive", "isactive");
        xstream.omitField(SearchConfig.class, "searcher");
        xstream.omitField(SearchFieldConfig.class, "isInUse");
        xstream.omitField(SearchFieldConfig.class, "fieldInfo");
        xstream.omitField(SearchFieldConfig.class, "stc");
        xstream.omitField(DisplayFieldConfig.class, "isInUse");
        xstream.omitField(DisplayFieldConfig.class, "fieldInfo");
        xstream.omitField(DisplayFieldConfig.class, "stc");
        xstream.omitField(RelatedQuery.class, "erti");
        xstream.omitField(RelatedQuery.class, "isInUse");
        xstream.omitField(RelatedQuery.class, "tableInfo");
        xstream.omitField(SearchTableConfig.class, "tableInfo");
    }

    public void initialize() {
        this.relatedQueryIdHash = new Hashtable();
        this.tableIdHash = new Hashtable();
        this.tableNameHash = new Hashtable();
        for (SearchTableConfig table : this.tables) {
            table.initialize();
            this.tableIdHash.put(Integer.toString(table.getTableId()), table);
            this.tableNameHash.put(table.getTableName(), table);
        }
        for (RelatedQuery rq : this.relatedQueries) {
            this.relatedQueryIdHash.put(rq.getId(), rq);
        }
    }

    public SearchTableConfig getSearchTableConfigById(int id) {
        return this.tableIdHash.get(Integer.toString(id));
    }

    public Integer getOrderForRelatedQueryId(String id) {
        RelatedQuery rq = this.relatedQueryIdHash.get(id);
        return rq != null ? rq.getDisplayOrder() : Integer.MAX_VALUE;
    }

    public Boolean isActiveForRelatedQueryId(String id) {
        RelatedQuery rq = this.relatedQueryIdHash.get(id);
        return rq != null ? rq.getIsActive() : false;
    }

    public Integer getOrderForTableId(String id) {
        SearchTableConfig stc = this.tableIdHash.get(id);
        return stc != null ? stc.getDisplayOrder() : Integer.MAX_VALUE;
    }

    public DisplayFieldConfig findDisplayField(String tableName, String fieldName) {
        SearchTableConfig stc = this.tableNameHash.get(tableName);
        if (stc != null) {
            for (DisplayFieldConfig dfc : stc.getDisplayFields()) {
                if (!fieldName.equals(dfc.getFieldName())) continue;
                return dfc;
            }
        } else {
            log.error((Object)("Couldn't find table by name[" + tableName + "]"));
        }
        return null;
    }

    public SearchFieldConfig findSearchField(String tableName, String fieldName) {
        SearchTableConfig stc = this.tableNameHash.get(tableName);
        if (stc != null) {
            for (SearchFieldConfig sfc : stc.getSearchFields()) {
                if (!fieldName.equals(sfc.getFieldName())) continue;
                return sfc;
            }
        } else {
            log.error((Object)("Couldn't find table by name[" + tableName + "]"));
        }
        return null;
    }

    public DisplayFieldConfig findDisplayField(SearchTableConfig searchTableConfig, String fieldName, boolean createWhenNotFound) {
        if (searchTableConfig != null) {
            for (DisplayFieldConfig dfc : searchTableConfig.getDisplayFields()) {
                if (!fieldName.equals(dfc.getFieldName())) continue;
                dfc.setInUse(true);
                return dfc;
            }
        }
        if (createWhenNotFound) {
            DisplayFieldConfig dfc;
            dfc = new DisplayFieldConfig(fieldName, "", Integer.MAX_VALUE);
            dfc.setInUse(false);
            if (searchTableConfig != null) {
                searchTableConfig.getDisplayFields().add(dfc);
            }
            return dfc;
        }
        return null;
    }

    public SearchFieldConfig findSearchField(SearchTableConfig table, String fieldName, boolean createWhenNotFound) {
        if (table != null) {
            for (SearchFieldConfig sfc : table.getSearchFields()) {
                if (!fieldName.equals(sfc.getFieldName())) continue;
                sfc.setInUse(true);
                return sfc;
            }
        }
        if (createWhenNotFound) {
            SearchFieldConfig sfc;
            sfc = new SearchFieldConfig(fieldName, false, true);
            sfc.setInUse(false);
            if (table != null) {
                table.getSearchFields().add(sfc);
            }
            return sfc;
        }
        return null;
    }

    public boolean isDisplayFieldInList(String tableName, String fieldName) {
        return this.findDisplayField(tableName, fieldName) != null;
    }

    public boolean isSearchFieldInList(String tableName, String fieldName) {
        return this.findSearchField(tableName, fieldName) != null;
    }

    public SearchTableConfig findTableOrCreate(String tableName) {
        SearchTableConfig stc = this.tableNameHash.get(tableName);
        if (stc == null) {
            stc = new SearchTableConfig(tableName, 0);
            stc.initialize();
            this.tables.add(stc);
            Collections.sort(this.tables);
            this.tableIdHash.put(Integer.toString(stc.getTableId()), stc);
            this.tableNameHash.put(stc.getTableName(), stc);
        }
        return stc;
    }

    public void addDisplayField(String tableName, DisplayFieldConfig field) {
        Vector<DisplayFieldConfig> list;
        SearchTableConfig tbl = this.findTableOrCreate(tableName);
        if (tbl != null && !(list = tbl.getDisplayFields()).contains(field)) {
            list.addElement(field);
            Collections.sort(list);
        }
    }

    public void removeDisplayField(String tableName, String fieldName) {
        SearchTableConfig stc = this.tableNameHash.get(tableName);
        if (stc != null) {
            for (DisplayFieldConfig sfc : stc.getDisplayFields()) {
                if (!fieldName.equals(sfc.getFieldName())) continue;
                stc.getDisplayFields().remove(sfc);
                break;
            }
        } else {
            log.error((Object)("Couldn't find table by name[" + tableName + "]"));
        }
    }

    public void addSearchField(String tableName, SearchFieldConfig field) {
        Vector<SearchFieldConfig> list;
        SearchTableConfig tbl = this.findTableOrCreate(tableName);
        if (tbl != null && !(list = tbl.getSearchFields()).contains(field)) {
            list.addElement(field);
        }
    }

    public void removeSearchField(String tableName, String fieldName) {
        SearchTableConfig stc = this.tableNameHash.get(tableName);
        if (stc != null) {
            for (SearchFieldConfig sfc : stc.getSearchFields()) {
                if (!fieldName.equals(sfc.getFieldName())) continue;
                stc.getSearchFields().remove(sfc);
                break;
            }
        } else {
            log.error((Object)("Couldn't find table by name[" + tableName + "]"));
        }
    }

    public void removeTable(SearchTableConfig stc) {
        this.tables.remove(stc);
        this.tableIdHash.remove(Integer.toString(stc.getTableId()));
        this.tableNameHash.remove(stc.getTableName());
    }

    public Vector<SearchTableConfig> getTables() {
        return this.tables;
    }

    public Vector<RelatedQuery> getRelatedQueries() {
        return this.relatedQueries;
    }

    public void setRelatedQueries(Vector<RelatedQuery> relatedQueries) {
        this.relatedQueries = relatedQueries;
    }

    public RelatedQuery findRelatedQueryOrCreate(String id) {
        RelatedQuery rq = this.relatedQueryIdHash.get(id);
        if (rq == null) {
            rq = new RelatedQuery(id, Integer.MAX_VALUE, false);
            this.relatedQueries.add(rq);
            this.relatedQueryIdHash.put(rq.getId(), rq);
        }
        return rq;
    }
}

