/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.core.expresssearch.RelatedQuery;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.TableNameRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RelatedTableInfoPanel
extends JPanel {
    protected SearchConfig config;
    protected JList relatedTablesList;
    protected DefaultListModel relatedTablesModel = new DefaultListModel();
    protected JLabel descLbl;
    protected JTextArea relatedTableDescTA;
    protected JLabel activeLbl;
    protected JCheckBox activeCBX;
    protected JButton selectAllBtn;
    protected JButton deselectAllBtn;
    protected Vector<RelatedQuery> relatedQueriesInUse = new Vector();
    protected boolean ignoreChanges = false;

    public RelatedTableInfoPanel(SearchConfig config) {
        this.config = config;
        this.createUI();
    }

    protected void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.relatedTablesList = new JList(this.relatedTablesModel);
        TableNameRenderer nameRender = new TableNameRenderer(IconManager.IconSize.Std24);
        nameRender.setUseIcon("PlaceHolder");
        this.relatedTablesList.setCellRenderer(nameRender);
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("p:g,8px,p,2px,f:p:g", "p,2px,p,2px,p,2px,t:p:g,f:p:g,2px,p"), (JPanel)this);
        JScrollPane sp = new JScrollPane(this.relatedTablesList, 20, 31);
        pb.add((Component)UIHelper.createI18NLabel("RelatedTableInfoPanel.ES_RELATED_SEARCHES"), cc.xy(1, 1));
        pb.add((Component)sp, cc.xywh(1, 3, 1, 6));
        this.activeCBX = UIHelper.createCheckBox("                      ");
        this.activeLbl = UIHelper.createI18NLabel("RelatedTableInfoPanel.ES_RELATED_ACTIVATE", 4);
        pb.add((Component)this.activeLbl, cc.xy(3, 3));
        pb.add((Component)this.activeCBX, cc.xy(5, 3));
        this.relatedTableDescTA = new JTextArea(8, 40);
        this.relatedTableDescTA.setEditable(false);
        this.relatedTableDescTA.setWrapStyleWord(true);
        this.relatedTableDescTA.setBackground(Color.WHITE);
        this.relatedTableDescTA.setLineWrap(true);
        sp = new JScrollPane(this.relatedTableDescTA, 20, 31);
        this.descLbl = UIHelper.createI18NLabel("RelatedTableInfoPanel.ES_RELATED_DESC", 4);
        pb.add((Component)this.descLbl, cc.xy(3, 5));
        pb.add((Component)sp, cc.xy(5, 5));
        PanelBuilder btnPB = new PanelBuilder(new FormLayout("p,f:p:g,p", "p"));
        this.selectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("RelatedTableInfoPanel.SELECTALL"));
        this.deselectAllBtn = UIHelper.createButton(UIRegistry.getResourceString("RelatedTableInfoPanel.DESELECTALL"));
        btnPB.add((Component)this.selectAllBtn, cc.xy(1, 1));
        btnPB.add((Component)this.deselectAllBtn, cc.xy(3, 1));
        pb.add((Component)btnPB.getPanel(), cc.xy(1, 10));
        this.activeCBX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RelatedQuery rq = (RelatedQuery)RelatedTableInfoPanel.this.relatedTablesList.getSelectedValue();
                if (rq != null) {
                    rq.setIsActive(RelatedTableInfoPanel.this.activeCBX.isSelected());
                    RelatedTableInfoPanel.this.relatedTablesList.repaint();
                }
            }
        });
        this.relatedTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    RelatedTableInfoPanel.this.rtRelatedTableSelected();
                    RelatedTableInfoPanel.this.updateEnableUI();
                }
            }
        });
        this.selectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatedTableInfoPanel.this.setAllActive(true);
            }
        });
        this.deselectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatedTableInfoPanel.this.setAllActive(false);
            }
        });
        this.updateEnableUI();
    }

    protected void setAllActive(boolean isActive) {
        this.relatedTablesList.clearSelection();
        for (RelatedQuery rq : this.relatedQueriesInUse) {
            rq.setIsActive(isActive);
        }
        this.relatedTablesList.repaint();
    }

    protected void updateEnableUI() {
        boolean enabled = this.relatedTablesList.getSelectedIndex() > -1;
        this.activeCBX.setEnabled(enabled);
        this.activeLbl.setEnabled(enabled);
        this.descLbl.setEnabled(enabled);
        this.relatedTableDescTA.setEnabled(enabled);
    }

    protected void rtRelatedTableSelected() {
        RelatedQuery rq = (RelatedQuery)this.relatedTablesList.getSelectedValue();
        if (rq != null) {
            this.activeCBX.setText(rq.getPlainTitle());
            this.activeCBX.setSelected(rq.getIsActive());
            ExpressResultsTableInfo erti = ExpressSearchConfigCache.getSearchIdToTableInfoHash().get(rq.getId());
            if (erti != null) {
                this.relatedTableDescTA.setText(erti.getDescription());
            } else {
                this.relatedTableDescTA.setText("");
            }
        } else {
            this.relatedTableDescTA.setText("");
            this.activeCBX.setText("");
            this.activeCBX.setSelected(false);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        RelatedQuery.setAddRealtedQueryTitle(!vis);
        RelatedQuery.setAddActiveTitle(vis);
        if (vis) {
            this.relatedQueriesInUse.clear();
            this.relatedTablesModel.clear();
            for (RelatedQuery rq : this.config.getRelatedQueries()) {
                if (!rq.isInUse()) continue;
                this.relatedQueriesInUse.add(rq);
            }
            Collections.sort(this.relatedQueriesInUse);
            for (RelatedQuery rq : this.relatedQueriesInUse) {
                this.relatedTablesModel.addElement(rq);
            }
        }
        super.setVisible(vis);
    }
}

