/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.expresssearch.ERTIJoinColInfo;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;

public class QueryForIdResultsSQL
implements QueryForIdResultsIFace {
    protected String searchId;
    protected Integer joinColTableId;
    protected ExpressResultsTableInfo tableInfo;
    protected Vector<Integer> recIds = new Vector();
    protected Vector<Integer> indexes = new Vector();
    protected String searchTerm = null;
    protected Integer displayOrder = null;
    protected String overrideSQL = null;
    protected boolean isExpanded = false;
    protected Hashtable<Integer, Boolean> duplicateRecId = new Hashtable();
    protected boolean isMultipleSelection = true;

    public QueryForIdResultsSQL(String searchId, Integer joinColTableId, ExpressResultsTableInfo tableInfo, Integer displayOrder, String searchTerm) {
        this.searchId = searchId;
        this.joinColTableId = joinColTableId;
        this.tableInfo = tableInfo;
        this.displayOrder = displayOrder;
        this.searchTerm = searchTerm;
    }

    @Override
    public boolean isHQL() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.tableInfo.getTitle();
    }

    @Override
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void cleanUp() {
        this.tableInfo = null;
        if (this.recIds != null) {
            this.recIds.clear();
            this.recIds = null;
        }
        if (this.duplicateRecId != null) {
            this.duplicateRecId.clear();
        }
    }

    public void add(Integer id) {
        if (this.duplicateRecId.get(id) == null) {
            this.duplicateRecId.put(id, true);
            this.recIds.add(id);
        }
    }

    public void add(List<?> ids) {
        this.recIds.ensureCapacity(ids.size());
        for (Object obj : ids) {
            this.recIds.add((Integer)obj);
        }
    }

    public void add(String idStr) {
        this.add(Integer.parseInt(idStr));
    }

    public int getNumIndexes() {
        return this.indexes.size();
    }

    public void addIndex(int index) {
        this.indexes.add(index);
    }

    public String getSearchId() {
        return this.searchId;
    }

    public Integer getJoinColTableId() {
        return this.joinColTableId;
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public ExpressResultsTableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public Vector<Integer> getRecIds() {
        return this.recIds;
    }

    @Override
    public int size() {
        return this.recIds.size();
    }

    @Override
    public int getTableId() {
        return Integer.parseInt(this.tableInfo.getTableId());
    }

    @Override
    public String getIconName() {
        return this.tableInfo.getIconName();
    }

    @Override
    public List<ERTICaptionInfo> getVisibleCaptionInfo() {
        return this.tableInfo.getVisibleCaptionInfo();
    }

    @Override
    public Color getBannerColor() {
        return this.tableInfo.getColor();
    }

    @Override
    public String getSQL(String searchTermArg, Vector<Integer> ids) {
        String sqlStr;
        if (StringUtils.isNotEmpty((String)this.overrideSQL)) {
            return this.overrideSQL;
        }
        Vector<Integer> tempIds = ids == null ? this.recIds : ids;
        StringBuilder idsStr = new StringBuilder(this.recIds.size() * 8);
        int i = 0;
        while (i < tempIds.size()) {
            if (i > 0) {
                idsStr.append(',');
            }
            idsStr.append(tempIds.elementAt(i).toString());
            ++i;
        }
        if (this.getJoinColTableId() != null) {
            String joinIdName = null;
            ERTIJoinColInfo[] eRTIJoinColInfoArray = this.tableInfo.getJoins();
            int n = eRTIJoinColInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ERTIJoinColInfo jci = eRTIJoinColInfoArray[n2];
                if (this.joinColTableId.intValue() == jci.getJoinTableIdAsInt()) {
                    joinIdName = jci.getColName();
                }
                ++n2;
            }
            String critiera = String.valueOf(this.tableInfo.isFieldNameOnlyForSQL() ? StringUtils.substringAfterLast(joinIdName, (String)".") : joinIdName) + " in (" + idsStr.toString() + ")";
            sqlStr = String.format(this.tableInfo.getViewSql(), joinIdName, critiera);
            sqlStr = QueryAdjusterForDomain.getInstance().adjustSQL(sqlStr);
        } else {
            String vsql = this.getTableInfo().getViewSql();
            sqlStr = idsStr.length() > 0 ? vsql.replace("%s", idsStr.toString()) : vsql;
        }
        return sqlStr;
    }

    @Override
    public void setSQL(String sql) {
        this.overrideSQL = sql;
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public boolean shouldInstallServices() {
        return true;
    }

    @Override
    public boolean isEditingEnabled() {
        return false;
    }

    @Override
    public void removeIds(List<Integer> ids) {
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    @Override
    public String getDescription() {
        return this.tableInfo != null ? this.tableInfo.getDescription() : null;
    }

    @Override
    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    @Override
    public void setMultipleSelection(boolean isMultiple) {
        this.isMultipleSelection = isMultiple;
    }

    @Override
    public List<Pair<String, Object>> getParams() {
        return null;
    }

    @Override
    public void complete() {
    }

    @Override
    public Future<?> getQueryTask() {
        return null;
    }

    @Override
    public void setQueryTask(Future<?> queryTask) {
    }

    @Override
    public void queryTaskDone(Object results) {
    }

    @Override
    public boolean showProgress() {
        return true;
    }

    @Override
    public int getMaxTableRows() {
        return -1;
    }

    @Override
    public void cacheFilled(Vector<Vector<Object>> cache) {
    }
}

