/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;

public class QueryForIdResultsIndexedSQL
implements QueryForIdResultsIFace {
    protected SearchTableConfig searchTableConfig = null;
    protected Color bannerColor;
    protected String searchId;
    protected Vector<Integer> recIds = new Vector();
    protected String searchTerm = null;
    protected Integer displayOrder = null;
    protected List<ERTICaptionInfo> captions = null;
    protected String overrideSQL = null;
    protected boolean isExpanded = false;
    protected Hashtable<Integer, Boolean> duplicateRecId = new Hashtable();
    protected boolean isMultipleSelection = true;

    public QueryForIdResultsIndexedSQL(SearchTableConfig searchTableConfig, Color bannerColor, String searchTerm, List<?> listOfIds) {
        this.searchTableConfig = searchTableConfig;
        this.bannerColor = bannerColor;
        this.searchTerm = searchTerm;
        for (Integer id : listOfIds) {
            this.recIds.add(id);
        }
    }

    @Override
    public boolean isHQL() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.searchTableConfig.getTableInfo().getTitle();
    }

    @Override
    public Integer getDisplayOrder() {
        return this.searchTableConfig.getDisplayOrder();
    }

    @Override
    public void cleanUp() {
        this.searchTableConfig = null;
        if (this.recIds != null) {
            this.recIds.clear();
            this.recIds = null;
        }
        if (this.duplicateRecId != null) {
            this.duplicateRecId.clear();
        }
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm;
    }

    @Override
    public Vector<Integer> getRecIds() {
        return this.recIds;
    }

    @Override
    public int getTableId() {
        return this.searchTableConfig.getTableInfo().getTableId();
    }

    @Override
    public String getIconName() {
        return this.searchTableConfig.getTableInfo().getName();
    }

    @Override
    public List<ERTICaptionInfo> getVisibleCaptionInfo() {
        if (this.captions == null) {
            this.buildCaptions();
        }
        return this.captions;
    }

    protected void buildCaptions() {
        this.captions = new Vector<ERTICaptionInfo>();
        int i = 0;
        for (DisplayFieldConfig dfc : this.searchTableConfig.getDisplayFields()) {
            ERTICaptionInfo caption = new ERTICaptionInfo(dfc.getFieldInfo().getColumn(), dfc.getFieldInfo().getTitle(), true, dfc.getFieldInfo().getFormatter(), i + 1);
            caption.setColClass(dfc.getFieldInfo().getDataClass());
            this.captions.add(caption);
            ++i;
        }
    }

    @Override
    public Color getBannerColor() {
        return this.bannerColor;
    }

    @Override
    public String getSQL(String searchTermArg, Vector<Integer> ids) {
        if (StringUtils.isNotEmpty((String)this.overrideSQL)) {
            return this.overrideSQL;
        }
        ESTermParser.getInstance().parse(searchTermArg, false);
        String sql = this.searchTableConfig.getSQL(ESTermParser.getInstance().getFields(), false, ids == null && this.recIds != null ? this.recIds : ids, false);
        return sql;
    }

    @Override
    public void setSQL(String sql) {
        this.overrideSQL = sql;
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public boolean shouldInstallServices() {
        return true;
    }

    @Override
    public boolean isEditingEnabled() {
        return false;
    }

    @Override
    public void removeIds(List<Integer> ids) {
    }

    @Override
    public String getDescription() {
        return this.searchTableConfig.getTableInfo().getDescription();
    }

    @Override
    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    @Override
    public void setMultipleSelection(boolean isMultiple) {
        this.isMultipleSelection = isMultiple;
    }

    @Override
    public List<Pair<String, Object>> getParams() {
        return null;
    }

    @Override
    public void complete() {
    }

    @Override
    public Future<?> getQueryTask() {
        return null;
    }

    @Override
    public void setQueryTask(Future<?> queryTask) {
    }

    @Override
    public void queryTaskDone(Object results) {
    }

    @Override
    public int size() {
        return this.recIds.size();
    }

    @Override
    public boolean showProgress() {
        return true;
    }

    @Override
    public int getMaxTableRows() {
        return -1;
    }

    @Override
    public void cacheFilled(Vector<Vector<Object>> cache) {
    }
}

