/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.ui.ESTermParser;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.af.ui.db.QueryForIdResultsIFace;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterMgr;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;

public class QueryForIdResultsHQL
implements QueryForIdResultsIFace {
    protected static final int SRCHQIdRHQLTblId = -123;
    protected SearchTableConfig searchTableConfig;
    protected Color bannerColor;
    protected Vector<Integer> recIds = new Vector();
    protected String searchTerm;
    protected String title = null;
    protected String overrideSQL = null;
    protected List<ERTICaptionInfo> captions = null;
    protected boolean isExpanded = false;
    protected boolean shouldInstallServices = true;
    protected RecordSetIFace recordSet;
    protected boolean isMultipleSelection = true;
    protected boolean isEditable = false;
    protected int tableId;

    public QueryForIdResultsHQL(SearchTableConfig searchTableConfig, Color bannerColor, String searchTerm, List<?> listOfIds) {
        this.searchTableConfig = searchTableConfig;
        this.bannerColor = bannerColor;
        this.searchTerm = searchTerm;
        this.recordSet = null;
        int n = this.tableId = searchTableConfig != null ? searchTableConfig.getTableId() : -1;
        if (listOfIds != null) {
            for (Integer id : listOfIds) {
                this.recIds.add(id);
            }
        }
    }

    public QueryForIdResultsHQL(SearchTableConfig searchTableConfig, Color bannerColor, int tableId) {
        this.searchTableConfig = searchTableConfig;
        this.bannerColor = bannerColor;
        this.searchTerm = null;
        this.recordSet = null;
        this.tableId = tableId;
    }

    public QueryForIdResultsHQL(SearchTableConfig searchTableConfig, Color bannerColor, RecordSetIFace recordSet) {
        this.searchTableConfig = searchTableConfig;
        this.bannerColor = bannerColor;
        this.searchTerm = "";
        this.recordSet = recordSet;
        this.tableId = searchTableConfig != null ? searchTableConfig.getTableId() : -1;
        for (RecordSetItemIFace item : recordSet.getOrderedItems()) {
            this.recIds.add(item.getRecordId());
        }
    }

    @Override
    public boolean isHQL() {
        return true;
    }

    @Override
    public void cleanUp() {
        this.searchTableConfig = null;
    }

    @Override
    public Color getBannerColor() {
        return this.bannerColor;
    }

    @Override
    public Integer getDisplayOrder() {
        return this.searchTableConfig.getDisplayOrder();
    }

    @Override
    public String getIconName() {
        return this.searchTableConfig.getIconName();
    }

    @Override
    public Vector<Integer> getRecIds() {
        return this.recIds;
    }

    @Override
    public String getSQL(String searchTermArg, Vector<Integer> ids) {
        if (StringUtils.isNotEmpty((String)this.overrideSQL)) {
            return this.overrideSQL;
        }
        ESTermParser.getInstance().parse(searchTermArg, false);
        return this.searchTableConfig.getSQL(ESTermParser.getInstance().getFields(), false, ids == null && this.recIds != null ? this.recIds : ids, true);
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm;
    }

    @Override
    public int getTableId() {
        return this.searchTableConfig.getTableInfo().getTableId();
    }

    @Override
    public String getTitle() {
        return this.title != null ? this.title : this.searchTableConfig.getTableInfo().getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<ERTICaptionInfo> getVisibleCaptionInfo() {
        if (this.captions == null) {
            this.buildCaptions();
        }
        return this.captions;
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Override
    public boolean shouldInstallServices() {
        return this.shouldInstallServices;
    }

    @Override
    public boolean isEditingEnabled() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Override
    public void removeIds(List<Integer> ids) {
        CommandAction cmd = new CommandAction("Record_Set", "DELETEITEMS", new Object[]{this.recordSet, ids});
        CommandDispatcher.dispatch(cmd);
    }

    public void setShouldInstallServices(boolean shouldInstallServices) {
        this.shouldInstallServices = shouldInstallServices;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    protected void buildCaptions() {
        this.captions = new Vector<ERTICaptionInfo>();
        int i = 0;
        for (DisplayFieldConfig dfc : this.searchTableConfig.getDisplayFields()) {
            ERTICaptionInfo caption = new ERTICaptionInfo(dfc.getFieldInfo().getColumn(), dfc.getFieldInfo().getTitle(), true, dfc.getFieldInfo().getFormatter(), i + 1);
            caption.setColClass(dfc.getFieldInfo().getDataClass());
            if (dfc.getFieldInfo().isPartialDate()) {
                String precName = dfc.getFieldInfo().getDatePrecisionName();
                Vector<ERTICaptionInfo.ColInfo> colInfoList = new Vector<ERTICaptionInfo.ColInfo>();
                ERTICaptionInfo eRTICaptionInfo = caption;
                eRTICaptionInfo.getClass();
                ERTICaptionInfo.ColInfo columnInfo = new ERTICaptionInfo.ColInfo(eRTICaptionInfo, StringUtils.capitalize((String)precName), precName);
                columnInfo.setPosition(0);
                colInfoList.add(columnInfo);
                ERTICaptionInfo eRTICaptionInfo2 = caption;
                eRTICaptionInfo2.getClass();
                columnInfo = new ERTICaptionInfo.ColInfo(eRTICaptionInfo2, dfc.getFieldInfo().getColumn(), dfc.getFieldInfo().getName());
                columnInfo.setPosition(1);
                colInfoList.add(columnInfo);
                caption.setColInfoList(colInfoList);
                caption.setColName(null);
                caption.setUiFieldFormatter(UIFieldFormatterMgr.getInstance().getFormatter("PartialDate"));
            }
            this.captions.add(caption);
            ++i;
        }
    }

    @Override
    public void setSQL(String sql) {
        this.overrideSQL = sql;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isMultipleSelection() {
        return this.isMultipleSelection;
    }

    @Override
    public void setMultipleSelection(boolean isMultiple) {
        this.isMultipleSelection = isMultiple;
    }

    @Override
    public List<Pair<String, Object>> getParams() {
        return null;
    }

    @Override
    public void complete() {
    }

    @Override
    public Future<?> getQueryTask() {
        return null;
    }

    @Override
    public void setQueryTask(Future<?> queryTask) {
    }

    @Override
    public void queryTaskDone(Object results) {
    }

    @Override
    public int size() {
        return this.getRecIds().size();
    }

    @Override
    public boolean showProgress() {
        return true;
    }

    @Override
    public int getMaxTableRows() {
        return -1;
    }

    @Override
    public void cacheFilled(Vector<Vector<Object>> cache) {
    }
}

