/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.thoughtworks.xstream.XStream;
import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.ESTableOrderPanel;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.core.expresssearch.RelatedTableInfoPanel;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchConfigService;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.core.expresssearch.TableNameRenderer;
import edu.ku.brc.af.core.expresssearch.TableNameRendererIFace;
import edu.ku.brc.specify.ui.HelpMgr;
import edu.ku.brc.ui.CustomDialog;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ExpressSearchConfigDlg
extends CustomDialog {
    public static String NONE = null;
    public static String ASCENDING = null;
    public static String DESCENDING = null;
    protected static final String[] TAB_HELP_CONTEXT = new String[]{"ESConfigSearchFields", "ESConfigRelatedTables", "ESConfigResultsOrdering"};
    protected JTabbedPane tabbedPane;
    protected JList tableList;
    protected JList toBeSearchedList;
    protected Vector<SearchFieldConfig> toBeSearchedVect = new Vector();
    protected ESTableOrderPanel orderPanel = null;
    protected Component currTabComp = null;
    protected ToggleButtonChooserPanel<DisplayFieldConfig> displayList;
    protected Hashtable<Integer, SearchTableConfig> tiRenderHash = new Hashtable();
    protected Vector<SearchTableConfig> tiRenderList = new Vector();
    protected JTable searchFieldsTable;
    protected SearchFieldsTableModel searchFieldsTableModel;
    protected JButton orderUpBtn;
    protected JButton orderDwnBtn;
    protected Comparator<TableNameRendererIFace> toBeSearchedComparator = ExpressSearchConfigDlg.getTableFieldNameComparator();
    protected SearchConfigService searchConfigService = SearchConfigService.getInstance();
    protected SearchConfig config = new SearchConfig();

    static {
        NONE = ExpressSearchConfigDlg.getI18NStr("ES_NONE");
        ASCENDING = ExpressSearchConfigDlg.getI18NStr("ES_ASCENDING");
        DESCENDING = ExpressSearchConfigDlg.getI18NStr("ES_DESCENDING");
    }

    public ExpressSearchConfigDlg() {
        super((Frame)UIRegistry.getTopWindow(), ExpressSearchConfigDlg.getI18NStr("ES_DLG_TITLE"), true, 5, null);
        this.setOkLabel(ExpressSearchConfigDlg.getI18NStr("CLOSE"));
        this.config = this.searchConfigService.getSearchConfig();
    }

    @Override
    public void createUI() {
        super.createUI();
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, TAB_HELP_CONTEXT[0]);
        int maxDisplayCnt = 0;
        int maxSearchCnt = 0;
        Hashtable<String, List<ExpressResultsTableInfo>> joinHash = ExpressSearchConfigCache.getJoinIdToTableInfoHash();
        Vector<DBTableInfo> tableListInfoWithJoins = new Vector<DBTableInfo>();
        for (DBTableInfo ti : DBTableIdMgr.getInstance().getTables()) {
            List<ExpressResultsTableInfo> joinList;
            if (!ti.isSearchable()) continue;
            List<DBFieldInfo> fieldList = this.searchConfigService.getPruncedFieldList(ti);
            int notSortedIndex = 1000;
            boolean hasIndexedFields = false;
            for (DBFieldInfo fi : fieldList) {
                if (!fi.isIndexed()) continue;
                hasIndexedFields = true;
                break;
            }
            if (!hasIndexedFields) continue;
            SearchTableConfig stc = this.config.findTableOrCreate(ti.getClassObj().getSimpleName());
            stc.setTableInfo(ti);
            int displayCnt = 0;
            int searchCnt = 0;
            for (DBFieldInfo fi : fieldList) {
                if (fi.isHidden()) {
                    if (this.config.findSearchField(stc, fi.getName(), true) != null) {
                        this.config.removeSearchField(stc.getTableName(), fi.getName());
                    }
                    if (this.config.findDisplayField(stc, fi.getName(), true) == null) continue;
                    this.config.removeDisplayField(stc.getTableName(), fi.getName());
                    continue;
                }
                if (fi.isIndexed()) {
                    SearchFieldConfig sfc = this.config.findSearchField(stc, fi.getName(), true);
                    sfc.setFieldInfo(fi);
                    sfc.setStc(stc);
                    if (sfc.getOrder() == null) {
                        sfc.setOrder(notSortedIndex++);
                    }
                    ++searchCnt;
                }
                if (!fi.isHidden()) {
                    DisplayFieldConfig dfc = this.config.findDisplayField(stc, fi.getName(), true);
                    dfc.setFieldInfo(fi);
                    dfc.setStc(stc);
                }
                ++displayCnt;
            }
            if (ti.isHidden()) {
                this.config.removeTable(stc);
            }
            if ((joinList = joinHash.get(Integer.toString(ti.getTableId()))) != null) {
                tableListInfoWithJoins.add(ti);
            }
            maxDisplayCnt = Math.max(maxDisplayCnt, displayCnt);
            maxSearchCnt = Math.max(maxSearchCnt, searchCnt);
            Collections.sort(stc.getSearchFields());
            Collections.sort(stc.getDisplayFields());
        }
        Collections.sort(this.config.getTables());
        for (SearchTableConfig stc : this.config.getTables()) {
            PermissionSettings perm;
            if (AppContextMgr.isSecurityOn() && !(perm = stc.getTableInfo().getPermissions()).canView()) continue;
            this.tiRenderList.add(stc);
            this.tiRenderHash.put(stc.getTableInfo().getTableId(), stc);
        }
        Collections.sort(this.tiRenderList);
        this.tableList = new JList<SearchTableConfig>(this.tiRenderList);
        TableNameRenderer nameRender = new TableNameRenderer(IconManager.IconSize.Std24);
        nameRender.setUseIcon("PlaceHolder");
        this.tableList.setCellRenderer(nameRender);
        this.searchFieldsTableModel = new SearchFieldsTableModel();
        this.searchFieldsTable = new JTable(this.searchFieldsTableModel);
        this.searchFieldsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ExpressSearchConfigDlg.this.updateEnabledState();
                }
            }
        });
        UIHelper.makeTableHeadersCentered(this.searchFieldsTable, false);
        String[] values = new String[]{NONE, ASCENDING, DESCENDING};
        TableColumn col = this.searchFieldsTable.getColumnModel().getColumn(2);
        MyComboBoxEditor myCBXEditor = new MyComboBoxEditor(values);
        col.setCellEditor(myCBXEditor);
        this.searchFieldsTable.setRowHeight(UIHelper.createComboBox().getPreferredSize().height);
        col.setCellRenderer(new MyComboBoxRenderer(values));
        this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "WB_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = ExpressSearchConfigDlg.this.searchFieldsTable.getSelectedRow();
                ExpressSearchConfigDlg.this.searchFieldsTableModel.moveRowUp(inx);
                ExpressSearchConfigDlg.this.searchFieldsTable.setRowSelectionInterval(inx - 1, inx - 1);
                ExpressSearchConfigDlg.this.updateEnabledState();
            }
        });
        this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "WB_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = ExpressSearchConfigDlg.this.searchFieldsTable.getSelectedRow();
                ExpressSearchConfigDlg.this.searchFieldsTableModel.moveRowDown(inx);
                ExpressSearchConfigDlg.this.searchFieldsTable.setRowSelectionInterval(inx + 1, inx + 1);
                ExpressSearchConfigDlg.this.updateEnabledState();
            }
        });
        PanelBuilder outer = new PanelBuilder(new FormLayout("p,6px,f:max(250px;p):g", "p,2px,f:p:g"));
        PanelBuilder builder = new PanelBuilder(new FormLayout("f:p:g", "p,10px,f:p:g"));
        CellConstraints cc = new CellConstraints();
        PanelBuilder innerBuilder = new PanelBuilder(new FormLayout("max(250px;p):g, 2px, p, 10px, max(250px;p):g", "p,2px,f:min(250px;p):g"));
        innerBuilder.add((Component)UIHelper.createI18NLabel("ExpressSearchConfigDlg.ES_SEARCHFIELDS", 0), cc.xy(1, 1));
        innerBuilder.add((Component)UIHelper.createI18NLabel("ExpressSearchConfigDlg.ES_DISPLAYFIELDS", 0), cc.xy(5, 1));
        PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
        upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
        upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
        innerBuilder.add((Component)upDownPanel.getPanel(), cc.xy(3, 3));
        this.displayList = new ToggleButtonChooserPanel(maxDisplayCnt, ToggleButtonChooserPanel.Type.Checkbox);
        this.displayList.setUseScrollPane(true);
        this.displayList.setOkBtn(this.okBtn);
        this.displayList.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JToggleButton tb = (JToggleButton)e.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExpressSearchConfigDlg.this.itemDisplayChecked(tb);
                    }
                });
            }
        });
        this.displayList.createUI();
        JScrollPane sp = new JScrollPane(this.searchFieldsTable, 20, 30);
        innerBuilder.add((Component)sp, cc.xy(1, 3));
        innerBuilder.add((Component)this.displayList.getUIComponent(), cc.xy(5, 3));
        this.tableList.setVisibleRowCount(10);
        sp = new JScrollPane(this.tableList, 20, 31);
        builder.add((Component)sp, cc.xy(1, 1));
        builder.add((Component)innerBuilder.getPanel(), cc.xy(1, 3));
        this.tableList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ExpressSearchConfigDlg.this.tableSelected();
                }
            }
        });
        this.toBeSearchedList = new JList();
        this.toBeSearchedList.setCellRenderer(nameRender);
        this.toBeSearchedList.setModel(new VecModel());
        sp = new JScrollPane(this.toBeSearchedList, 20, 31);
        this.toBeSearchedList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExpressSearchConfigDlg.this.toBeSearchedSelected();
            }
        });
        outer.add((Component)UIHelper.createI18NLabel("ExpressSearchConfigDlg.ES_AVAIL_TABLES", 0), cc.xy(1, 1));
        outer.add((Component)builder.getPanel(), cc.xy(1, 3));
        outer.add((Component)UIHelper.createI18NLabel("ExpressSearchConfigDlg.ES_FLDS_TO_SEARCH", 0), cc.xy(3, 1));
        outer.add((Component)sp, cc.xy(3, 3));
        this.orderPanel = new ESTableOrderPanel(this.config);
        if (this.config != null) {
            for (SearchTableConfig stc : this.config.getTables()) {
                for (SearchFieldConfig sfc : stc.getSearchFields()) {
                    if (!sfc.isInUse()) continue;
                    this.toBeSearchedVect.add(sfc);
                }
            }
            Collections.sort(this.toBeSearchedVect, this.toBeSearchedComparator);
        }
        this.orderPanel.loadOrderList(this.toBeSearchedVect);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(ExpressSearchConfigDlg.getI18NStr("ES_SEARCH_FIELDS"), outer.getPanel());
        this.tabbedPane.add(ExpressSearchConfigDlg.getI18NStr("ES_RELATED_TABLES"), new RelatedTableInfoPanel(this.config));
        this.tabbedPane.add(ExpressSearchConfigDlg.getI18NStr("ES_RESULTS_ORDERING"), this.orderPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExpressSearchConfigDlg.this.tabChanged();
            }
        });
        JPanel tPanel = new JPanel(new BorderLayout());
        tPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        tPanel.add((Component)UIHelper.createI18NLabel("ExpressSearchConfigDlg.ES_EXPLAIN", 0), "North");
        tPanel.add((Component)this.tabbedPane, "Center");
        this.contentPanel = tPanel;
        this.mainPanel.add(this.contentPanel, "Center");
        this.pack();
    }

    private static String getI18NStr(String subKey) {
        return UIRegistry.getResourceString("ExpressSearchConfigDlg." + subKey);
    }

    public static Comparator<TableNameRendererIFace> getTableFieldNameComparator() {
        return new Comparator<TableNameRendererIFace>(){

            @Override
            public int compare(TableNameRendererIFace o1, TableNameRendererIFace o2) {
                return ExpressSearchConfigDlg.makeName(o1).compareTo(ExpressSearchConfigDlg.makeName(o2));
            }
        };
    }

    protected static String makeName(TableNameRendererIFace tnr) {
        SearchFieldConfig sfc = (SearchFieldConfig)tnr;
        return String.valueOf(sfc.getFieldInfo().getTableInfo().getName()) + sfc.getFieldInfo().getColumn();
    }

    protected void updateEnabledState() {
        int inx = this.searchFieldsTable.getSelectedRow();
        this.orderUpBtn.setEnabled(inx > 0);
        this.orderDwnBtn.setEnabled(inx > -1 && inx < this.searchFieldsTableModel.getRowCount() - 1);
    }

    protected void tabChanged() {
        int index = this.tabbedPane.getSelectedIndex();
        HelpMgr.registerComponent((AbstractButton)this.helpBtn, TAB_HELP_CONTEXT[index]);
        Component comp = this.tabbedPane.getComponent(index);
        if (comp == this.orderPanel) {
            this.orderPanel.loadOrderList(this.toBeSearchedVect);
        } else if (this.currTabComp == this.orderPanel) {
            this.orderPanel.grabOrderInList();
        }
        this.currTabComp = comp;
    }

    protected void toBeSearchedSelected() {
        SearchFieldConfig str = (SearchFieldConfig)this.toBeSearchedList.getSelectedValue();
        if (str != null) {
            int i = 0;
            for (SearchTableConfig stc : this.tiRenderList) {
                if (str.getStc().getTableInfo() == stc.getTableInfo()) {
                    this.tableList.setSelectedIndex(i);
                    this.tableList.ensureIndexIsVisible(i);
                    break;
                }
                ++i;
            }
        }
    }

    protected int getCountSelectedSearchFields() {
        int cnt = 0;
        int i = 0;
        while (i < this.searchFieldsTableModel.getRowCount()) {
            SearchFieldConfig sfc = this.searchFieldsTableModel.getFields().get(i);
            if (sfc.isInUse()) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    protected void enableSearchBtns(boolean enable, boolean doClearCheck) {
        for (JToggleButton btn : this.displayList.getButtons()) {
            DisplayFieldConfig dfc = this.displayList.getItemForBtn(btn);
            if (dfc == null) continue;
            if (doClearCheck) {
                dfc.setInUse(false);
            }
            if (!enable) {
                btn.setSelected(false);
            }
            btn.setEnabled(enable);
        }
    }

    protected void itemDisplayChecked(JToggleButton btn) {
        DisplayFieldConfig dfc = this.displayList.getItemForBtn(btn);
        if (btn.isSelected()) {
            dfc.setInUse(true);
        } else {
            dfc.setInUse(false);
        }
    }

    protected void tableSelected() {
        SearchTableConfig stc = (SearchTableConfig)this.tableList.getSelectedValue();
        if (stc != null) {
            Collections.sort(stc.getDisplayFields());
            this.displayList.setItems(stc.getDisplayFields());
            this.searchFieldsTableModel.add(stc.getSearchFields());
            this.searchFieldsTable.getSelectionModel().clearSelection();
            for (SearchFieldConfig sfc : stc.getSearchFields()) {
                if (!sfc.isInUse()) continue;
                this.autoSelectDisplayListField(sfc, true);
            }
            for (DisplayFieldConfig dfc : stc.getDisplayFields()) {
                if (!dfc.isInUse()) continue;
                this.displayList.setSelectedObj(dfc);
            }
        } else {
            this.displayList.setItems(null);
            this.searchFieldsTableModel.add(null);
            this.searchFieldsTable.getSelectionModel().clearSelection();
        }
    }

    @Override
    protected void cancelButtonPressed() {
        this.pruneTree();
        super.cancelButtonPressed();
    }

    protected void pruneTree() {
        for (SearchTableConfig stc : new Vector<SearchTableConfig>(this.config.getTables())) {
            if (stc.hasConfiguredSearchFields()) {
                for (SearchFieldConfig sfc : new Vector<SearchFieldConfig>(stc.getSearchFields())) {
                    if (sfc.isInUse()) continue;
                    stc.getSearchFields().remove(sfc);
                }
                for (DisplayFieldConfig dfc : new Vector<DisplayFieldConfig>(stc.getDisplayFields())) {
                    if (dfc.isInUse()) continue;
                    stc.getDisplayFields().remove(dfc);
                }
                if (!stc.hasConfiguredSearchFields()) {
                    this.config.removeTable(stc);
                }
                Collections.sort(stc.getSearchFields());
                Collections.sort(stc.getDisplayFields());
                continue;
            }
            this.config.removeTable(stc);
        }
    }

    @Override
    protected void okButtonPressed() {
        this.pruneTree();
        this.orderPanel.saveChanges(this.toBeSearchedVect);
        XStream xstream = new XStream();
        SearchConfig.configXStream(xstream);
        this.searchConfigService.saveConfig();
        super.okButtonPressed();
    }

    protected void autoSelectDisplayListField(SearchFieldConfig sfc, boolean wasAdded) {
        int index = 0;
        for (DisplayFieldConfig dfc : this.displayList.getItems()) {
            if (dfc.getFieldInfo() == sfc.getFieldInfo()) {
                JToggleButton tb = this.displayList.getButtons().get(index);
                tb.setSelected(wasAdded);
                if (wasAdded) {
                    tb.setEnabled(!wasAdded);
                } else {
                    tb.setEnabled(true);
                }
                dfc.setInUse(wasAdded);
                return;
            }
            ++index;
        }
    }

    @Override
    public void cleanUp() {
        if (this.btnPressed == 0) {
            this.pruneTree();
        }
    }

    public class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SearchFieldConfig sfc = ((SearchFieldsTableModel)table.getModel()).getFields().get(row);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setEnabled(sfc.isInUse());
            this.setSelectedItem(value);
            return this;
        }
    }

    class SearchFieldsTableModel
    extends AbstractTableModel {
        protected Vector<String> headings = new Vector();
        protected Vector<SearchFieldConfig> fields = new Vector();
        protected Class<?>[] classes = new Class[]{Boolean.class, String.class, String.class};

        public SearchFieldsTableModel() {
            String[] heads;
            String[] stringArray = heads = new String[]{"ExpressSearchConfigDlg.SEARCH", "ExpressSearchConfigDlg.ES_FIELDNAME", "ExpressSearchConfigDlg.ES_SORTING"};
            int n = heads.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.headings.add(UIRegistry.getResourceString(key));
                ++n2;
            }
        }

        public void add(Vector<SearchFieldConfig> flds) {
            this.fields = flds;
            if (this.fields != null) {
                int i = 0;
                for (SearchFieldConfig sfc : this.fields) {
                    sfc.setOrder(i++);
                }
                this.fireTableRowsInserted(0, flds.size());
            } else {
                this.fireTableDataChanged();
            }
        }

        public void moveRowUp(int index) {
            SearchFieldConfig sfc = this.fields.get(index);
            this.fields.remove(index);
            this.fields.insertElementAt(sfc, index - 1);
            this.fields.get(index - 1).setOrder(index - 1);
            this.fields.get(index).setOrder(index);
            this.fireTableRowsUpdated(index - 1, index);
        }

        public void moveRowDown(int index) {
            SearchFieldConfig sfc = this.fields.get(index);
            this.fields.remove(index);
            this.fields.insertElementAt(sfc, index + 1);
            this.fields.get(index).setOrder(index);
            this.fields.get(index + 1).setOrder(index + 1);
            this.fireTableRowsUpdated(index, index + 1);
        }

        public Vector<SearchFieldConfig> getFields() {
            return this.fields;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.classes[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.headings.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.headings.get(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.fields == null ? 0 : this.fields.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchFieldConfig sfc;
            if (this.fields != null && (sfc = this.fields.get(rowIndex)) != null) {
                switch (columnIndex) {
                    case 0: {
                        return sfc.isInUse();
                    }
                    case 1: {
                        return sfc.toString();
                    }
                    case 2: {
                        if (!sfc.getIsSortable().booleanValue()) {
                            return NONE;
                        }
                        return sfc.getIsAscending() != false ? ASCENDING : DESCENDING;
                    }
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            SearchFieldConfig sfc = this.fields.get(rowIndex);
            if (sfc != null) {
                switch (columnIndex) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return sfc.isInUse();
                    }
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SearchFieldConfig sfc = this.fields.get(rowIndex);
            if (sfc != null) {
                switch (columnIndex) {
                    case 0: {
                        int cnt = ExpressSearchConfigDlg.this.getCountSelectedSearchFields();
                        sfc.setInUse((Boolean)value);
                        if (cnt == 0 && ((Boolean)value).booleanValue()) {
                            ExpressSearchConfigDlg.this.enableSearchBtns(true, false);
                        }
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        if (sfc.isInUse()) {
                            ExpressSearchConfigDlg.this.toBeSearchedVect.add(sfc);
                            Collections.sort(ExpressSearchConfigDlg.this.toBeSearchedVect, ExpressSearchConfigDlg.this.toBeSearchedComparator);
                            ((VecModel)ExpressSearchConfigDlg.this.toBeSearchedList.getModel()).fireChange(null);
                            ExpressSearchConfigDlg.this.autoSelectDisplayListField(sfc, true);
                        } else {
                            ExpressSearchConfigDlg.this.toBeSearchedVect.remove(sfc);
                            ((VecModel)ExpressSearchConfigDlg.this.toBeSearchedList.getModel()).fireChange(null);
                            ExpressSearchConfigDlg.this.autoSelectDisplayListField(sfc, false);
                        }
                        if (cnt != 1 || ((Boolean)value).booleanValue()) break;
                        ExpressSearchConfigDlg.this.enableSearchBtns(false, true);
                        break;
                    }
                    case 1: {
                        sfc.setFieldName((String)value);
                        break;
                    }
                    case 2: {
                        String valStr = (String)value;
                        if (valStr.equals(NONE)) {
                            sfc.setIsSortable(false);
                        } else if (valStr.equals(ASCENDING)) {
                            sfc.setIsSortable(true);
                            sfc.setIsAscending(true);
                        } else if (valStr.equals(DESCENDING)) {
                            sfc.setIsSortable(true);
                            sfc.setIsAscending(false);
                        }
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }
        }
    }

    class VecModel
    extends AbstractListModel {
        VecModel() {
        }

        @Override
        public int getSize() {
            return ExpressSearchConfigDlg.this.toBeSearchedVect.size();
        }

        @Override
        public Object getElementAt(int index) {
            return ExpressSearchConfigDlg.this.toBeSearchedVect.get(index);
        }

        public void fireChange(DBFieldInfo field) {
            this.fireContentsChanged(this, 0, ExpressSearchConfigDlg.this.toBeSearchedVect.size());
        }
    }
}

