/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.expresssearch.ERTIJoinColInfo;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ExpressSearchConfigCache {
    private static final Logger log = Logger.getLogger(ExpressSearchConfigCache.class);
    protected static ExpressSearchConfigCache instance = new ExpressSearchConfigCache();
    protected static SoftReference<TableInfoSoftRef> tableInfo = null;

    public static synchronized TableInfoSoftRef getTableInfoWeakRef() {
        TableInfoSoftRef tableInfoWR = null;
        if (instance != null) {
            if (tableInfo != null) {
                tableInfoWR = tableInfo.get();
            }
            if (tableInfoWR == null) {
                tableInfoWR = ExpressSearchConfigCache.intializeTableInfo();
                tableInfo = new SoftReference<TableInfoSoftRef>(tableInfoWR);
            }
        }
        return tableInfoWR;
    }

    public static ExpressResultsTableInfo getTableInfoByName(String name) {
        return ExpressSearchConfigCache.getTableInfoWeakRef().getTables().get(name);
    }

    public static Hashtable<String, ExpressResultsTableInfo> getTableInfoHash() {
        return instance != null ? ExpressSearchConfigCache.getTableInfoWeakRef().getTables() : null;
    }

    public static Hashtable<String, ExpressResultsTableInfo> getSearchIdToTableInfoHash() {
        return ExpressSearchConfigCache.getTableInfoWeakRef().getSearchIdToTableInfoHash();
    }

    public static Hashtable<String, List<ExpressResultsTableInfo>> getJoinIdToTableInfoHash() {
        return ExpressSearchConfigCache.getTableInfoWeakRef().getJoinIdToTableInfoHash();
    }

    protected static void intializeTableInfo(List<?> tableItems, Hashtable<String, ExpressResultsTableInfo> tables, Hashtable<String, ExpressResultsTableInfo> byIdHash, Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash, boolean isExpressSearch, ResourceBundle resBundle) {
        for (Element tableElement : tableItems) {
            ExpressResultsTableInfo erti = new ExpressResultsTableInfo(tableElement, isExpressSearch, resBundle);
            if (byIdHash.get(erti.getId()) == null) {
                byIdHash.put(erti.getId(), erti);
                if (tables.get(erti.getName()) == null) {
                    tables.put(erti.getName(), erti);
                    ERTIJoinColInfo[] joinCols = erti.getJoins();
                    if (joinCols == null) continue;
                    ERTIJoinColInfo[] eRTIJoinColInfoArray = joinCols;
                    int n = joinCols.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ERTIJoinColInfo jci = eRTIJoinColInfoArray[n2];
                        List<ExpressResultsTableInfo> list = joinIdToTableInfoHash.get(jci.getJoinTableId());
                        if (list == null) {
                            list = new ArrayList<ExpressResultsTableInfo>();
                            joinIdToTableInfoHash.put(jci.getJoinTableId(), list);
                        }
                        list.add(erti);
                        ++n2;
                    }
                    continue;
                }
                log.error((Object)("Duplicate express Search name[" + erti.getName() + "]"));
                continue;
            }
            log.error((Object)("Duplicate Search Id[" + erti.getId() + "]"));
        }
    }

    protected static synchronized TableInfoSoftRef intializeTableInfo() {
        if (instance != null) {
            Hashtable<String, ExpressResultsTableInfo> tables = new Hashtable<String, ExpressResultsTableInfo>();
            Hashtable<String, ExpressResultsTableInfo> idToTableInfoHash = new Hashtable<String, ExpressResultsTableInfo>();
            Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash = new Hashtable<String, List<ExpressResultsTableInfo>>();
            ResourceBundle resBundle = ResourceBundle.getBundle("expresssearch");
            try {
                Element esDOM = AppContextMgr.getInstance().getResourceAsDOM("SearchConfig");
                if (esDOM != null) {
                    ExpressSearchConfigCache.intializeTableInfo(esDOM.selectNodes("/searches/express/table"), tables, idToTableInfoHash, joinIdToTableInfoHash, true, resBundle);
                    ExpressSearchConfigCache.intializeTableInfo(esDOM.selectNodes("/searches/generic/table"), tables, idToTableInfoHash, joinIdToTableInfoHash, false, resBundle);
                } else {
                    UIRegistry.showLocalizedError("ERR_NEED_SHUTDOWN");
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(ExpressSearchConfigCache.class, ex);
                log.error((Object)ex);
                ex.printStackTrace();
            }
            ExpressSearchConfigCache expressSearchConfigCache = instance;
            expressSearchConfigCache.getClass();
            return expressSearchConfigCache.new TableInfoSoftRef(tables, idToTableInfoHash, joinIdToTableInfoHash);
        }
        return null;
    }

    protected static String getResourceString(ResourceBundle resBundle, String key) {
        try {
            return resBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(ExpressSearchConfigCache.class, ex);
            log.error((Object)("Couldn't find key[" + key + "] in resource bundle [" + key + "]"));
            return key;
        }
    }

    public class TableInfoSoftRef {
        protected Hashtable<String, ExpressResultsTableInfo> tables = new Hashtable();
        protected Hashtable<String, ExpressResultsTableInfo> idToTableInfoHash = new Hashtable();
        protected Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash = new Hashtable();

        public TableInfoSoftRef(Hashtable<String, ExpressResultsTableInfo> tables, Hashtable<String, ExpressResultsTableInfo> idToTableInfoHash, Hashtable<String, List<ExpressResultsTableInfo>> joinIdToTableInfoHash) {
            this.tables = tables;
            this.idToTableInfoHash = idToTableInfoHash;
            this.joinIdToTableInfoHash = joinIdToTableInfoHash;
        }

        public Hashtable<String, ExpressResultsTableInfo> getSearchIdToTableInfoHash() {
            return this.idToTableInfoHash;
        }

        public Hashtable<String, List<ExpressResultsTableInfo>> getJoinIdToTableInfoHash() {
            return this.joinIdToTableInfoHash;
        }

        public Hashtable<String, ExpressResultsTableInfo> getTables() {
            return this.tables;
        }
    }
}

