/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.ERTIJoinColInfo;
import edu.ku.brc.af.ui.db.ERTICaptionInfo;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Color;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ExpressResultsTableInfo {
    private static final Logger log = Logger.getLogger(ExpressResultsTableInfo.class);
    protected String id;
    protected String tableId;
    protected String title;
    protected String name;
    protected boolean isExpressSearch = true;
    protected boolean isFieldNameOnlyForSQL = false;
    protected String description;
    protected String iconName = null;
    protected String viewSql;
    protected boolean viewSQLOverridden = false;
    protected ERTIJoinColInfo[] joinCols = null;
    protected List<ERTICaptionInfo> captionInfo;
    protected List<ERTICaptionInfo> visibleCaptionInfo;
    protected Color color;
    private DBTableInfo tableInfo = null;

    public ExpressResultsTableInfo(Element tableElement, boolean isExpressSearch, ResourceBundle resBundle) {
        this.isExpressSearch = isExpressSearch;
        this.fill(tableElement, resBundle);
    }

    public void fill(Element tableElement, ResourceBundle resBundle) {
        int i;
        this.id = tableElement.attributeValue("id");
        this.tableId = tableElement.attributeValue("tableid");
        this.name = tableElement.attributeValue("name");
        this.color = UIHelper.parseRGB(tableElement.attributeValue("color"));
        if (this.isExpressSearch) {
            this.title = resBundle.getString(this.name);
            if (StringUtils.isEmpty((String)this.title)) {
                log.error((Object)("Express Search with name[" + this.name + "] is missing it's title in the expressearch properties file."));
            }
            this.description = resBundle.getString(String.valueOf(this.name) + "_desc");
            if (StringUtils.isEmpty((String)this.description)) {
                log.error((Object)("Express Search with name[" + this.name + "] is missing it's description in the expressearch properties file."));
            }
        } else {
            DBTableInfo tblInfo = this.getTableInfo();
            if (tblInfo != null) {
                this.title = tblInfo.getTitle();
            }
        }
        if (StringUtils.isEmpty((String)this.title)) {
            this.title = UIRegistry.getResourceString("ExpressResultsTableInfo.NOTITLE");
        }
        Element viewElement = (Element)tableElement.selectSingleNode("detailView");
        Element sqlElement = (Element)viewElement.selectSingleNode("sql");
        this.isFieldNameOnlyForSQL = XMLHelper.getAttr(sqlElement, "fieldnameonly", false);
        this.viewSql = StringUtils.strip((String)sqlElement.getText());
        this.iconName = viewElement.attributeValue("icon");
        List captionItems = viewElement.selectNodes("captions/caption");
        if (captionItems.size() > 0) {
            int captionCount = captionItems.size();
            this.captionInfo = new Vector<ERTICaptionInfo>(captionCount);
            i = 0;
            for (Element captionElement : captionItems) {
                ERTICaptionInfo capInfo = new ERTICaptionInfo(captionElement, resBundle);
                if (capInfo.isVisible()) {
                    this.captionInfo.add(capInfo);
                    capInfo.setPosIndex(i);
                    if (capInfo.getColName() == null && capInfo.getColInfoList().size() > 0) {
                        i += capInfo.getColInfoList().size() - 1;
                    }
                } else {
                    capInfo.setPosIndex(-1);
                }
                ++i;
            }
            if (this.captionInfo.size() != captionCount) {
                this.visibleCaptionInfo = new Vector<ERTICaptionInfo>(this.captionInfo.size());
                for (ERTICaptionInfo c : this.captionInfo) {
                    this.visibleCaptionInfo.add(c);
                }
            }
        } else {
            throw new RuntimeException("No Captions!");
        }
        List joinColItems = tableElement.selectNodes("joins/join");
        if (joinColItems != null && joinColItems.size() > 0) {
            this.joinCols = new ERTIJoinColInfo[joinColItems.size()];
            i = 0;
            while (i < joinColItems.size()) {
                this.joinCols[i] = new ERTIJoinColInfo((Element)joinColItems.get(i));
                ++i;
            }
        }
    }

    public void cleanUp() {
        this.captionInfo = null;
        this.joinCols = null;
        this.viewSql = null;
    }

    public void finalize() {
        this.cleanUp();
    }

    public List<ERTICaptionInfo> getVisibleCaptionInfo() {
        return this.visibleCaptionInfo;
    }

    public List<ERTICaptionInfo> getCaptionInfo() {
        return this.captionInfo;
    }

    public ERTIJoinColInfo[] getJoins() {
        return this.joinCols;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
        this.viewSQLOverridden = true;
    }

    public void setViewSQLOverridden(boolean viewSQLOverridden) {
        this.viewSQLOverridden = viewSQLOverridden;
    }

    public String getId() {
        return this.id;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getIconName() {
        return this.iconName;
    }

    public int getVisColCount() {
        return this.visibleCaptionInfo.size();
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isFieldNameOnlyForSQL() {
        return this.isFieldNameOnlyForSQL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DBTableInfo getTableInfo() {
        if (this.tableInfo == null) {
            this.tableInfo = DBTableIdMgr.getInstance().getInfoById(this.tableId);
        }
        return this.tableInfo;
    }
}

