/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.expresssearch.DisplayOrderingIFace;
import edu.ku.brc.af.core.expresssearch.ExpressResultsTableInfo;
import edu.ku.brc.af.core.expresssearch.ExpressSearchConfigCache;
import edu.ku.brc.af.core.expresssearch.RelatedQuery;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.core.expresssearch.TableNameRenderer;
import edu.ku.brc.af.core.expresssearch.TableNameRendererIFace;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ESTableOrderPanel
extends JPanel {
    protected SearchConfig config;
    protected JList orderTablesList;
    protected DefaultListModel orderTablesModel = new DefaultListModel();
    protected JButton orderUpBtn;
    protected JButton orderDwnBtn;
    protected Hashtable<SearchTableConfig, Boolean> usedHash = new Hashtable();
    protected Hashtable<String, RelatedQuery> relatedQueriesHash = new Hashtable();

    public ESTableOrderPanel(SearchConfig config) {
        this.config = config;
        PanelBuilder outer = new PanelBuilder(new FormLayout("f:p:g,2px,p", "p,2px,f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        this.orderTablesList = new JList(this.orderTablesModel);
        TableNameRenderer nameRender = new TableNameRenderer(IconManager.IconSize.Std24);
        nameRender.setUseIcon("PlaceHolder");
        this.orderTablesList.setCellRenderer(nameRender);
        this.orderTablesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ESTableOrderPanel.this.updateEnabledState();
            }
        });
        outer.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("ES_ORDER_RET_RES")), cc.xy(1, 1));
        outer.add((Component)UIHelper.createScrollPane(this.orderTablesList), cc.xy(1, 3));
        this.orderUpBtn = UIHelper.createIconBtn("ReorderUp", "ES_RES_MOVE_UP", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = ESTableOrderPanel.this.orderTablesList.getSelectedIndex();
                DisplayOrderingIFace item = (DisplayOrderingIFace)ESTableOrderPanel.this.orderTablesModel.getElementAt(inx);
                DisplayOrderingIFace prev = (DisplayOrderingIFace)ESTableOrderPanel.this.orderTablesModel.getElementAt(inx - 1);
                ESTableOrderPanel.this.orderTablesModel.remove(inx);
                ESTableOrderPanel.this.orderTablesModel.insertElementAt(item, inx - 1);
                ESTableOrderPanel.this.orderTablesList.setSelectedIndex(inx - 1);
                item.setDisplayOrder(inx - 1);
                prev.setDisplayOrder(inx);
                ESTableOrderPanel.this.updateEnabledState();
            }
        });
        this.orderDwnBtn = UIHelper.createIconBtn("ReorderDown", "ES_RES_MOVE_DOWN", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int inx = ESTableOrderPanel.this.orderTablesList.getSelectedIndex();
                DisplayOrderingIFace item = (DisplayOrderingIFace)ESTableOrderPanel.this.orderTablesModel.getElementAt(inx);
                DisplayOrderingIFace nxt = (DisplayOrderingIFace)ESTableOrderPanel.this.orderTablesModel.getElementAt(inx + 1);
                ESTableOrderPanel.this.orderTablesModel.remove(inx);
                ESTableOrderPanel.this.orderTablesModel.insertElementAt(item, inx + 1);
                ESTableOrderPanel.this.orderTablesList.setSelectedIndex(inx + 1);
                item.setDisplayOrder(inx + 1);
                nxt.setDisplayOrder(inx);
                ESTableOrderPanel.this.updateEnabledState();
            }
        });
        PanelBuilder upDownPanel = new PanelBuilder(new FormLayout("p", "f:p:g, p, 2px, p, f:p:g"));
        upDownPanel.add((Component)this.orderUpBtn, cc.xy(1, 2));
        upDownPanel.add((Component)this.orderDwnBtn, cc.xy(1, 4));
        outer.add((Component)upDownPanel.getPanel(), cc.xy(3, 3));
        outer.getPanel().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    protected void updateEnabledState() {
        int inx = this.orderTablesList.getSelectedIndex();
        this.orderUpBtn.setEnabled(inx > 0);
        this.orderDwnBtn.setEnabled(inx > -1 && inx < this.orderTablesModel.size() - 1);
    }

    protected void loadOrderList(Vector<SearchFieldConfig> currSearchableList) {
        Vector<Comparable<SearchTableConfig>> tblList = new Vector<Comparable<SearchTableConfig>>();
        int newOrdercnt = 1000;
        this.usedHash.clear();
        for (SearchFieldConfig sfc : currSearchableList) {
            SearchTableConfig stc = sfc.getStc();
            if (stc.hasConfiguredSearchFields()) {
                if (this.usedHash.get(stc) != null) continue;
                if (stc.getDisplayOrder() == null) {
                    stc.setDisplayOrder(newOrdercnt++);
                } else if (stc.getDisplayOrder() == null) {
                    stc.setDisplayOrder(newOrdercnt++);
                }
                tblList.add(stc);
                this.usedHash.put(stc, true);
                continue;
            }
            stc.setDisplayOrder(null);
        }
        for (RelatedQuery rq : this.config.getRelatedQueries()) {
            rq.setInUse(false);
        }
        Hashtable<String, List<ExpressResultsTableInfo>> joinHash = ExpressSearchConfigCache.getJoinIdToTableInfoHash();
        Hashtable<String, ExpressResultsTableInfo> duplicateHash = new Hashtable<String, ExpressResultsTableInfo>();
        for (SearchFieldConfig sfc : currSearchableList) {
            List<ExpressResultsTableInfo> joinList;
            SearchTableConfig stc = sfc.getStc();
            if (!stc.hasConfiguredSearchFields() || (joinList = joinHash.get(Integer.toString(stc.getTableInfo().getTableId()))) == null) continue;
            for (ExpressResultsTableInfo erti : joinList) {
                if (duplicateHash.get(erti.getId()) != null) continue;
                RelatedQuery rq = this.relatedQueriesHash.get(erti.getId());
                if (rq == null) {
                    rq = this.config.findRelatedQueryOrCreate(erti.getId());
                    if (rq.getDisplayOrder() == Integer.MAX_VALUE) {
                        rq.setDisplayOrder(newOrdercnt++);
                    }
                    this.relatedQueriesHash.put(erti.getId(), rq);
                } else if (rq.getDisplayOrder() == null) {
                    rq.setDisplayOrder(newOrdercnt++);
                }
                rq.setErti(erti);
                rq.setInUse(true);
                duplicateHash.put(erti.getId(), erti);
            }
        }
        for (RelatedQuery rq : this.config.getRelatedQueries()) {
            if (rq.isInUse()) {
                tblList.add(rq);
                continue;
            }
            rq.setIsActive(false);
        }
        this.orderTablesModel.clear();
        Collections.sort(tblList, new Comparator<TableNameRendererIFace>(){

            @Override
            public int compare(TableNameRendererIFace o1, TableNameRendererIFace o2) {
                return ((DisplayOrderingIFace)((Object)o1)).getDisplayOrder().compareTo(((DisplayOrderingIFace)((Object)o2)).getDisplayOrder());
            }
        });
        int i = 0;
        for (TableNameRendererIFace tableNameRendererIFace : tblList) {
            ((DisplayOrderingIFace)((Object)tableNameRendererIFace)).setDisplayOrder(i++);
            if (tableNameRendererIFace instanceof RelatedQuery) {
                RelatedQuery rq = (RelatedQuery)tableNameRendererIFace;
                if (!rq.getIsActive().booleanValue()) continue;
                this.orderTablesModel.addElement(tableNameRendererIFace);
                continue;
            }
            this.orderTablesModel.addElement(tableNameRendererIFace);
        }
    }

    protected void grabOrderInList() {
    }

    public void saveChanges(Vector<SearchFieldConfig> currSearchableList) {
        this.loadOrderList(currSearchableList);
    }
}

