/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.expresssearch;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.ku.brc.af.core.expresssearch.DisplayFieldConfig;
import edu.ku.brc.af.core.expresssearch.SearchConfig;
import edu.ku.brc.af.core.expresssearch.SearchTableConfig;
import edu.ku.brc.af.core.expresssearch.TableNameRenderer;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToggleButtonChooserPanel;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DigirABCConfigPanel
extends JPanel {
    protected SearchConfig config;
    protected JList tableList;
    protected ToggleButtonChooserPanel<DisplayFieldConfig> displayList;

    public DigirABCConfigPanel(SearchConfig config, JButton okBtn) {
        this.config = config;
        this.buildUI(okBtn);
    }

    protected void buildUI(JButton okBtn) {
        Vector<SearchTableConfig> tiRenderList = new Vector<SearchTableConfig>();
        for (SearchTableConfig stc : this.config.getTables()) {
            tiRenderList.add(stc);
        }
        Collections.sort(tiRenderList);
        this.tableList = new JList(tiRenderList);
        TableNameRenderer nameRender = new TableNameRenderer(IconManager.IconSize.Std24);
        nameRender.setUseIcon("PlaceHolder");
        this.tableList.setCellRenderer(nameRender);
        this.tableList.setVisibleRowCount(10);
        JScrollPane sp = new JScrollPane(this.tableList, 20, 31);
        this.tableList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DigirABCConfigPanel.this.tableSelected();
                }
            }
        });
        this.displayList = new ToggleButtonChooserPanel(15, ToggleButtonChooserPanel.Type.Checkbox);
        this.displayList.setUseScrollPane(true);
        this.displayList.setOkBtn(okBtn);
        this.displayList.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JToggleButton tb = (JToggleButton)e.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DigirABCConfigPanel.this.itemDisplayChecked(tb);
                    }
                });
            }
        });
        this.displayList.createUI();
        PanelBuilder builder = new PanelBuilder(new FormLayout("p,2px,p", "p,2px,f:p:g"), (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DigirABCConfigPanel.DIGIR_AVAIL_TABLES"), 0), cc.xy(1, 1));
        builder.add((Component)UIHelper.createLabel(UIRegistry.getResourceString("DigirABCConfigPanel.DIGIR_FIELDNAME"), 0), cc.xy(3, 1));
        builder.add((Component)sp, cc.xy(1, 3));
        JScrollPane dspSp = new JScrollPane(this.displayList, 20, 30);
        builder.add((Component)dspSp, cc.xy(3, 3));
    }

    protected void tableSelected() {
        SearchTableConfig stc = (SearchTableConfig)this.tableList.getSelectedValue();
        this.displayList.setItems(stc.getDisplayFields());
        for (DisplayFieldConfig dfc : stc.getDisplayFields()) {
            if (!dfc.isWebServiceField()) continue;
            this.displayList.setSelectedObj(dfc);
        }
    }

    protected void itemDisplayChecked(JToggleButton btn) {
        DisplayFieldConfig dfc = this.displayList.getItemForBtn(btn);
        if (btn.isSelected()) {
            dfc.setInUse(true);
            dfc.setIsWebServiceField(true);
        } else {
            dfc.setInUse(false);
            dfc.setIsWebServiceField(false);
        }
    }
}

