/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.auth.UserAndMasterPasswordMgr;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.BackupServiceFactory;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.BackupCompareDlg;
import edu.ku.brc.dbsupport.DBConnection;
import edu.ku.brc.dbsupport.DBMSUserMgr;
import edu.ku.brc.dbsupport.DatabaseDriverInfo;
import edu.ku.brc.helpers.ZipFileHelper;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.JStatusBar;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import edu.ku.brc.util.Pair;
import java.awt.FileDialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MySQLBackupService
extends BackupServiceFactory {
    private static final Logger log = Logger.getLogger(MySQLBackupService.class);
    private final String WEEKLY_PREF = "LAST.BACKUP.WEEKLY";
    private final String MONTHLY_PREF = "LAST.BACKUP.MONS";
    private final String RESTORE_COMPLETE = "MySQLBackupService.RESTORE_COMPLETE";
    private final String STATUSBAR_NAME = "BackUp";
    private final String MYSQLDUMP_LOC = "mysqldump.location";
    private final String MYSQL_LOC = "mysql.location";
    private final String MYSQLBCK_LOC = "backup.location";
    private final String MEGS = "MEGS";
    private int numTables;
    private String errorMsg = null;

    @Override
    public int getNumberofTables() {
        Connection dbConnection = null;
        Statement dbStatement = null;
        try {
            dbConnection = DBConnection.getInstance().createConnection();
            if (dbConnection != null) {
                dbStatement = dbConnection.createStatement(1005, 1007);
                ResultSet resultSet = dbStatement.executeQuery("SHOW TABLES");
                ResultSetMetaData metaData = resultSet.getMetaData();
                this.numTables = 0;
                while (resultSet.next()) {
                    int i = 0;
                    while (i < metaData.getColumnCount()) {
                        ++this.numTables;
                        ++i;
                    }
                }
                resultSet.close();
                int n = this.numTables;
                return n;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dbStatement != null) {
                    dbStatement.close();
                }
                if (dbConnection != null) {
                    dbConnection.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public Vector<String> getTableNames() {
        Vector<String> tablesNames = new Vector<String>();
        Connection dbConnection = null;
        Statement dbStatement = null;
        try {
            dbConnection = DBConnection.getInstance().createConnection();
            if (dbConnection != null) {
                dbStatement = dbConnection.createStatement(1005, 1007);
                ResultSet resultSet = dbStatement.executeQuery("show tables");
                ResultSetMetaData metaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    int i = 0;
                    while (i < metaData.getColumnCount()) {
                        String name = resultSet.getString(i + 1);
                        tablesNames.add(name);
                        ++i;
                    }
                }
                resultSet.close();
                Vector<String> vector = tablesNames;
                return vector;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (dbStatement != null) {
                    dbStatement.close();
                }
                if (dbConnection != null) {
                    dbConnection.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void doBackUp() {
        this.checkForBackUp(false, true);
    }

    @Override
    public void doBackUp(PropertyChangeListener pcl) {
        this.doBackUp(false, false, pcl);
    }

    private boolean doBackUp(final boolean isMonthly, final boolean doSendAppExit, final PropertyChangeListener propChgListener) {
        AppPreferences remotePrefs = AppPreferences.getLocalPrefs();
        final String mysqldumpLoc = remotePrefs.get("mysqldump.location", MySQLBackupService.getDefaultMySQLDumpLoc());
        final String backupLoc = remotePrefs.get("backup.location", MySQLBackupService.getDefaultBackupLoc());
        if (!new File(mysqldumpLoc).exists()) {
            UIRegistry.showLocalizedError("MySQLBackupService.MYSQL_NO_DUMP", mysqldumpLoc);
            if (propChgListener != null) {
                propChgListener.propertyChange(new PropertyChangeEvent(this, "Error", 0, 1));
            }
            return false;
        }
        File backupDir = new File(backupLoc);
        if (!backupDir.exists() && !backupDir.mkdir()) {
            UIRegistry.showLocalizedError("MySQLBackupService.MYSQL_NO_BK_DIR", backupDir.getAbsoluteFile());
            if (propChgListener != null) {
                propChgListener.propertyChange(new PropertyChangeEvent(this, "Error", 0, 1));
            }
            return false;
        }
        this.errorMsg = null;
        final String databaseName = DBConnection.getInstance().getDatabaseName();
        this.getNumberofTables();
        SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
            protected String fullPath = null;

            @Override
            protected Integer doInBackground() throws Exception {
                block16: {
                    OutputStream backupOut = null;
                    try {
                        try {
                            String line;
                            Pair<String, String> up;
                            Thread.sleep(100L);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_kk_mm_ss");
                            String fileName = String.valueOf(sdf.format(Calendar.getInstance().getTime())) + (isMonthly ? "_monthly" : "") + ".sql";
                            this.fullPath = String.valueOf(backupLoc) + File.separator + fileName;
                            File file = new File(this.fullPath);
                            backupOut = new FileOutputStream(file);
                            MySQLBackupService.this.writeStats(MySQLBackupService.this.getCollectionStats(MySQLBackupService.this.getTableNames()), MySQLBackupService.this.getStatsName(this.fullPath));
                            String userName = DBConnection.getInstance().getUserName();
                            String password = DBConnection.getInstance().getPassword();
                            if ((StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password)) && (up = UserAndMasterPasswordMgr.getInstance().getUserNamePasswordForDB()) != null && up.first != null && up.second != null) {
                                userName = (String)up.first;
                                password = (String)up.second;
                            }
                            String port = DatabaseDriverInfo.getDriver(DBConnection.getInstance().getDriverName()).getPort();
                            String server = DBConnection.getInstance().getServerName();
                            String cmdLine = String.format("%s -u %s --password=%s --host=%s %s %s", mysqldumpLoc, userName, password, server, port != null ? "--port=" + port : "", databaseName);
                            String[] args = StringUtils.split((String)cmdLine, (char)' ');
                            Process process = Runtime.getRuntime().exec(args);
                            InputStream input = process.getInputStream();
                            byte[] bytes = new byte[16384];
                            double oneMeg = 1048576.0;
                            long dspMegs = 0L;
                            long totalBytes = 0L;
                            while (true) {
                                int numBytes = input.read(bytes, 0, bytes.length);
                                totalBytes += (long)numBytes;
                                if (numBytes <= 0) break;
                                long megs = (long)((double)totalBytes / oneMeg);
                                if (megs != dspMegs) {
                                    dspMegs = megs;
                                    long megsWithTenths = (long)((double)totalBytes * 10.0 / oneMeg);
                                    this.firePropertyChange("MEGS", 0, megsWithTenths);
                                }
                                ((FileOutputStream)backupOut).write(bytes, 0, numBytes);
                            }
                            StringBuilder sb = new StringBuilder();
                            BufferedReader errIn = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            while ((line = errIn.readLine()) != null) {
                                if (!line.startsWith("ERR") && !StringUtils.contains((String)line, (String)"Got error")) continue;
                                sb.append(line);
                                sb.append("\n");
                                if (!StringUtils.contains((String)line, (String)"1044") || !StringUtils.contains((String)line, (String)"LOCK TABLES")) continue;
                                sb.append("\n");
                                sb.append(UIRegistry.getResourceString("MySQLBackupService.LCK_TBL_ERR"));
                                sb.append("\n");
                            }
                            MySQLBackupService.this.errorMsg = sb.toString();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            MySQLBackupService.this.errorMsg = ex.toString();
                            UIRegistry.showLocalizedError("MySQLBackupService.EXCP_BK");
                            if (backupOut == null) break block16;
                            try {
                                backupOut.flush();
                                ((FileOutputStream)backupOut).close();
                            }
                            catch (IOException ex2) {
                                ex2.printStackTrace();
                                MySQLBackupService.this.errorMsg = ex2.toString();
                            }
                        }
                    }
                    finally {
                        if (backupOut != null) {
                            try {
                                backupOut.flush();
                                ((FileOutputStream)backupOut).close();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                MySQLBackupService.this.errorMsg = ex.toString();
                            }
                        }
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                UIRegistry.getStatusBar().setProgressDone("BackUp");
                UIRegistry.clearSimpleGlassPaneMsg();
                if (StringUtils.isNotEmpty((String)MySQLBackupService.this.errorMsg)) {
                    UIRegistry.showError(MySQLBackupService.this.errorMsg);
                }
                if (doSendAppExit) {
                    CommandDispatcher.dispatch(new CommandAction("App", "AppReqExit"));
                }
                if (propChgListener != null) {
                    propChgListener.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Done", null, this.fullPath));
                }
            }
        };
        final JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setIndeterminate("BackUp", true);
        UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("MySQLBackupService.BACKINGUP", databaseName), 24);
        backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MEGS".equals(evt.getPropertyName())) {
                    long value = (Long)evt.getNewValue();
                    double val = (double)value / 10.0;
                    statusBar.setText(UIRegistry.getLocalizedMessage("MySQLBackupService.BACKUP_MEGS", val));
                }
            }
        });
        backupWorker.execute();
        return true;
    }

    public void doCompareBeforeRestore(final String restoreFilePath, final SimpleGlassPane glassPane) {
        SwingWorker<Integer, Integer> backupWorker = new SwingWorker<Integer, Integer>(){
            protected Vector<Object[]> rowData = null;

            @Override
            protected Integer doInBackground() throws Exception {
                this.rowData = MySQLBackupService.this.doCompare(MySQLBackupService.this.getTableNames(), restoreFilePath);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                if (this.rowData != null && this.rowData.size() > 0) {
                    UIRegistry.getStatusBar().setProgressDone("BackUp");
                    BackupCompareDlg dlg = new BackupCompareDlg(this.rowData);
                    dlg.setVisible(true);
                    if (!dlg.isCancelled()) {
                        MySQLBackupService.this.doActualRestore(restoreFilePath, glassPane);
                    } else {
                        UIRegistry.clearSimpleGlassPaneMsg();
                    }
                } else {
                    MySQLBackupService.this.doActualRestore(restoreFilePath, glassPane);
                }
            }
        };
        backupWorker.execute();
    }

    @Override
    public void doRestore() {
        AppPreferences remotePrefs = AppPreferences.getLocalPrefs();
        String mysqlLoc = remotePrefs.get("mysql.location", MySQLBackupService.getDefaultMySQLLoc());
        String backupLoc = remotePrefs.get("backup.location", MySQLBackupService.getDefaultBackupLoc());
        if (!new File(mysqlLoc).exists()) {
            UIRegistry.showLocalizedError("MySQLBackupService.MYSQL_NO_RESTORE", mysqlLoc);
            return;
        }
        File backupDir = new File(backupLoc);
        if (!backupDir.exists() && !backupDir.mkdir()) {
            UIRegistry.showLocalizedError("MySQLBackupService.MYSQL_NO_BK_DIR", backupDir.getAbsoluteFile());
            return;
        }
        FileDialog dlg = new FileDialog((Frame)UIRegistry.getTopWindow(), UIRegistry.getResourceString("Open"), 0);
        dlg.setDirectory(backupLoc);
        dlg.setVisible(true);
        String dirStr = dlg.getDirectory();
        String fileName = dlg.getFile();
        if (StringUtils.isEmpty((String)dirStr) || StringUtils.isEmpty((String)fileName)) {
            return;
        }
        this.errorMsg = null;
        String path = String.valueOf(dirStr) + fileName;
        JStatusBar statusBar = UIRegistry.getStatusBar();
        statusBar.setIndeterminate("BackUp", true);
        String databaseName = DBConnection.getInstance().getDatabaseName();
        SimpleGlassPane glassPane = UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage("MySQLBackupService.RESTORING", databaseName), 24);
        this.doCompareBeforeRestore(path, glassPane);
    }

    protected void doActualRestore(String restoreFilePath, SimpleGlassPane glassPane) {
        String databaseName = DBConnection.getInstance().getDatabaseName();
        this.doRestoreInBackground(databaseName, restoreFilePath, glassPane, "MySQLBackupService.RESTORE_COMPLETE", null, false);
    }

    @Override
    public boolean doRestoreInBackground(String databaseName, String restoreFilePath, String restoreMsgKey, String completionMsgKey, PropertyChangeListener pcl, boolean doSynchronously, boolean useGlassPane) {
        SimpleGlassPane glassPane = useGlassPane ? UIRegistry.writeSimpleGlassPaneMsg(UIRegistry.getLocalizedMessage(restoreMsgKey, databaseName), 24) : null;
        return this.doRestoreInBackground(databaseName, restoreFilePath, glassPane, completionMsgKey, pcl, doSynchronously);
    }

    protected boolean doRestoreInBackground(final String databaseName, final String restoreFilePath, final SimpleGlassPane glassPane, final String completionMsgKey, final PropertyChangeListener pcl, boolean doSynchronously) {
        AppPreferences remotePrefs = AppPreferences.getLocalPrefs();
        final String mysqlLoc = remotePrefs.get("mysql.location", MySQLBackupService.getDefaultMySQLLoc());
        this.getNumberofTables();
        SynchronousWorker backupWorker = new SynchronousWorker(){
            long dspMegs;
            long fileSize;
            {
                this.dspMegs = 0L;
                this.fileSize = 0L;
            }

            @Override
            protected Integer doInBackground() throws Exception {
                block13: {
                    FileInputStream input = null;
                    try {
                        OutputStream out;
                        Process process;
                        block12: {
                            String userName = MySQLBackupService.this.itUsername != null ? MySQLBackupService.this.itUsername : DBConnection.getInstance().getUserName();
                            String password = MySQLBackupService.this.itPassword != null ? MySQLBackupService.this.itPassword : DBConnection.getInstance().getPassword();
                            String port = DatabaseDriverInfo.getDriver(DBConnection.getInstance().getDriverName()).getPort();
                            String server = DBConnection.getInstance().getServerName();
                            String cmdLine = String.format("%s -u %s --password=%s --host=%s %s %s", mysqlLoc, userName, password, server, port != null ? "--port=" + port : "", databaseName);
                            String[] args = StringUtils.split((String)cmdLine, (char)' ');
                            process = Runtime.getRuntime().exec(args);
                            Thread.sleep(100L);
                            out = process.getOutputStream();
                            try {
                                File inFile = new File(restoreFilePath);
                                this.fileSize = inFile.length();
                                double oneMB = 1048576.0;
                                double threshold = (double)this.fileSize < oneMB * 4.0 ? 65536.0 : oneMB;
                                long totalBytes = 0L;
                                this.dspMegs = 0L;
                                input = new FileInputStream(inFile);
                                try {
                                    byte[] bytes = new byte[32768];
                                    while (true) {
                                        int numBytes = input.read(bytes, 0, bytes.length);
                                        totalBytes += (long)numBytes;
                                        if (numBytes > 0) {
                                            out.write(bytes, 0, numBytes);
                                            long megs = (long)((double)totalBytes / threshold);
                                            if (megs == this.dspMegs) continue;
                                            this.dspMegs = megs;
                                            this.firePropertyChange("MEGS", this.dspMegs, (int)(100.0 * (double)totalBytes / (double)this.fileSize));
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                finally {
                                    input.close();
                                }
                            }
                            catch (IOException ex) {
                                UsageTracker.incrHandledUsageCount();
                                ex.printStackTrace();
                                MySQLBackupService.this.errorMsg = ex.toString();
                                UIRegistry.showLocalizedError("MySQLBackupService.EXCP_RS");
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                if (pcl == null) break block12;
                                pcl.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Error", 0, 1));
                            }
                        }
                        this.setProgress(100);
                        out.flush();
                        out.close();
                        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                        }
                        in = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        line = null;
                        StringBuilder sb = new StringBuilder();
                        while ((line = in.readLine()) != null) {
                            if (!line.startsWith("ERR")) continue;
                            sb.append(line);
                            sb.append("\n");
                        }
                        MySQLBackupService.this.errorMsg = sb.toString();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        MySQLBackupService.this.errorMsg = ex.toString();
                        if (pcl == null) break block13;
                        pcl.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Error", 0, 1));
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                JStatusBar statusBar = UIRegistry.getStatusBar();
                if (statusBar != null) {
                    statusBar.setProgressDone("BackUp");
                }
                if (glassPane != null) {
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
                if (StringUtils.isNotEmpty((String)MySQLBackupService.this.errorMsg)) {
                    UIRegistry.showError(MySQLBackupService.this.errorMsg);
                }
                if (statusBar != null) {
                    statusBar.setText(UIRegistry.getLocalizedMessage(completionMsgKey, this.dspMegs));
                }
                if (pcl != null) {
                    pcl.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Done", 0, 1));
                }
            }
        };
        if (glassPane != null) {
            glassPane.setProgress(0);
        }
        backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MEGS".equals(evt.getPropertyName()) && glassPane != null) {
                    int value = (Integer)evt.getNewValue();
                    if (value < 100) {
                        glassPane.setProgress((Integer)evt.getNewValue());
                    } else {
                        glassPane.setProgress(100);
                    }
                }
            }
        });
        if (doSynchronously) {
            return backupWorker.doWork();
        }
        backupWorker.execute();
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean doRestore(String restoreFilePath, String mysqlLoc, String databaseName, String userName, String password) {
        FileInputStream input = null;
        try {
            String cmdLine = String.valueOf(mysqlLoc) + " -u " + userName + " --password=" + password + " " + databaseName;
            String[] args = StringUtils.split((String)cmdLine, (char)' ');
            Process process = Runtime.getRuntime().exec(args);
            OutputStream out = process.getOutputStream();
            try {
                try {
                    File inFile = new File(restoreFilePath);
                    input = new FileInputStream(inFile);
                    try {
                        long totalBytes = 0L;
                        byte[] bytes = new byte[32768];
                        while (true) {
                            int numBytes = input.read(bytes, 0, bytes.length);
                            totalBytes += (long)numBytes;
                            if (numBytes > 0) {
                                out.write(bytes, 0, numBytes);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.errorMsg = ex.toString();
                    out.flush();
                    out.close();
                    return false;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    out.flush();
                    out.close();
                    return false;
                }
            }
            finally {
                out.flush();
                out.close();
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
            }
            in = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("ERR")) continue;
                sb.append(line);
                sb.append("\n");
            }
            this.errorMsg = sb.toString();
            return this.errorMsg == null || this.errorMsg.isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMsg = ex.toString();
            return false;
        }
    }

    protected int indexOf(char ch, byte[] bytes, int startInx, int len) {
        int i = startInx;
        while (i < len) {
            if (bytes[i] == (byte)ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected long restoreFile(Connection connection, File inFile) throws Exception {
        long dspMegs = 0L;
        long fileSize = 0L;
        FileInputStream input = null;
        try {
            fileSize = inFile.length();
            double oneMB = 1048576.0;
            double threshold = (double)fileSize < oneMB * 4.0 ? 65536.0 : oneMB;
            long totalBytes = 0L;
            dspMegs = 0L;
            StringBuilder sb = new StringBuilder();
            int len = 0;
            input = new FileInputStream(inFile);
            try {
                byte[] bytes = new byte[65536];
                byte[] strBytes = new byte[65536];
                byte[] readBuf = new byte[16384];
                while (true) {
                    int numBytes = input.read(readBuf, 0, readBuf.length);
                    totalBytes += (long)numBytes;
                    if (numBytes > 0) {
                        System.arraycopy(readBuf, 0, bytes, len, numBytes);
                        int inx = this.indexOf(';', bytes, 0, len += numBytes);
                        while (inx > -1) {
                            String[] toks;
                            System.arraycopy(bytes, 0, strBytes, 0, inx + 1);
                            strBytes[inx] = 0;
                            String fullStr = new String(strBytes, 0, inx).trim();
                            String[] stringArray = toks = StringUtils.split((String)fullStr, (char)'\n');
                            int n = toks.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String str = stringArray[n2];
                                if (str.length() > 0 && !str.startsWith("--") && !str.startsWith("/*")) {
                                    sb.append(str);
                                }
                                ++n2;
                            }
                            if (sb.length() > 0) {
                                int rv = BasicSQLUtils.update(connection, sb.toString());
                                log.debug((Object)("rv: " + rv));
                                sb.setLength(0);
                            }
                            System.arraycopy(bytes, inx + 1, bytes, 0, len -= inx + 1);
                            inx = this.indexOf(';', bytes, 0, len);
                        }
                        long megs = (long)((double)totalBytes / threshold);
                        if (megs == dspMegs) continue;
                        dspMegs = megs;
                        continue;
                    }
                    break;
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            UsageTracker.incrHandledUsageCount();
            ex.printStackTrace();
            this.errorMsg = ex.toString();
            UIRegistry.showLocalizedError("MySQLBackupService.EXCP_RS");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fileSize;
    }

    @Override
    public boolean doRestoreBulkDataInBackground(final String databaseName, String options, final String restoreZipFilePath, final SimpleGlassPane glassPane, final String completionMsgKey, final PropertyChangeListener pcl, boolean doSynchronously, final boolean doDropDatabase) {
        this.getNumberofTables();
        SynchronousWorker backupWorker = new SynchronousWorker(){
            long dspMegs;
            {
                this.dspMegs = 0L;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            protected Integer doInBackground() throws Exception {
                block14: {
                    skipTrackExceptions = BasicSQLUtils.isSkipTrackExceptions();
                    BasicSQLUtils.setSkipTrackExceptions(false);
                    try {
                        userName = MySQLBackupService.this.itUsername != null ? MySQLBackupService.this.itUsername : DBConnection.getInstance().getUserName();
                        password = MySQLBackupService.this.itPassword != null ? MySQLBackupService.this.itPassword : DBConnection.getInstance().getPassword();
                        dbMgr = DBMSUserMgr.getInstance();
                        if (!dbMgr.connectToDBMS(userName, password, DBConnection.getInstance().getServerName())) break block14;
                        if (!doDropDatabase) ** GOTO lbl19
                        if (dbMgr.doesDBExists(databaseName) && !dbMgr.dropDatabase(databaseName)) {
                            MySQLBackupService.access$2().error((Object)("Database[" + databaseName + "] could not be dropped before load."));
                            UIRegistry.showLocalizedError("MySQLBackupService.ERR_DRP_DB", new Object[]{databaseName});
lbl12:
                            // 2 sources

                            return null;
                        }
                        try {
                            if (!dbMgr.createDatabase(databaseName)) {
                                MySQLBackupService.access$2().error((Object)("Database[" + databaseName + "] could not be created before load."));
                                UIRegistry.showLocalizedError("MySQLBackupService.CRE_DRP_DB", new Object[]{databaseName});
                                ** continue;
                            }
lbl19:
                            // 3 sources

                            driverInfo = DatabaseDriverInfo.getDriver(DBConnection.getInstance().getDriverName());
                            connStr = DBConnection.getInstance().getConnectionStr();
                            System.err.println(connStr);
                            itDBConn = DBConnection.createInstance(driverInfo.getDriverClassName(), driverInfo.getDialectClassName(), databaseName, connStr, userName, password);
                            connection = itDBConn.createConnection();
                            connection.setCatalog(databaseName);
                            unzippedFiles = ZipFileHelper.getInstance().unzipToFiles(new File(restoreZipFilePath));
                            dbCreated = false;
                            for (File file : unzippedFiles) {
                                if (!file.getName().equals("createdb.sql")) continue;
                                size = MySQLBackupService.this.restoreFile(connection, file);
                                MySQLBackupService.access$2().debug((Object)("size: " + size));
                                dbCreated = true;
                            }
                            if (dbCreated) {
                                for (File file : unzippedFiles) {
                                    if (!file.getName().endsWith("infile")) continue;
                                    fPath = file.getCanonicalPath();
                                    if (UIHelper.isWindows()) {
                                        fPath = StringUtils.replace((String)fPath, (String)"\\", (String)"\\\\");
                                    }
                                    sql = "LOAD DATA LOCAL INFILE '" + fPath + "' INTO TABLE " + FilenameUtils.getBaseName((String)file.getName());
                                    MySQLBackupService.access$2().debug((Object)sql);
                                    rv = BasicSQLUtils.update(connection, sql);
                                    MySQLBackupService.access$2().debug((Object)("done fPath[" + fPath + "] rv= " + rv));
                                }
                            }
                            ZipFileHelper.getInstance().cleanUp();
                            this.setProgress(100);
                            itDBConn.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            MySQLBackupService.access$0(MySQLBackupService.this, ex.toString());
                            if (pcl != null) {
                                pcl.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Error", 0, 1));
                            }
                        }
                    }
                    finally {
                        BasicSQLUtils.setSkipTrackExceptions(skipTrackExceptions);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                JStatusBar statusBar = UIRegistry.getStatusBar();
                if (statusBar != null) {
                    statusBar.setProgressDone("BackUp");
                }
                if (glassPane != null) {
                    UIRegistry.clearSimpleGlassPaneMsg();
                }
                if (StringUtils.isNotEmpty((String)MySQLBackupService.this.errorMsg)) {
                    UIRegistry.showError(MySQLBackupService.this.errorMsg);
                }
                if (statusBar != null) {
                    statusBar.setText(UIRegistry.getLocalizedMessage(completionMsgKey, this.dspMegs));
                }
                if (pcl != null) {
                    pcl.propertyChange(new PropertyChangeEvent(MySQLBackupService.this, "Done", 0, 1));
                }
            }
        };
        if (glassPane != null) {
            glassPane.setProgress(0);
        }
        backupWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MEGS".equals(evt.getPropertyName()) && glassPane != null) {
                    int value = (Integer)evt.getNewValue();
                    if (value < 100) {
                        glassPane.setProgress((Integer)evt.getNewValue());
                    } else {
                        glassPane.setProgress(100);
                    }
                }
            }
        });
        if (doSynchronously) {
            return backupWorker.doWork();
        }
        backupWorker.execute();
        return true;
    }

    @Override
    public boolean checkForBackUp(boolean doSendExit) {
        return this.checkForBackUp(doSendExit, false);
    }

    private boolean checkForBackUp(boolean doSendExit, boolean doSkipAsk) {
        Long timeMons;
        long oneDayMilliSecs = 86400000L;
        Calendar calNow = Calendar.getInstance();
        Date dateNow = calNow.getTime();
        Long timeDays = AppPreferences.getLocalPrefs().getLong("LAST.BACKUP.WEEKLY", null);
        if (timeDays == null) {
            timeDays = dateNow.getTime();
            AppPreferences.getLocalPrefs().putLong("LAST.BACKUP.WEEKLY", dateNow.getTime());
        }
        if ((timeMons = AppPreferences.getLocalPrefs().getLong("LAST.BACKUP.MONS", null)) == null) {
            timeMons = dateNow.getTime();
            AppPreferences.getLocalPrefs().putLong("LAST.BACKUP.MONS", dateNow.getTime());
        }
        Date lastBackUpDays = new Date(timeDays);
        Date lastBackUpMons = new Date(timeMons);
        int diffMons = (int)((dateNow.getTime() - lastBackUpMons.getTime()) / 86400000L);
        int diffDays = (int)((dateNow.getTime() - lastBackUpDays.getTime()) / 86400000L);
        int diff = 0;
        String key = null;
        boolean isMonthly = false;
        if (diffMons > 30) {
            key = "MySQLBackupService.MONTHLY";
            diff = diffMons;
            isMonthly = true;
        } else if (diffDays > 7) {
            key = "MySQLBackupService.WEEKLY";
            diff = diffDays;
        }
        int userChoice = 2;
        if (key != null && !doSkipAsk) {
            Object[] options = new Object[]{UIRegistry.getResourceString("MySQLBackupService.BACKUP_NOW"), UIRegistry.getResourceString("MySQLBackupService.BK_SKIP")};
            userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getLocalizedMessage(key, diff), UIRegistry.getResourceString("MySQLBackupService.BK_NOW_TITLE"), 0, 3, null, options, options[0]);
        }
        if (isMonthly) {
            AppPreferences.getLocalPrefs().putLong("LAST.BACKUP.MONS", dateNow.getTime());
            if (diffDays > 7) {
                AppPreferences.getLocalPrefs().putLong("LAST.BACKUP.WEEKLY", dateNow.getTime());
            }
        } else {
            AppPreferences.getLocalPrefs().putLong("LAST.BACKUP.WEEKLY", dateNow.getTime());
        }
        if (userChoice == 0 || doSkipAsk) {
            return this.doBackUp(isMonthly, doSendExit, null);
        }
        return false;
    }

    public static String getDefaultMySQLDumpLoc() {
        String mysqldumpLoc = "";
        switch (UIHelper.getOSType()) {
            case Windows: {
                mysqldumpLoc = MySQLBackupService.searchForWindowsPath(true);
                break;
            }
            case MacOSX: {
                mysqldumpLoc = "/usr/local/mysql/bin/mysqldump";
                break;
            }
            case Linux: {
                mysqldumpLoc = "/usr/bin/mysqldump";
                break;
            }
        }
        return mysqldumpLoc;
    }

    public static String getDefaultMySQLLoc() {
        String mysqlLoc = "";
        switch (UIHelper.getOSType()) {
            case Windows: {
                mysqlLoc = MySQLBackupService.searchForWindowsPath(false);
                break;
            }
            case MacOSX: {
                mysqlLoc = "/usr/local/mysql/bin/mysql";
                break;
            }
            case Linux: {
                mysqlLoc = "/usr/bin/mysql";
                break;
            }
        }
        return mysqlLoc;
    }

    private static String searchForWindowsPath(boolean doDump) {
        String exeName = doDump ? "mysqldump.exe" : "mysql.exe";
        try {
            String programFilesPath = String.valueOf(UIRegistry.getDefaultWorkingPath()) + File.separator + ".." + File.separator + "..";
            File dir = new File(programFilesPath);
            if (dir.exists() && dir.isDirectory()) {
                File mysqlDir = null;
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (StringUtils.contains((String)file.getName().toLowerCase(), (String)"mysql")) {
                        mysqlDir = file;
                        break;
                    }
                    ++n2;
                }
                if (mysqlDir != null) {
                    for (File file : FileUtils.listFiles(mysqlDir, (String[])new String[]{"exe"}, (boolean)true)) {
                        if (!file.getName().equalsIgnoreCase(exeName)) continue;
                        return file.getAbsolutePath();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getDefaultBackupLoc() {
        return String.valueOf(UIRegistry.getAppDataDir()) + File.separator + "backups";
    }

    static /* synthetic */ Logger access$2() {
        return log;
    }

    abstract class SynchronousWorker
    extends SwingWorker<Integer, Integer> {
        SynchronousWorker() {
        }

        public boolean doWork() {
            try {
                this.doInBackground();
                this.done();
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }
}

