/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBInfoVisibleIterator;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.IconManager;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DBTableInfo
extends DBInfoBase {
    protected static final Logger log = Logger.getLogger(DBTableInfo.class);
    protected int tableId;
    protected String className;
    protected String primaryKeyName;
    protected Class<?> classObj;
    protected boolean isSearchable = false;
    protected String businessRuleName;
    protected String abbrev;
    protected String idColumnName;
    protected String idFieldName;
    protected String idType;
    protected String defaultFormName;
    protected String uiFormatter;
    protected String dataObjFormatter;
    protected String searchDialog;
    protected String newObjDialog;
    protected String aggregatorName;
    protected List<DBRelationshipInfo> relationships;
    protected List<DBFieldInfo> fields;
    protected Hashtable<String, String> fieldAliases;
    protected Hashtable<String, DBFieldInfo> fieldsHash = null;
    protected Hashtable<String, DBRelationshipInfo> relsHash = null;
    protected HashMap<String, String> tblIndexHash = null;

    public DBTableInfo(int tableId, String className, String tableName, String primaryKeyName, String abbrev) {
        super(tableName);
        this.tableId = tableId;
        this.className = className;
        this.primaryKeyName = primaryKeyName;
        this.abbrev = abbrev;
        try {
            this.classObj = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DBTableInfo.class, e);
            log.error((Object)("Trying to find class: " + className + " but class was not found"));
        }
        this.relationships = new Vector<DBRelationshipInfo>();
        this.fields = new Vector<DBFieldInfo>();
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public void cleanUp() {
        this.relationships.clear();
        this.fields.clear();
    }

    public void addTableIndex(String indexName, String columnNames) {
        if (this.tblIndexHash == null) {
            this.tblIndexHash = new HashMap();
        }
        if (StringUtils.isNotEmpty((String)indexName) && StringUtils.isNotEmpty((String)columnNames)) {
            this.tblIndexHash.put(indexName, columnNames);
        }
    }

    public Map<String, String> getTableIndexMap() {
        return this.tblIndexHash;
    }

    public String getShortClassName() {
        return this.classObj.getSimpleName();
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public Class<?> getClassObj() {
        return this.classObj;
    }

    public String getDefaultFormName() {
        return this.defaultFormName;
    }

    public void setDefaultFormName(String defaultFormName) {
        this.defaultFormName = defaultFormName;
    }

    public List<DBRelationshipInfo> getRelationships() {
        return this.relationships;
    }

    public ImageIcon getIcon(IconManager.IconSize size) {
        return IconManager.getIcon(this.getShortClassName(), size);
    }

    public String getDataObjFormatter() {
        return this.dataObjFormatter;
    }

    public void setDataObjFormatter(String dataObjFormatter) {
        this.dataObjFormatter = dataObjFormatter;
    }

    public String getUiFormatter() {
        return this.uiFormatter;
    }

    public void setUiFormatter(String uiFormatter) {
        this.uiFormatter = uiFormatter;
    }

    public String getAggregatorName() {
        return this.aggregatorName;
    }

    public void setAggregatorName(String aggregatorName) {
        this.aggregatorName = aggregatorName;
    }

    public String getNewObjDialog() {
        return this.newObjDialog;
    }

    public void setNewObjDialog(String newObjDialog) {
        this.newObjDialog = newObjDialog;
    }

    public String getEditObjDialog() {
        return this.getNewObjDialog();
    }

    public void setEditObjDialog(String editObjDialog) {
        this.setNewObjDialog(editObjDialog);
    }

    public String getSearchDialog() {
        return this.searchDialog;
    }

    public void setSearchDialog(String searchDialog) {
        this.searchDialog = searchDialog;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public void setSearchable(boolean isSearchable) {
        this.isSearchable = isSearchable;
    }

    public String getBusinessRuleName() {
        return this.businessRuleName;
    }

    public void setBusinessRuleName(String businessRule) {
        this.businessRuleName = businessRule;
    }

    public BusinessRulesIFace getBusinessRule() {
        if (StringUtils.isNotEmpty((String)this.businessRuleName)) {
            try {
                Class<BusinessRulesIFace> clazz = Class.forName(this.businessRuleName);
                if (clazz.isAssignableFrom(BusinessRulesIFace.class)) {
                    return (BusinessRulesIFace)clazz.newInstance();
                }
                Object obj = clazz.newInstance();
                if (BusinessRulesIFace.class.isInstance(obj)) {
                    return (BusinessRulesIFace)obj;
                }
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBTableInfo.class, ex);
                log.error((Object)ex);
            }
        }
        return null;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public void addFieldAlias(String virtualName, String actualName) {
        if (this.fieldAliases == null) {
            this.fieldAliases = new Hashtable();
        }
        this.fieldAliases.put(virtualName, actualName);
    }

    public DBTableChildIFace getItemByName(String itemName) {
        DBFieldInfo fieldInfo = this.getFieldByName(itemName);
        if (fieldInfo != null) {
            return fieldInfo;
        }
        return this.getRelationshipByName(itemName);
    }

    public DBFieldInfo getFieldByName(String fieldName) {
        String actualName;
        DBFieldInfo fInfo;
        if (this.fieldsHash == null) {
            this.fieldsHash = new Hashtable();
            for (DBFieldInfo fldInfo : this.fields) {
                this.fieldsHash.put(fldInfo.getName().toLowerCase(), fldInfo);
            }
        }
        if ((fInfo = this.fieldsHash.get(fieldName.toLowerCase())) == null && this.fieldAliases != null && (actualName = this.fieldAliases.get(fieldName)) != null) {
            return this.fieldsHash.get(actualName.toLowerCase());
        }
        return fInfo;
    }

    public DBFieldInfo getFieldByColumnName(String columnName, boolean suppressError) {
        String fName = columnName.indexOf(46) > -1 ? StringUtils.substringAfterLast((String)columnName, (String)".") : columnName;
        String fieldName = String.valueOf(fName.substring(0, 1).toLowerCase()) + fName.substring(1, fName.length());
        DBFieldInfo fi = this.getFieldByName(fieldName);
        if (fi == null && !suppressError && !fieldName.endsWith("ID")) {
            log.error((Object)("Couldn't find FieldName[" + fieldName + "] in table [" + this.getTitle() + "]"));
        }
        return fi;
    }

    public DBFieldInfo getFieldByColumnName(String columnName) {
        return this.getFieldByColumnName(columnName, false);
    }

    public DBRelationshipInfo getRelationshipByName(String relName) {
        String actualName;
        DBRelationshipInfo rInfo;
        if (this.relsHash == null) {
            this.relsHash = new Hashtable();
            for (DBRelationshipInfo rel : this.relationships) {
                this.relsHash.put(rel.getName().toLowerCase(), rel);
            }
        }
        if ((rInfo = this.relsHash.get(relName.toLowerCase())) == null && this.fieldAliases != null && (actualName = this.fieldAliases.get(relName)) != null) {
            return this.relsHash.get(actualName.toLowerCase());
        }
        return rInfo;
    }

    public DBInfoVisibleIterator<DBRelationshipInfo> getVisableRelationships() {
        return new DBInfoVisibleIterator<DBRelationshipInfo>(this.relationships);
    }

    public DBInfoVisibleIterator<DBFieldInfo> getVisableFields() {
        return new DBInfoVisibleIterator<DBFieldInfo>(this.fields);
    }

    public DBRelationshipInfo.RelationshipType getRelType(String fieldName) {
        for (DBRelationshipInfo tblRel : this.relationships) {
            if (!tblRel.getName().equals(fieldName)) continue;
            return tblRel.getType();
        }
        return null;
    }

    public void addField(DBFieldInfo fieldInfo) {
        this.fields.add(fieldInfo);
    }

    public List<DBFieldInfo> getFields() {
        return this.fields;
    }

    @Override
    protected String getSecurityName() {
        return this.getShortClassName();
    }
}

