/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBFieldInfo;
import edu.ku.brc.af.core.db.DBInfoVisibleIterator;
import edu.ku.brc.af.core.db.DBRelationshipInfo;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.core.expresssearch.QueryAdjusterForDomain;
import edu.ku.brc.af.ui.forms.BusinessRulesIFace;
import edu.ku.brc.af.ui.forms.GenericBusRules;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.DatamodelHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DBTableIdMgr {
    public static final String factoryName = "edu.ku.brc.dbsupport.DBTableIdMgr";
    protected static final Logger log = Logger.getLogger(DBTableIdMgr.class);
    protected static DBTableIdMgr instance = null;
    protected Hashtable<Integer, DBTableInfo> hash = new Hashtable();
    protected Hashtable<String, DBTableInfo> byClassNameHash = new Hashtable();
    protected Hashtable<String, DBTableInfo> byShortClassNameHash = new Hashtable();
    protected Vector<DBTableInfo> tables = new Vector();
    protected boolean isFullSchema = true;

    public DBTableIdMgr(boolean isFullSchema) {
        this.isFullSchema = isFullSchema;
    }

    public static DBTableIdMgr getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(DBTableIdMgr.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (DBTableIdMgr)Class.forName(factoryNameStr).newInstance();
                instance.initialize();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBTableIdMgr.class, e);
                InternalError error = new InternalError("Can't instantiate WebLink factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        instance = new DBTableIdMgr(true);
        instance.initialize();
        return instance;
    }

    public void initialize() {
        this.initialize(DatamodelHelper.getDatamodelFilePath());
    }

    public void initialize(File inputFile) {
        log.debug((Object)("Reading in datamodel file: " + inputFile.getAbsolutePath() + " to create and populate DBTableMgr"));
        String classname = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setValidation(false);
            Element databaseNode = XMLHelper.readFileToDOM4J(inputFile);
            if (databaseNode != null) {
                Iterator i = databaseNode.elementIterator("table");
                while (i.hasNext()) {
                    Element irNode;
                    Element tableNode = (Element)i.next();
                    classname = tableNode.attributeValue("classname");
                    String tablename = tableNode.attributeValue("table");
                    int tableId = Integer.parseInt(tableNode.attributeValue("tableid"));
                    boolean isSearchable = XMLHelper.getAttr(tableNode, "searchable", false);
                    String primaryKeyField = null;
                    Iterator i2 = tableNode.elementIterator("id");
                    while (i2.hasNext()) {
                        Element idNode = (Element)i2.next();
                        primaryKeyField = idNode.attributeValue("name");
                    }
                    if (classname == null) {
                        log.error((Object)"classname is null; check input file");
                    }
                    if (tablename == null) {
                        log.error((Object)"tablename is null; check input file");
                    }
                    if (this.isFullSchema && primaryKeyField == null) {
                        log.error((Object)("primaryKeyField is null; check input file table[" + tablename + "]"));
                    }
                    DBTableInfo tblInfo = new DBTableInfo(tableId, classname, tablename, primaryKeyField, tableNode.attributeValue("abbrv"));
                    tblInfo.setSearchable(isSearchable);
                    tblInfo.setBusinessRuleName(XMLHelper.getAttr(tableNode, "businessrule", null));
                    if (this.hash.get(tableId) != null) {
                        log.error((Object)("Table ID used twice[" + tableId + "]"));
                    }
                    this.hash.put(tableId, tblInfo);
                    this.byClassNameHash.put(classname.toLowerCase(), tblInfo);
                    this.byShortClassNameHash.put(tblInfo.getShortClassName().toLowerCase(), tblInfo);
                    this.tables.add(tblInfo);
                    Element idElement = (Element)tableNode.selectSingleNode("id");
                    if (idElement != null) {
                        tblInfo.setIdColumnName(XMLHelper.getAttr(idElement, "column", null));
                        tblInfo.setIdFieldName(XMLHelper.getAttr(idElement, "name", null));
                        tblInfo.setIdType(XMLHelper.getAttr(idElement, "type", null));
                    }
                    Iterator ir = tableNode.elementIterator("tableindex");
                    while (ir.hasNext()) {
                        Element irNode2 = (Element)ir.next();
                        String inxName = XMLHelper.getAttr(irNode2, "indexName", null);
                        String inxColNames = XMLHelper.getAttr(irNode2, "columnNames", null);
                        tblInfo.addTableIndex(inxName, inxColNames);
                    }
                    Element displayElement = (Element)tableNode.selectSingleNode("display");
                    if (displayElement != null) {
                        tblInfo.setDefaultFormName(XMLHelper.getAttr(displayElement, "view", null));
                        tblInfo.setUiFormatter(XMLHelper.getAttr(displayElement, "uiformatter", null));
                        tblInfo.setDataObjFormatter(XMLHelper.getAttr(displayElement, "dataobjformatter", null));
                        tblInfo.setSearchDialog(XMLHelper.getAttr(displayElement, "searchdlg", null));
                        tblInfo.setNewObjDialog(XMLHelper.getAttr(displayElement, "newobjdlg", null));
                    } else {
                        tblInfo.setDefaultFormName("");
                        tblInfo.setUiFormatter("");
                        tblInfo.setDataObjFormatter("");
                        tblInfo.setSearchDialog("");
                        tblInfo.setNewObjDialog("");
                    }
                    Iterator ir2 = tableNode.elementIterator("relationship");
                    while (ir2.hasNext()) {
                        irNode = (Element)ir2.next();
                        DBRelationshipInfo tblRel = new DBRelationshipInfo(irNode.attributeValue("relationshipname"), DBTableIdMgr.getRelationshipType(irNode.attributeValue("type")), irNode.attributeValue("classname"), irNode.attributeValue("columnname"), irNode.attributeValue("othersidename"), irNode.attributeValue("jointable"), XMLHelper.getAttr(irNode, "required", false), XMLHelper.getAttr(irNode, "updatable", false), XMLHelper.getAttr(irNode, "save", false), XMLHelper.getAttr(irNode, "likemanytoone", false));
                        tblInfo.getRelationships().add(tblRel);
                    }
                    ir2 = tableNode.elementIterator("field");
                    while (ir2.hasNext()) {
                        irNode = (Element)ir2.next();
                        int len = -1;
                        String lenStr = irNode.attributeValue("length");
                        if (StringUtils.isNotEmpty((String)lenStr) && StringUtils.isNumeric((String)lenStr)) {
                            len = Integer.parseInt(lenStr);
                            if (!UIRegistry.isMobile() && len > 256) {
                                len = Short.MAX_VALUE;
                            }
                        }
                        DBFieldInfo fieldInfo = new DBFieldInfo(tblInfo, irNode.attributeValue("column"), irNode.attributeValue("name"), irNode.attributeValue("type"), len, XMLHelper.getAttr(irNode, "required", false), XMLHelper.getAttr(irNode, "updatable", false), XMLHelper.getAttr(irNode, "unique", false), XMLHelper.getAttr(irNode, "indexed", false), XMLHelper.getAttr(irNode, "partialDate", false), XMLHelper.getAttr(irNode, "datePrecisionName", null));
                        fieldInfo.setRequiredInSchema(fieldInfo.isRequired());
                        tblInfo.addField(fieldInfo);
                    }
                    Iterator faIter = tableNode.elementIterator("fieldalias");
                    while (faIter.hasNext()) {
                        Element faNode = (Element)faIter.next();
                        String vName = XMLHelper.getAttr(faNode, "vname", null);
                        String aName = XMLHelper.getAttr(faNode, "aname", null);
                        if (vName == null || aName == null) continue;
                        tblInfo.addFieldAlias(vName, aName);
                    }
                }
            } else {
                log.error((Object)"Reading in datamodel file.  SAX parser got null for the root of the document.");
            }
        }
        catch (NumberFormatException numEx) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DBTableIdMgr.class, numEx);
            log.error((Object)("Specify datamodel input file: " + inputFile.getAbsolutePath() + " failed to provide valid table id for class/table:" + classname));
            log.error((Object)numEx);
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DBTableIdMgr.class, ex);
            log.error((Object)ex);
            ex.printStackTrace();
        }
        Collections.sort(this.tables);
        log.debug((Object)("Done Reading in datamodel file: " + inputFile.getAbsolutePath()));
    }

    public void clearPermissions() {
        for (DBTableInfo ti : this.hash.values()) {
            ti.setPermissions(null);
        }
    }

    public void cleanUp() {
        for (DBTableInfo ti : this.hash.values()) {
            ti.cleanUp();
        }
        this.hash.clear();
        this.byClassNameHash.clear();
        this.byShortClassNameHash.clear();
    }

    public String getTitleForId(int tableId) {
        DBTableInfo ti = this.getInfoById(tableId);
        if (ti != null) {
            return ti.getTitle();
        }
        return "";
    }

    public String getTitleForField(int tableId, String fieldName) {
        DBFieldInfo fi;
        DBTableInfo ti = this.getInfoById(tableId);
        if (ti != null && (fi = ti.getFieldByName(fieldName)) != null) {
            return fi.getTitle();
        }
        return "";
    }

    public Vector<DBTableInfo> getTables() {
        return this.tables;
    }

    public String getDefaultFormNameById(int id) {
        DBTableInfo tableInfo = this.hash.get(id);
        if (tableInfo != null) {
            String defaultFormName = tableInfo.getDefaultFormName();
            if (StringUtils.isEmpty((String)defaultFormName)) {
                return tableInfo.getClassObj().getSimpleName();
            }
            return defaultFormName;
        }
        return null;
    }

    public int getIdByShortName(String name) {
        for (DBTableInfo tableInfo : this.hash.values()) {
            String tableName = tableInfo.getName();
            int inx = tableName.lastIndexOf(46);
            String string = tableName = inx > -1 ? tableName.substring(inx + 1) : tableName;
            if (!tableName.equalsIgnoreCase(name)) continue;
            return tableInfo.getTableId();
        }
        throw new RuntimeException("Couldn't find table id for table name[" + name + "]");
    }

    public int getIdByClassName(String className) {
        DBTableInfo tableInfo = this.getByClassName(className);
        if (tableInfo != null) {
            return tableInfo.getTableId();
        }
        log.error((Object)("Couldn't find table id for table name[" + className + "]"));
        return -1;
    }

    public DBTableInfo getByClassName(String className) {
        if (className != null) {
            return this.byClassNameHash.get(className.toLowerCase());
        }
        log.error((Object)("Couldn't find table id for table name[" + className + "]"));
        return null;
    }

    public DBTableInfo getByShortClassName(String shortClassName) {
        if (shortClassName != null) {
            return this.byShortClassNameHash.get(shortClassName.toLowerCase());
        }
        log.error((Object)("Couldn't find table id for table name[" + shortClassName + "]"));
        return null;
    }

    public Vector<DBTableInfo> getTablesForUserDisplay() {
        Vector<DBTableInfo> list = new Vector<DBTableInfo>();
        for (DBTableInfo ti : this.tables) {
            String tblName = ti.getName();
            if (tblName.startsWith("sp") || tblName.startsWith("attachment") || tblName.startsWith("autonum") || tblName.equals("picklist") || tblName.equals("attributedef") || tblName.equals("recordset") || tblName.equals("inforequest") || tblName.startsWith("workbench") || tblName.endsWith("treedef") || tblName.endsWith("treedefitem") || tblName.endsWith("attachment") || tblName.endsWith("attr") || tblName.endsWith("reltype")) continue;
            list.add(ti);
        }
        return list;
    }

    public DBTableInfo getInfoById(String tableId) {
        return this.getInfoById(Integer.parseInt(tableId));
    }

    public DBTableInfo getInfoById(int tableId) {
        if (this.hash.get(tableId) == null) {
            log.error((Object)("Couldn't find tableId[" + tableId + "]"));
        }
        return this.hash.get(tableId);
    }

    public DBTableInfo getInfoByTableName(String tableName) {
        for (DBTableInfo tblInfo : this.hash.values()) {
            if (!tblInfo.getName().equals(tableName)) continue;
            return tblInfo;
        }
        return null;
    }

    public String getQueryForTable(RecordSetIFace recordSet) {
        DBTableInfo tableInfo = this.hash.get(recordSet.getDbTableId());
        if (tableInfo != null) {
            String joins = QueryAdjusterForDomain.getInstance().getJoinClause(tableInfo, true, null, false);
            String specCols = QueryAdjusterForDomain.getInstance().getSpecialColumns(tableInfo, true);
            StringBuffer strBuf = new StringBuffer("from ");
            strBuf.append(tableInfo.getName());
            strBuf.append(" IN CLASS ");
            strBuf.append(tableInfo.getShortClassName());
            if (joins != null) {
                strBuf.append(joins);
            }
            strBuf.append(" WHERE ");
            strBuf.append(tableInfo.getName());
            strBuf.append('.');
            strBuf.append(tableInfo.getPrimaryKeyName());
            strBuf.append(this.getInClause(recordSet));
            if (specCols != null) {
                strBuf.append(" AND ");
                strBuf.append(specCols);
            }
            log.debug((Object)strBuf.toString());
            return strBuf.toString();
        }
        return null;
    }

    public String getQueryForTable(int tableId, long recordId) {
        DBTableInfo tableInfo = this.hash.get(tableId);
        if (tableInfo != null) {
            StringBuffer strBuf = new StringBuffer("from ");
            strBuf.append(tableInfo.getName());
            strBuf.append(" in class ");
            strBuf.append(tableInfo.getShortClassName());
            strBuf.append(" where ");
            strBuf.append(tableInfo.getName());
            strBuf.append('.');
            strBuf.append(tableInfo.getPrimaryKeyName());
            strBuf.append(" = " + recordId);
            log.debug((Object)strBuf.toString());
            return strBuf.toString();
        }
        return null;
    }

    public String getInClause(RecordSetIFace recordSet) {
        if (recordSet != null) {
            StringBuffer strBuf = new StringBuffer(" in (");
            List<RecordSetItemIFace> items = recordSet.getOrderedItems();
            if (items == null) {
                throw new RuntimeException("RecordSet items is null!");
            }
            int i = 0;
            for (RecordSetItemIFace rsi : items) {
                if (i > 0) {
                    strBuf.append(",");
                }
                strBuf.append(rsi.getRecordId());
                ++i;
            }
            strBuf.append(")");
            return strBuf.toString();
        }
        return "";
    }

    public static DBRelationshipInfo.RelationshipType getRelationshipType(String relTypeStr) {
        if (relTypeStr.equals("one-to-many")) {
            return DBRelationshipInfo.RelationshipType.OneToMany;
        }
        if (relTypeStr.equals("many-to-one")) {
            return DBRelationshipInfo.RelationshipType.ManyToOne;
        }
        if (relTypeStr.equals("many-to-many")) {
            return DBRelationshipInfo.RelationshipType.ManyToMany;
        }
        if (relTypeStr.equals("one-to-one")) {
            return DBRelationshipInfo.RelationshipType.OneToOne;
        }
        if (relTypeStr.equals("zero-to-one")) {
            return DBRelationshipInfo.RelationshipType.ZeroOrOne;
        }
        return null;
    }

    public BusinessRulesIFace getBusinessRule(Object data) {
        if (data != null) {
            return this.getBusinessRule(data.getClass());
        }
        return null;
    }

    public BusinessRulesIFace getBusinessRule(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            try {
                return this.getBusinessRule(Class.forName(className));
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBTableIdMgr.class, ex);
            }
        } else {
            log.warn((Object)"Class Name was empty.");
        }
        return null;
    }

    public BusinessRulesIFace getBusinessRule(Class<?> classOfObj) {
        String br;
        DBTableInfo ti = this.getByClassName(classOfObj.getName());
        if (ti != null && StringUtils.isNotEmpty((String)(br = ti.getBusinessRuleName()))) {
            try {
                return (BusinessRulesIFace)Class.forName(br).newInstance();
            }
            catch (Exception ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(DBTableIdMgr.class, ex);
                log.error((Object)("Bad Business Rule class name[" + br + "]"));
                log.error((Object)ex);
            }
        }
        return new GenericBusRules();
    }

    public DBInfoVisibleIterator<DBTableInfo> getVisableTabless() {
        return new DBInfoVisibleIterator<DBTableInfo>(this.tables);
    }

    public static UIFieldFormatterIFace getFieldFormatterFor(Class<?> tableClass, String fieldName) {
        DBFieldInfo fi;
        DBTableInfo ti = DBTableIdMgr.getInstance().getByShortClassName(tableClass.getSimpleName());
        if (ti != null && (fi = ti.getFieldByName(fieldName)) != null) {
            return fi.getFormatter();
        }
        return null;
    }

    public List<String> getTreeFieldNames(DBTableInfo tableInfo) {
        return null;
    }

    public void dumpTablesAsCSV() {
        boolean checkMM = true;
        try {
            PrintWriter pw = new PrintWriter("TablesAndField.csv");
            for (DBTableInfo ti : this.getTables()) {
                pw.write("\"" + ti.getName() + "\",,\"" + ti.getTitle() + "\",\"" + ti.getDescription() + "\"," + (checkMM ? "Mismatch" : "") + "\n");
                for (DBFieldInfo fi : ti.getFields()) {
                    pw.write(",\"" + fi.getName() + "\",\"" + fi.getTitle() + "\",\"" + (StringUtils.isNotEmpty((String)fi.getDescription()) ? fi.getDescription() : "") + "\",\"" + fi.getType() + "\"");
                    if (checkMM) {
                        if (fi.getColumn().startsWith("Number")) {
                            if (!(StringUtils.contains((String)fi.getType(), (String)"Byte") || StringUtils.contains((String)fi.getType(), (String)"Short") || StringUtils.contains((String)fi.getType(), (String)"Integer") || StringUtils.contains((String)fi.getType(), (String)"Long") || StringUtils.contains((String)fi.getType(), (String)"Float") || StringUtils.contains((String)fi.getType(), (String)"Double"))) {
                                pw.write(",*");
                            }
                        } else if (fi.getColumn().startsWith("Text")) {
                            if (!StringUtils.contains((String)fi.getType(), (String)"String")) {
                                pw.write(",*");
                            }
                        } else if (fi.getColumn().startsWith("Yes")) {
                            if (!StringUtils.contains((String)fi.getType(), (String)"Boolean")) {
                                pw.write(",*");
                            }
                        } else if (fi.getColumn().startsWith("Remark") && !StringUtils.contains((String)fi.getType(), (String)"text")) {
                            pw.write(",*");
                        }
                    }
                    pw.write("\n");
                }
                for (DBRelationshipInfo ri : ti.getRelationships()) {
                    pw.write(",\"" + ri.getName() + "\",\"" + ri.getTitle() + "\",\"" + (StringUtils.isNotEmpty((String)ri.getDescription()) ? ri.getDescription() : "") + "\",\"" + (Object)((Object)ri.getType()) + "\"\n");
                }
            }
            pw.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

