/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import org.apache.log4j.Logger;

public class DBRelationshipInfo
extends DBInfoBase
implements DBTableChildIFace {
    protected static final Logger log = Logger.getLogger(DBRelationshipInfo.class);
    protected RelationshipType type;
    protected String className;
    protected String colName;
    protected String otherSide;
    protected String joinTable;
    protected boolean isRequired;
    protected boolean isUpdatable;
    protected boolean isSavable;
    protected boolean isLikeManyToOne;
    protected Class<?> dataClass = null;

    public DBRelationshipInfo(String name, RelationshipType type, String className, String colName, String otherSide, String joinTable, boolean isRequired, boolean isUpdatable, boolean isSavable, boolean isLikeManyToOne) {
        super(name);
        this.type = type;
        this.className = className;
        this.colName = colName;
        this.otherSide = otherSide;
        this.isRequired = isRequired;
        this.isUpdatable = isUpdatable;
        this.joinTable = joinTable;
        this.isSavable = isSavable;
        this.isLikeManyToOne = isLikeManyToOne;
        try {
            this.dataClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(DBRelationshipInfo.class, ex);
            log.error((Object)ex);
        }
    }

    public void setType(RelationshipType type) {
        this.type = type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getColName() {
        return this.colName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public String getOtherSide() {
        return this.otherSide;
    }

    public String getJoinTable() {
        return this.joinTable;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isSavable() {
        return this.isSavable;
    }

    public boolean isLikeManyToOne() {
        return this.isLikeManyToOne;
    }

    @Override
    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public static enum RelationshipType {
        OneToOne,
        OneToMany,
        ManyToOne,
        ManyToMany,
        ZeroOrOne;

    }
}

