/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.auth.PermissionSettings;
import edu.ku.brc.af.auth.SecurityMgr;
import org.apache.commons.lang.StringUtils;

public class DBInfoBase
implements Comparable<DBInfoBase> {
    protected String name;
    protected String title;
    protected String description;
    protected boolean isHidden = false;
    protected PermissionSettings permissions = null;

    public DBInfoBase() {
        this(null, null, null);
    }

    public DBInfoBase(String name) {
        this(name, null, null);
    }

    protected DBInfoBase(String name, String title, String description) {
        this.name = name;
        this.title = title;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        if (StringUtils.isNotEmpty((String)this.title)) {
            return this.title;
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public int compareTo(DBInfoBase o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    protected String getSecurityName() {
        throw new RuntimeException("Must be implemented.");
    }

    public PermissionSettings getPermissions() {
        if (this.permissions == null) {
            this.permissions = SecurityMgr.getInstance().getPermission("DO." + this.getSecurityName());
        }
        return this.permissions;
    }

    public void setPermissions(PermissionSettings permissions) {
        this.permissions = permissions;
    }
}

