/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBInfoBase;
import edu.ku.brc.af.core.db.DBTableChildIFace;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DBFieldInfo
extends DBInfoBase
implements DBTableChildIFace {
    protected static final Logger log = Logger.getLogger(DBFieldInfo.class);
    protected DBTableInfo tableInfo;
    protected String column;
    protected String type;
    protected int length;
    protected boolean isRequired;
    protected boolean isRequiredInSchema;
    protected boolean isUpdatable;
    protected boolean isUnique;
    protected boolean isIndexed;
    protected boolean isPartialDate;
    protected String datePrecisionName;
    protected String pickListName = null;
    protected UIFieldFormatterIFace formatter = null;
    protected String formatStr = null;
    protected Class<?> dataClass = null;
    protected String webLinkName = null;

    public DBFieldInfo(DBTableInfo tableInfo, String column, Class<?> cls) {
        this(tableInfo, column, null, null, 0, false, false, false, false, false, null);
        this.dataClass = cls;
    }

    public DBFieldInfo(DBTableInfo tableInfo, String column, String name, String type, int length, boolean isRequired, boolean isUpdatable, boolean isUnique, boolean isIndexed, boolean isPartialDate, String datePrecisionName) {
        super(name);
        this.tableInfo = tableInfo;
        this.column = column;
        this.type = type;
        this.length = length;
        this.isRequired = isRequired;
        this.isUpdatable = isUpdatable;
        this.isUnique = isUnique;
        this.isIndexed = isIndexed;
        this.isPartialDate = isPartialDate;
        this.datePrecisionName = datePrecisionName;
    }

    public String getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.length;
    }

    public DBTableInfo getTableInfo() {
        return this.tableInfo;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return StringUtils.isNotEmpty((String)this.title) ? this.title : this.column;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public UIFieldFormatterIFace getFormatter() {
        return this.formatter;
    }

    public void setFormatter(UIFieldFormatterIFace formatter) {
        this.formatter = formatter;
    }

    public String getFormatStr() {
        return this.formatStr;
    }

    public void setFormatStr(String formatStr) {
        this.formatStr = formatStr;
    }

    public String getPickListName() {
        return this.pickListName;
    }

    public void setPickListName(String pickListName) {
        this.pickListName = pickListName;
    }

    public String getWebLinkName() {
        return this.webLinkName;
    }

    public void setWebLinkName(String webLinkName) {
        this.webLinkName = webLinkName;
    }

    public boolean isRequiredInSchema() {
        return this.isRequiredInSchema;
    }

    public void setRequiredInSchema(boolean isRequiredInSchema) {
        this.isRequiredInSchema = isRequiredInSchema;
    }

    public boolean isPartialDate() {
        return this.isPartialDate;
    }

    public String getDatePrecisionName() {
        return this.datePrecisionName;
    }

    @Override
    public Class<?> getDataClass() {
        if (this.dataClass == null && StringUtils.isNotEmpty((String)this.type)) {
            if (this.type.equals("calendar_date")) {
                this.dataClass = Calendar.class;
            } else if (this.type.equals("text")) {
                this.dataClass = String.class;
            } else if (this.type.equals("boolean")) {
                this.dataClass = Boolean.class;
            } else if (this.type.equals("byte")) {
                this.dataClass = Byte.class;
            } else {
                try {
                    this.dataClass = Class.forName(this.type);
                }
                catch (Exception e) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(DBFieldInfo.class, e);
                    log.error((Object)e);
                }
            }
        }
        return this.dataClass;
    }
}

