/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.specify.conversion.BasicSQLUtils;
import edu.ku.brc.ui.dnd.SimpleGlassPane;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public abstract class BackupServiceFactory {
    public static final String factoryName = "edu.ku.brc.af.core.db.BackupServiceFactory";
    protected static BackupServiceFactory instance = null;
    protected String itUsername = null;
    protected String itPassword = null;

    protected BackupServiceFactory() {
    }

    public static BackupServiceFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(BackupServiceFactory.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (BackupServiceFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BackupServiceFactory.class, e);
                InternalError error = new InternalError("Can't instantiate RecordSet factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }

    public abstract int getNumberofTables();

    public abstract void doBackUp();

    public abstract void doBackUp(PropertyChangeListener var1);

    public abstract void doRestore();

    public abstract boolean doRestoreBulkDataInBackground(String var1, String var2, String var3, SimpleGlassPane var4, String var5, PropertyChangeListener var6, boolean var7, boolean var8);

    public void setUsernamePassword(String itUsr, String itPwd) {
        this.itUsername = itUsr;
        this.itPassword = itPwd;
    }

    public abstract boolean doRestoreInBackground(String var1, String var2, String var3, String var4, PropertyChangeListener var5, boolean var6, boolean var7);

    public abstract boolean checkForBackUp(boolean var1);

    public abstract Vector<String> getTableNames();

    protected String getStatsName(String restoreName) {
        String baseFileName = FilenameUtils.getBaseName((String)restoreName);
        String path = FilenameUtils.getFullPath((String)restoreName);
        return FilenameUtils.concat((String)path, (String)(String.valueOf(baseFileName) + ".stats"));
    }

    public Vector<Object[]> doCompare(Vector<String> tableNames, String restoreFilePath) {
        String xmlName = this.getStatsName(restoreFilePath);
        File xmlFile = new File(xmlName);
        Properties oldStats = new Properties();
        if (xmlFile.exists()) {
            oldStats = this.readStats(xmlName);
        }
        Properties newStats = this.getCollectionStats(tableNames);
        if (oldStats != null && oldStats.size() > 0 && newStats != null && newStats.size() > 0) {
            return this.compareStats(tableNames, oldStats, newStats);
        }
        return null;
    }

    protected Properties getCollectionStats(Vector<String> tableNames) {
        Properties stats = new Properties();
        Iterator<String> iterator = tableNames.iterator();
        while (iterator.hasNext()) {
            String tableName;
            Integer count = BasicSQLUtils.getCount("SELECT COUNT(*) FROM " + (tableName = iterator.next()));
            stats.put(tableName, count != null ? Integer.toString(count) : Integer.valueOf(0));
        }
        return stats;
    }

    protected Properties readStats(String fullName) {
        if (StringUtils.isNotEmpty((String)fullName)) {
            Properties properties = new Properties();
            if (new File(fullName).exists()) {
                try {
                    properties.load(new FileInputStream(fullName));
                    return properties;
                }
                catch (IOException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(BackupServiceFactory.class, ex);
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    protected boolean writeStats(Properties stats, String fullName) {
        if (StringUtils.isNotEmpty((String)fullName)) {
            try {
                stats.store(new FileOutputStream(fullName), "DB TableStatistics");
                return true;
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(BackupServiceFactory.class, ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    protected Vector<Object[]> compareStats(Vector<String> tablesNames, Properties oldStats, Properties newStats) {
        Vector<Object[]> compareStatsList = new Vector<Object[]>();
        for (String tableName : tablesNames) {
            String newCountStr = newStats.getProperty(tableName);
            String oldCountStr = oldStats.getProperty(tableName);
            if (newCountStr == null || oldCountStr == null) continue;
            int oldCnt = Integer.parseInt(oldCountStr);
            int newCnt = Integer.parseInt(newCountStr);
            int diff = newCnt - oldCnt;
            if (diff <= 0) continue;
            DBTableInfo ti = DBTableIdMgr.getInstance().getInfoByTableName(tableName);
            Object[] row = new Object[]{ti != null ? ti.getTitle() : tableName, oldCnt, newCnt, diff};
            compareStatsList.add(row);
        }
        return compareStatsList;
    }
}

