/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core.db;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.AutoNumberIFace;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterField;
import edu.ku.brc.af.ui.forms.formatters.UIFieldFormatterIFace;
import edu.ku.brc.dbsupport.HibernateUtil;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class AutoNumberGeneric
implements AutoNumberIFace {
    protected Class<?> classObj = null;
    protected String fieldName = null;
    protected DataGetterForObj getter = new DataGetterForObj();
    protected boolean isGeneric = true;
    protected String errorMsg = null;

    public AutoNumberGeneric() {
    }

    public AutoNumberGeneric(Properties properties) {
        this.setProperties(properties);
    }

    public AutoNumberGeneric(String className, String fieldName, boolean isGeneric) {
        DBTableInfo tblInfo = DBTableIdMgr.getInstance().getByClassName(className);
        if (tblInfo == null) {
            throw new RuntimeException("Class property [" + className + "] was not found.");
        }
        this.classObj = tblInfo.getClassObj();
        this.fieldName = fieldName;
        this.isGeneric = isGeneric;
    }

    @Override
    public void setProperties(Properties properties) {
        DBTableInfo tblInfo;
        String className = properties.getProperty("class");
        if (StringUtils.isNotEmpty((String)className)) {
            this.isGeneric = StringUtils.contains((String)className, (String)"Generic");
            tblInfo = DBTableIdMgr.getInstance().getByClassName(className);
            if (tblInfo == null) {
                throw new RuntimeException("Class property [" + className + "] was not found.");
            }
        } else {
            throw new RuntimeException("Class property was null/empty.");
        }
        this.classObj = tblInfo.getClassObj();
        this.fieldName = properties.getProperty("field");
    }

    protected String getHighestObject(UIFieldFormatterIFace formatter, Session session, String value, Pair<Integer, Integer> yearPos, Pair<Integer, Integer> pos) throws Exception {
        if (value == null || pos == null) {
            this.errorMsg = UIRegistry.getLocalizedMessage("AUTONUM_INC_ERR", value != null ? value : "null", pos != null ? pos : "null");
            return null;
        }
        int yearLen = 0;
        int posLen = 0;
        Integer yearVal = null;
        if (yearPos != null && StringUtils.isNotEmpty((String)value) && value.length() >= (Integer)yearPos.second) {
            yearVal = this.extractIntegerValue(yearPos, value);
            yearLen = (Integer)yearPos.second - (Integer)yearPos.first;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(this.fieldName);
        sb.append(" FROM ");
        sb.append(this.classObj.getSimpleName());
        if (yearVal != null && yearPos != null) {
            sb.append(" WHERE '");
            sb.append(yearVal);
            sb.append("' = substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearLen + ")");
        }
        sb.append(" ORDER BY");
        try {
            List list;
            if (yearPos != null) {
                sb.append(" substring(" + this.fieldName + "," + ((Integer)yearPos.first + 1) + "," + yearLen + ") desc");
            }
            if (pos != null) {
                posLen = (Integer)pos.second - (Integer)pos.first;
                if (yearPos != null) {
                    sb.append(", ");
                }
                sb.append(" substring(" + this.fieldName + "," + ((Integer)pos.first + 1) + "," + posLen + ") desc");
            }
            if ((list = session.createQuery(sb.toString()).setMaxResults(1).list()).size() == 1) {
                return list.get(0).toString();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(AutoNumberGeneric.class, ex);
            this.errorMsg = ex.toString();
        }
        return null;
    }

    protected Integer extractIntegerValue(Pair<Integer, Integer> pos, String value) {
        String str;
        if (StringUtils.isNotEmpty((String)value) && pos != null && value.length() >= (Integer)pos.second && StringUtils.isNumeric((String)(str = value.substring((Integer)pos.first, (Integer)pos.second)))) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception ex) {
                this.errorMsg = ex.toString();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AutoNumberGeneric.class, ex);
            }
        }
        return null;
    }

    protected Integer getYearValue(UIFieldFormatterIFace formatter, String value) {
        UIFieldFormatterField yearField = formatter.getYear();
        if (yearField != null) {
            return this.extractIntegerValue(formatter.getYearPosition(), value);
        }
        return null;
    }

    protected Pair<Integer, Integer> getYearAndIncVal(UIFieldFormatterIFace formatter, String highestValue, String formValue) {
        UIFieldFormatterField yearField = formatter.getYear();
        boolean isByYear = yearField != null && yearField.isByYear();
        Integer valToBeInc = null;
        Integer yearToUse = null;
        String strToUseForInc = highestValue;
        if (isByYear) {
            Integer highestYear = this.getYearValue(formatter, highestValue);
            Integer formYear = this.getYearValue(formatter, formValue);
            boolean calcNewValue = false;
            if (highestYear != null && formYear != null) {
                yearToUse = formYear;
                if (formYear > highestYear) {
                    calcNewValue = true;
                }
            } else if (highestYear != null && formYear == null) {
                yearToUse = highestYear;
            } else if (highestYear == null && formYear != null) {
                yearToUse = formYear;
                calcNewValue = true;
            } else {
                Calendar cal = Calendar.getInstance();
                yearToUse = cal.get(1);
                if (isByYear) {
                    strToUseForInc = null;
                    calcNewValue = true;
                }
            }
            valToBeInc = !calcNewValue ? (strToUseForInc == null ? Integer.valueOf(0) : this.extractIntegerValue(formatter.getIncPosition(), strToUseForInc)) : Integer.valueOf(0);
        } else {
            if (formatter.getYear() != null) {
                yearToUse = this.getYearValue(formatter, formValue);
            }
            valToBeInc = StringUtils.isNotEmpty((String)highestValue) ? this.extractIntegerValue(formatter.getIncPosition(), strToUseForInc) : Integer.valueOf(0);
        }
        return new Pair<Integer, Integer>(yearToUse, valToBeInc);
    }

    protected String buildNewNumber(UIFieldFormatterIFace formatter, String value, Pair<Integer, Integer> yearAndIncVal) {
        String trimmedValue = StringUtils.deleteWhitespace((String)value);
        int fmtLen = formatter.getLength();
        if (trimmedValue.length() == 0 || StringUtils.isNotEmpty((String)value) && formatter.isLengthOK(value.length())) {
            Pair<Integer, Integer> pos = formatter.getIncPosition();
            if (pos != null && pos.second != null) {
                Pair<Integer, Integer> yrPos;
                UIFieldFormatterField yearField;
                int incVal = (Integer)yearAndIncVal.second + 1;
                StringBuilder sb = new StringBuilder(value.substring(0, (Integer)pos.first));
                String formatStr = "%0" + ((Integer)pos.second - (Integer)pos.first) + "d";
                sb.append(String.format(formatStr, incVal));
                if (fmtLen > (Integer)pos.second) {
                    sb.append(value.substring((Integer)pos.second, fmtLen));
                }
                if ((yearField = formatter.getYear()) != null && (yrPos = formatter.getYearPosition()) != null) {
                    sb.replace((Integer)yrPos.first, (Integer)yrPos.second, Integer.toString((Integer)yearAndIncVal.first));
                }
                return sb.toString();
            }
            this.errorMsg = "Formatter [" + formatter.getName() + "] doesn't have an incrementer field.";
        }
        return null;
    }

    @Override
    public String getNextNumber(UIFieldFormatterIFace formatter, String formValue) {
        return this.getNextNumber(formatter, formValue, false);
    }

    @Override
    public String getNextNumber(UIFieldFormatterIFace formatter, String formValue, boolean incrementValue) {
        this.errorMsg = null;
        if (StringUtils.isNotEmpty((String)formValue) && formatter.isLengthOK(formValue.length())) {
            Session session = null;
            try {
                session = HibernateUtil.getNewSession();
                UIFieldFormatterField yearField = formatter.getYear();
                Pair<Integer, Integer> yrPos = yearField != null ? formatter.getYearPosition() : null;
                String valueToIncrement = incrementValue ? formValue : this.getHighestObject(formatter, session, formValue, yrPos, formatter.getIncPosition());
                Pair<Integer, Integer> yearAndIncVal = this.getYearAndIncVal(formatter, valueToIncrement, formValue);
                if (yearAndIncVal != null) {
                    if (yearAndIncVal.second != null) {
                        String string = this.buildNewNumber(formatter, formValue, yearAndIncVal);
                        return string;
                    }
                    this.errorMsg = UIRegistry.getResourceString("AUTONUM_BAD_DATA_ERR");
                } else {
                    this.errorMsg = "yearAndIncVal was NULL and should NEVER be!";
                }
                return null;
            }
            catch (Exception ex) {
                this.errorMsg = ex.toString();
                ex.printStackTrace();
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(AutoNumberGeneric.class, ex);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        this.errorMsg = this.errorMsg == null ? "" : "\n";
        this.errorMsg = String.valueOf(this.errorMsg) + "Value [" + formValue + "] was not the proper length to be incremented.";
        return null;
    }

    @Override
    public boolean isGeneric() {
        return this.isGeneric;
    }

    @Override
    public void toXML(StringBuilder sb) {
        sb.append("  ");
        XMLHelper.xmlNode(sb, "autonumber", this.getClass().getName(), false);
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isInError() {
        return this.errorMsg != null;
    }
}

