/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class UsageTracker {
    public static final String NT_CON_EX = "NT_CON_EX";
    public static final String SQL_EX = "SQ_EX";
    public static final String HQL_EX = "HQ_EX";
    public static final String HNDLE_EX = "HNDLE";
    private static final String USAGE_PREFIX = "Usage.";
    private static File usageFile = null;
    private static Properties usageProps = null;
    private static Hashtable<String, String> categoriesHash = new Hashtable();

    public static void setUserInfo(String databaseName, String userName) {
        if (usageFile != null) {
            UsageTracker.done();
        }
        usageFile = new File(String.valueOf(UIRegistry.getAppDataDir()) + File.separator + databaseName + "_" + userName + ".usage");
        usageProps = new Properties();
        if (!usageFile.exists()) {
            UsageTracker.transferOldStats(usageProps);
        } else {
            try {
                usageProps.load(new FileInputStream(usageFile.getAbsoluteFile()));
                for (Object keyObj : new Vector<Object>(usageProps.keySet())) {
                    String key = keyObj.toString();
                    if (key.startsWith(USAGE_PREFIX)) continue;
                    usageProps.put(USAGE_PREFIX + key, usageProps.get(key));
                    usageProps.remove(key);
                }
            }
            catch (IOException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(UsageTracker.class, ex);
                ex.printStackTrace();
            }
        }
        if (usageProps != null) {
            UsageTracker.incrUsageCount("AP.LoginedIn");
        }
    }

    private static void transferOldStats(Properties newProps) {
        Properties lpProps = AppPreferences.getLocalPrefs().getProperties();
        for (Object keyObj : new Vector<Object>(lpProps.keySet())) {
            String pName = keyObj.toString();
            if (!pName.startsWith(USAGE_PREFIX)) continue;
            newProps.put(pName.substring(6), lpProps.get(keyObj));
            lpProps.remove(keyObj);
        }
        UsageTracker.save();
    }

    public static void save() {
        try {
            if (usageProps != null && usageFile != null) {
                usageProps.store(new FileOutputStream(usageFile.getAbsoluteFile()), "User Stats");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void done() {
        if (usageFile != null && usageProps != null) {
            UsageTracker.save();
        }
        usageProps = null;
        usageFile = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        UsageTracker.done();
    }

    public static synchronized void incrNetworkUsageCount() {
        UsageTracker.incrUsageCount(NT_CON_EX);
    }

    public static synchronized void incrSQLUsageCount() {
        UsageTracker.incrUsageCount(SQL_EX);
    }

    public static synchronized void incrHQLUsageCount() {
        UsageTracker.incrUsageCount(HQL_EX);
    }

    public static synchronized void incrHandledUsageCount() {
        UsageTracker.incrUsageCount(HNDLE_EX);
    }

    public static synchronized void incrUsageCount(String featureName) {
        AppPreferences appPrefs = AppPreferences.getLocalPrefs();
        if (appPrefs.isAvailable()) {
            String usagePrefName = USAGE_PREFIX + featureName;
            if (usageFile == null || usageProps == null) {
                Integer currentUsageCount = appPrefs.getInt(usagePrefName, 0);
                if (currentUsageCount != null) {
                    currentUsageCount = currentUsageCount + 1;
                    appPrefs.putInt(usagePrefName, currentUsageCount);
                }
            } else {
                String currentUsageCountStr = usageProps.getProperty(usagePrefName, null);
                int currentUsageCount = 0;
                if (currentUsageCountStr != null) {
                    currentUsageCount = Integer.parseInt(currentUsageCountStr);
                }
                usageProps.put(usagePrefName, Integer.toString(++currentUsageCount));
            }
        }
    }

    public static synchronized List<Pair<String, Integer>> getUsageStats() {
        Vector<Pair<String, Integer>> usageStats = new Vector<Pair<String, Integer>>();
        for (Object keyObj : usageProps.keySet()) {
            String prefName = keyObj.toString();
            String valStr = prefName.equals("Usage.RunCount") ? AppPreferences.getLocalPrefs().get(prefName, "") : usageProps.getProperty(prefName);
            if (valStr.isEmpty() || !StringUtils.isNumeric((String)valStr)) continue;
            int count = Integer.parseInt(valStr);
            Pair<String, Integer> stat = new Pair<String, Integer>(prefName, count);
            usageStats.add(stat);
        }
        return usageStats;
    }

    protected static synchronized void clearUsageStats() {
        AppPreferences appPrefs = AppPreferences.getLocalPrefs();
        Set<Object> prefNames = appPrefs.getProperties().keySet();
        HashSet<Object> prefNamesCopy = new HashSet<Object>();
        prefNamesCopy.addAll(prefNames);
        for (Object e : prefNamesCopy) {
            String prefName = (String)e;
            if (!prefName.startsWith(USAGE_PREFIX)) continue;
            appPrefs.remove(prefName);
        }
        if (usageProps != null) {
            usageProps.clear();
        }
    }

    public static synchronized int getUsageCount(String featureName) {
        if (featureName.startsWith(USAGE_PREFIX)) {
            AppPreferences appPrefs = AppPreferences.getLocalPrefs();
            return appPrefs.getInt(featureName, 0);
        }
        String valStr = usageProps.getProperty(featureName);
        if (StringUtils.isNumeric((String)valStr)) {
            return Integer.parseInt(valStr);
        }
        return 0;
    }

    public static synchronized String getInstallId() {
        AppPreferences appPrefs = AppPreferences.getLocalPrefs();
        if (appPrefs.isAvailable()) {
            String installIdStart = appPrefs.get("InstallIdStart", null);
            if (installIdStart == null) {
                Random r = new Random(System.currentTimeMillis());
                UUID idStart = new UUID(r.nextLong(), r.nextLong());
                installIdStart = idStart.toString();
                appPrefs.put("InstallIdStart", installIdStart);
            }
            String installIdEnd = appPrefs.get("InstallIdEnd", null);
            File pluginRegFile = XMLHelper.getConfigDir("plugin_registry.xml");
            long lastMod = pluginRegFile.lastModified();
            String lastModString = Long.toHexString(lastMod);
            if (installIdEnd == null || !installIdEnd.equals(lastModString)) {
                UsageTracker.clearUsageStats();
                appPrefs.put("InstallIdEnd", lastModString);
                installIdEnd = lastModString;
            }
            String installId = String.valueOf(installIdStart) + "--" + installIdEnd;
            return installId;
        }
        return null;
    }

    public static void addCategory(String cat, String desc) {
        if (StringUtils.isNotEmpty((String)cat)) {
            categoriesHash.put(cat, desc);
        }
    }

    public static Hashtable<String, String> getCategoriesHash() {
        return categoriesHash;
    }
}

