/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.AppContextMgr;
import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.MenuItemDesc;
import edu.ku.brc.af.core.PermissionIFace;
import edu.ku.brc.af.core.ServiceInfo;
import edu.ku.brc.af.core.TaskCommandDef;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.ToolBarItemDesc;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.ui.forms.UIPluginable;
import edu.ku.brc.af.ui.forms.persist.FormDevHelper;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.helpers.XMLHelper;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.ToolbarLayoutManager;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class TaskMgr
implements CommandListener {
    private static final Logger log = Logger.getLogger(TaskMgr.class);
    private static final TaskMgr instance = new TaskMgr();
    private static final String APP_RESTART_ACT = "AppRestart";
    private static final String APP_SHUTDOWN_ACT = "Shutdown";
    protected Vector<Taskable> toolbarTasks = new Vector();
    protected Hashtable<String, MenuElement> menuHash = new Hashtable();
    protected Element commandDOMRoot = null;
    protected Taskable defaultTask = null;
    protected Taskable currentTask = null;
    protected Hashtable<String, Taskable> tasks = new Hashtable();
    protected Hashtable<String, Class<?>> uiPluginHash = new Hashtable();
    protected Vector<Taskable> disabledTasks = new Vector();

    protected TaskMgr() {
        CommandDispatcher.register("App", this);
    }

    public static TaskMgr getInstance() {
        return instance;
    }

    public static Taskable getDefaultTaskable() {
        return TaskMgr.instance.defaultTask;
    }

    public Taskable getCurrentTask() {
        return this.currentTask;
    }

    public static int getToolbarTaskCount() {
        return TaskMgr.instance.toolbarTasks.size();
    }

    public static void requestInitalContext() {
        if (TaskMgr.instance.defaultTask != null) {
            TaskMgr.instance.defaultTask.requestContext();
            TaskMgr.instance.currentTask = TaskMgr.instance.defaultTask;
        } else {
            Taskable arbitraryTaskable;
            Taskable startUpTask = ContextMgr.getTaskByName(UIRegistry.getResourceString("TaskMgr.STARTUP"));
            if (startUpTask != null) {
                startUpTask.requestContext();
                TaskMgr.instance.currentTask = startUpTask;
            } else if (TaskMgr.instance.tasks.values().size() > 0 && (arbitraryTaskable = TaskMgr.instance.tasks.values().iterator().next()) != null) {
                arbitraryTaskable.requestContext();
                TaskMgr.instance.currentTask = startUpTask;
            }
        }
    }

    public static void register(Taskable plugin, boolean shouldAddUI) {
        if (plugin != null) {
            if (TaskMgr.instance.tasks.get(plugin.getName()) == null) {
                TaskMgr.instance.tasks.put(plugin.getName(), plugin);
                if (shouldAddUI) {
                    TaskMgr.registerWithUI(plugin);
                }
            } else {
                FormDevHelper.appendFormDevError("Registering a plugin with an existing name[" + plugin.getName() + "]");
            }
        } else {
            FormDevHelper.appendFormDevError("Trying to register a null plugin!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unregister(Taskable taskable) {
        if (taskable == null) throw new NullPointerException("Trying to unregister a null plugin!");
        Taskable tp = TaskMgr.instance.tasks.get(taskable.getName());
        if (tp == null) throw new RuntimeException("Unregistering a plugin that has been registered [" + taskable.getName() + "]");
        TaskMgr.instance.tasks.remove(taskable.getName());
        if (TaskMgr.instance.toolbarTasks.indexOf(tp) > -1) {
            TaskMgr.instance.toolbarTasks.remove(tp);
        }
        if (taskable != TaskMgr.instance.defaultTask) return;
        TaskMgr.instance.defaultTask = null;
    }

    public static Taskable getTask(String name) {
        return TaskMgr.instance.tasks.get(name);
    }

    protected static void registerWithUI(Taskable plugin) {
        boolean isVisible = false;
        JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
        if (toolBar != null) {
            List<ToolBarItemDesc> toolBarItems = plugin.getToolBarItems();
            if (toolBarItems != null && toolBarItems.size() > 0) {
                isVisible = true;
                for (ToolBarItemDesc tbItem : toolBarItems) {
                    Component toolBarComp = tbItem.getComp();
                    if (tbItem.getPos() == ToolBarItemDesc.Position.Insert) {
                        toolBar.add(toolBarComp, tbItem.getIndex());
                        continue;
                    }
                    if (tbItem.getPos() == ToolBarItemDesc.Position.Append) {
                        toolBar.add(toolBarComp);
                        continue;
                    }
                    if (tbItem.getPos() == ToolBarItemDesc.Position.AdjustRightLastComp) {
                        toolBar.add(toolBarComp);
                        LayoutManager layout = toolBar.getLayout();
                        if (!(layout instanceof ToolbarLayoutManager)) continue;
                        ((ToolbarLayoutManager)layout).setAdjustRightLastComp(true);
                        continue;
                    }
                    if (tbItem.getPos() != ToolBarItemDesc.Position.AppendNextToLast) continue;
                    int inx = toolBar.getComponentCount();
                    if (inx > 0) {
                        --inx;
                    }
                    toolBar.add(toolBarComp, inx);
                }
            }
        } else {
            throw new NullPointerException("The Toolbar component cannot be null!");
        }
        JMenuBar menuBar = (JMenuBar)UIRegistry.get("menubar");
        if (menuBar != null) {
            List<MenuItemDesc> menuItems = plugin.getMenuItems();
            if (menuItems != null) {
                for (MenuItemDesc menuItem : menuItems) {
                    TaskMgr.instance.menuHash.put(menuItem.getMenuPath(), menuItem.getMenuItem());
                    String[] menuPath = StringUtils.split((String)menuItem.getMenuPath(), (String)"/");
                    TaskMgr.buildMenuTree(menuBar, menuItem, menuPath, 0);
                }
            }
        } else {
            throw new NullPointerException("The MenuBar component cannot be null!");
        }
        if (isVisible) {
            TaskMgr.instance.toolbarTasks.add(plugin);
        }
    }

    public static MenuElement getMenuElementByPath(String path) {
        return TaskMgr.getInstance().menuHash.get(path);
    }

    public static void addToolbarBtn(Component toolBarComp, int pos) {
        JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
        if (toolBar != null) {
            toolBar.add(toolBarComp, pos);
        }
    }

    public static void removeToolbarBtn(Component toolBarComp) {
        JToolBar toolBar = (JToolBar)UIRegistry.get("toolbar");
        if (toolBar != null) {
            toolBar.remove(toolBarComp);
        }
    }

    public static void buildMenuTree(MenuElement parent, MenuItemDesc menuItemDesc, String[] menuPath, int currIndex) {
        if (currIndex == menuPath.length) {
            MenuElement me = menuItemDesc.getMenuItem();
            if (parent instanceof JMenuBar) {
                ((JMenuBar)parent).add((JMenu)me);
            } else if (parent instanceof JMenu) {
                JPopupMenu menuComp = ((JMenu)parent).getPopupMenu();
                boolean found = false;
                int insertPos = menuComp.getComponentCount();
                JMenu menu = (JMenu)parent;
                if (menuItemDesc.getPosition() == MenuItemDesc.Position.Top) {
                    insertPos = 0;
                } else {
                    menuItemDesc.getPosition();
                }
                if (menuItemDesc.getPosition() == MenuItemDesc.Position.Before || menuItemDesc.getPosition() == MenuItemDesc.Position.After) {
                    int inx = 0;
                    int i = 0;
                    while (i < menuComp.getComponentCount()) {
                        Component c = menuComp.getComponent(i);
                        if (c instanceof JMenuItem && ((JMenuItem)c).getText().equals(menuItemDesc.getPosMenuItemName())) {
                            insertPos = inx + 1;
                            found = true;
                            break;
                        }
                        ++inx;
                        ++i;
                    }
                }
                if (menuItemDesc.getSepPosition() == MenuItemDesc.Position.Before) {
                    menu.add((Component)new JPopupMenu.Separator(), insertPos);
                    ++insertPos;
                }
                if (insertPos == -1) {
                    menu.add((JMenuItem)me);
                } else {
                    menu.add((Component)((JMenuItem)me), insertPos);
                    found = true;
                }
                ++insertPos;
                if (menuItemDesc.getSepPosition() == MenuItemDesc.Position.After && found) {
                    menu.add((Component)new JPopupMenu.Separator(), insertPos);
                }
            } else if (parent instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)parent;
                JPopupMenu menu = (JPopupMenu)mi.getParent();
                int pos = 0;
                int i = 0;
                while (i < menu.getComponentCount()) {
                    if (mi == menu.getComponent(i)) {
                        pos = i;
                        break;
                    }
                    ++i;
                }
                menu.insert((JMenuItem)me, menuItemDesc.getPosition() == MenuItemDesc.Position.After ? pos + 1 : pos);
            }
        } else {
            String label = UIRegistry.getResourceString(menuPath[currIndex]);
            MenuElement menuElement = TaskMgr.getMenuByName(parent, label);
            if (menuElement == null) {
                log.error((Object)("Couldn't find menu element [" + label + "]"));
            }
            TaskMgr.buildMenuTree(menuElement, menuItemDesc, menuPath, currIndex + 1);
        }
    }

    public static MenuElement getMenuByName(MenuElement parent, String name) {
        MenuElement[] menuElementArray = parent.getSubElements();
        int n = menuElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuElement mi = menuElementArray[n2];
            if (mi instanceof AbstractButton) {
                if (((AbstractButton)((Object)mi)).getText().equals(name)) {
                    return mi;
                }
            } else if (mi instanceof JPopupMenu) {
                return TaskMgr.getMenuByName(mi, name);
            }
            ++n2;
        }
        return null;
    }

    public static void initializePlugins() {
        Enumeration<Taskable> e = TaskMgr.instance.tasks.elements();
        while (e.hasMoreElements()) {
            e.nextElement().preInitialize();
        }
        for (Taskable taskablePlugin : TaskMgr.instance.tasks.values()) {
            taskablePlugin.initialize(TaskMgr.getCommandDefinitions(taskablePlugin.getTaskClass()), true);
        }
    }

    protected static void loadServiceIcons(String name, ServiceInfo info) {
        info.addIcon(IconManager.getIcon(name, IconManager.IconSize.Std16), IconManager.IconSize.Std16);
        info.addIcon(IconManager.getIcon(name, IconManager.IconSize.Std24), IconManager.IconSize.Std24);
        info.addIcon(IconManager.getIcon(name, IconManager.IconSize.Std32), IconManager.IconSize.Std32);
    }

    public void readRegistry(boolean isMobile) {
        if (TaskMgr.instance.tasks.size() == 0) {
            String fileName = "plugin_registry.xml";
            HashMap<String, PluginInfo> plugins = new HashMap<String, PluginInfo>();
            HashMap<String, PluginInfo> uiPlugins = new HashMap<String, PluginInfo>();
            String path = XMLHelper.getConfigDirPath(fileName);
            this.readRegistry(path, plugins, uiPlugins, isMobile);
            path = String.valueOf(AppPreferences.getLocalPrefs().getDirPath()) + File.separator + fileName;
            this.readRegistry(path, plugins, uiPlugins, isMobile);
            this.readRegistry(plugins, uiPlugins);
        }
    }

    private void readRegistry(String path, HashMap<String, PluginInfo> plugins, HashMap<String, PluginInfo> uiPlugins, boolean isMobile) {
        try {
            File file = new File(path);
            if (file.exists()) {
                String className;
                String pluginName;
                Element root = XMLHelper.readFileToDOM4J(file);
                int order = 0;
                List boxes = root.selectNodes("/plugins/" + (isMobile ? "mobilecore" : "core") + "/plugin");
                for (Element pluginElement : boxes) {
                    pluginName = pluginElement.attributeValue("name");
                    className = pluginElement.attributeValue("class");
                    Boolean addToUI = XMLHelper.getAttr(pluginElement, "addui", false);
                    Boolean isDefault = XMLHelper.getAttr(pluginElement, "default", false);
                    String prefName = pluginElement.attributeValue("prefname");
                    if (!StringUtils.isNotEmpty((String)pluginName) || !StringUtils.isNotEmpty((String)className)) continue;
                    PluginInfo newPI = new PluginInfo(order, pluginName, className, addToUI, isDefault, prefName);
                    PluginInfo pi = plugins.get(pluginName);
                    if (pi != null) {
                        newPI.setOrder(newPI.getOrder());
                    }
                    plugins.put(pluginName, newPI);
                    ++order;
                }
                for (Element pluginElement : root.selectNodes("/plugins/uiplugins/plugin")) {
                    pluginName = XMLHelper.getAttr(pluginElement, "name", null);
                    className = XMLHelper.getAttr(pluginElement, "class", null);
                    if (!StringUtils.isNotEmpty((String)pluginName) || !StringUtils.isNotEmpty((String)className)) continue;
                    uiPlugins.put(pluginName, new PluginInfo(pluginName, className));
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskMgr.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
    }

    private void readRegistry(HashMap<String, PluginInfo> plugins, HashMap<String, PluginInfo> uiPlugins) {
        try {
            Vector<PluginInfo> list = new Vector<PluginInfo>(plugins.values());
            Collections.sort(list);
            for (PluginInfo pi : list) {
                String prefName = pi.getPrefName();
                if (prefName != null && !AppPreferences.getLocalPrefs().getBoolean(prefName, false).booleanValue()) continue;
                Taskable newObj = null;
                try {
                    newObj = Class.forName(pi.getClassName()).asSubclass(Taskable.class).newInstance();
                }
                catch (Exception ex) {
                    if (!StringUtils.isEmpty((String)prefName)) continue;
                    log.error((Object)ex);
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskMgr.class, ex);
                    continue;
                }
                if (newObj instanceof Taskable) {
                    boolean isTaskDefault;
                    PermissionIFace perm;
                    Taskable task = newObj;
                    boolean shouldAddToUI = pi.getIsAddToUI();
                    if (AppContextMgr.isSecurityOn() && (perm = task.getPermissions()) != null && !perm.canView()) {
                        shouldAddToUI = false;
                        task.setEnabled(false);
                    }
                    if (isTaskDefault = pi.getIsDefault().booleanValue()) {
                        if (TaskMgr.instance.defaultTask == null) {
                            TaskMgr.instance.defaultTask = task;
                        } else {
                            log.error((Object)("More than one plugin thinks it is the default[" + task.getName() + "]"));
                        }
                    }
                    TaskMgr.register(task, shouldAddToUI);
                    continue;
                }
                log.error((Object)("Oops, the plugin is not instance of Taskable [" + newObj + "]"));
            }
            for (PluginInfo uiPI : uiPlugins.values()) {
                try {
                    Class<UIPluginable> cls = Class.forName(uiPI.getClassName()).asSubclass(UIPluginable.class);
                    this.uiPluginHash.put(uiPI.getPluginName(), cls);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    ex.printStackTrace();
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(TaskMgr.class, ex);
                }
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskMgr.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
    }

    public static Class<?> getUIPluginClassForName(String pluginName) {
        return TaskMgr.instance.uiPluginHash.get(pluginName);
    }

    public List<String> getUIPluginList() {
        Vector<String> list = new Vector<String>(this.uiPluginHash.keySet().size());
        list.addAll(this.uiPluginHash.keySet());
        return list;
    }

    public Collection<Taskable> getAllTasks() {
        return this.tasks.values();
    }

    private void shutdownTasks() {
        for (Taskable task : TaskMgr.instance.tasks.values()) {
            task.shutdown();
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isAction(APP_RESTART_ACT)) {
            this.shutdownTasks();
            for (Taskable task : TaskMgr.instance.tasks.values()) {
                if (!AppContextMgr.isSecurityOn()) continue;
                task.setPermissions(null);
                PermissionIFace perm = task.getPermissions();
                if (perm == null) continue;
                task.setEnabled(perm.canView());
            }
        } else if (cmdAction.isAction(APP_SHUTDOWN_ACT)) {
            this.shutdownTasks();
        }
    }

    public static List<TaskCommandDef> getCommandDefinitions(Class<?> classObj) {
        ArrayList<TaskCommandDef> list = new ArrayList<TaskCommandDef>();
        try {
            if (TaskMgr.instance.commandDOMRoot == null) {
                TaskMgr.instance.commandDOMRoot = XMLHelper.readDOMFromConfigDir("command_registry.xml");
            }
            List cmds = TaskMgr.instance.commandDOMRoot.selectNodes("/commands/command[@class='" + classObj.getName() + "']");
            for (Element cmdElement : cmds) {
                String cmdName = XMLHelper.getAttr(cmdElement, "name", null);
                String cmdIconName = XMLHelper.getAttr(cmdElement, "icon", null);
                if (!StringUtils.isNotEmpty((String)cmdName) || !StringUtils.isNotEmpty((String)cmdIconName)) continue;
                Properties params = null;
                List paramsList = cmdElement.selectNodes("param");
                for (Element paramElement : paramsList) {
                    String name = XMLHelper.getAttr(paramElement, UIRegistry.getResourceString("TaskMgr.0"), null);
                    String value = paramElement.getTextTrim();
                    if (!StringUtils.isNotEmpty((String)name) || !StringUtils.isNotEmpty((String)value)) continue;
                    if (params == null) {
                        params = new Properties();
                    }
                    params.put(name, value);
                }
                TaskCommandDef tcd = new TaskCommandDef(cmdName, cmdIconName, params);
                list.add(tcd);
            }
        }
        catch (Exception ex) {
            UsageTracker.incrHandledUsageCount();
            ExceptionTracker.getInstance().capture(TaskMgr.class, ex);
            ex.printStackTrace();
            log.error((Object)ex);
        }
        return list;
    }

    public static void disableAllEnabledTasks() {
        TaskMgr tm = TaskMgr.getInstance();
        if (tm.disabledTasks.size() == 0) {
            for (Taskable task : tm.getAllTasks()) {
                if (!task.isEnabled()) continue;
                tm.disabledTasks.add(task);
                task.setEnabled(false);
            }
        }
    }

    public static boolean areTasksDisabled() {
        return TaskMgr.getInstance().disabledTasks.size() > 0;
    }

    public static void reenableAllDisabledTasks() {
        for (Taskable task : TaskMgr.getInstance().disabledTasks) {
            task.setEnabled(true);
        }
        TaskMgr.getInstance().disabledTasks.clear();
    }

    class PluginInfo
    implements Comparable<PluginInfo> {
        private Integer order;
        private String pluginName;
        private String className;
        private Boolean isAddToUI;
        private Boolean isDefault;
        private String prefName;

        public PluginInfo(String pluginName, String className) {
            this(null, pluginName, className, null, null, null);
        }

        public PluginInfo(Integer order, String pluginName, String className, Boolean isAddToUI, Boolean isDefault, String prefName) {
            this.order = order;
            this.pluginName = pluginName;
            this.className = className;
            this.isAddToUI = isAddToUI;
            this.isDefault = isDefault;
            this.prefName = prefName;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getClassName() {
            return this.className;
        }

        public Boolean getIsAddToUI() {
            return this.isAddToUI;
        }

        public Boolean getIsDefault() {
            return this.isDefault;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public String getPrefName() {
            return this.prefName;
        }

        @Override
        public int compareTo(PluginInfo o) {
            return this.order.compareTo(o.order);
        }
    }
}

