/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.SubPaneIFace;
import edu.ku.brc.af.core.SubPaneMgrListener;
import edu.ku.brc.af.core.TaskMgr;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.af.tasks.subpane.SimpleDescPane;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.dbsupport.RecordSetItemIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.ExtendedTabPanel;
import edu.ku.brc.ui.ExtendedTabbedPane;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SubPaneMgr
extends ExtendedTabbedPane
implements ChangeListener {
    private static final Logger log = Logger.getLogger(SubPaneMgr.class);
    private static final SubPaneMgr instance = new SubPaneMgr();
    protected Hashtable<String, SubPaneIFace> panes = new Hashtable();
    protected SubPaneIFace currentPane = null;
    protected List<SubPaneMgrListener> listeners = new ArrayList<SubPaneMgrListener>();
    protected boolean globalShutdown = false;
    protected JPopupMenu popupMenu = null;
    protected MouseAdapter popupMouseAdapter = null;

    protected SubPaneMgr() {
        this.addChangeListener(this);
        this.setOpaque(true);
        SubPaneMgr.createTabActions();
        this.createContextMenu();
        this.popupMouseAdapter = new MouseAdapter(){

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int y = e.getY() - SubPaneMgr.this.popupMenu.getSize().height;
                    SubPaneMgr.this.popupMenu.show(e.getComponent(), e.getX(), y < 0 ? e.getY() : y);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                this.showPopup(e);
            }
        };
        this.addMouseListener(this.popupMouseAdapter);
    }

    public static SubPaneMgr getInstance() {
        return instance;
    }

    @Override
    protected ExtendedTabPanel adjustTab(String title, Icon icon, Component comp, int index) {
        ExtendedTabPanel tabUI = super.adjustTab(title, icon, comp, index);
        return tabUI;
    }

    protected String buildUniqueName(String paneName) {
        String title = paneName;
        boolean nameInUse = this.panes.get(paneName) != null;
        int index = 2;
        while (nameInUse) {
            title = String.valueOf(paneName) + "(" + index + ")";
            nameInUse = this.panes.get(title) != null;
            ++index;
        }
        return title;
    }

    public SubPaneIFace addPane(SubPaneIFace pane) {
        Component firstFocusable;
        if (pane == null) {
            throw new NullPointerException("Null name or pane when adding to SubPaneMgr");
        }
        int maxNumPanes = AppPreferences.getRemote().getInt("SubPaneMgr.MaxPanes", 10);
        if (this.getComponentCount() >= maxNumPanes) {
            boolean doAsk = AppPreferences.getRemote().getBoolean("tabs.askb4close", false);
            if (doAsk) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object[] options = new Object[]{UIRegistry.getResourceString("SubPaneMgr.SUBPANE_OPTIONS_CLOSE_ALLBUT"), UIRegistry.getResourceString("SubPaneMgr.SUBPANE_OPTIONS_CLOSE_OLDEST")};
                        int userChoice = JOptionPane.showOptionDialog(UIRegistry.getTopWindow(), UIRegistry.getResourceString("SubPaneMgr.SUBPANE_OPTIONS_MAX_TABS"), UIRegistry.getResourceString("SubPaneMgr.SUBPANE_OPTIONS_TOO_MANY"), 1, 3, null, options, options[0]);
                        if (userChoice == 0) {
                            SubPaneMgr.this.closeAll(false);
                        } else {
                            SubPaneMgr.this.closeOldestPane();
                        }
                    }
                });
            } else {
                this.closeOldestPane();
            }
        }
        if ((firstFocusable = pane.getFirstFocusable()) != null) {
            pane.getUIComponent().addComponentListener(new TabSelectionFocusGainListener(firstFocusable));
        }
        UIRegistry.getStatusBar().setText("");
        if (SubPaneMgr.instance.panes.contains(pane)) {
            this.showPane(pane);
            this.adjustCloseAllMenu();
            return pane;
        }
        pane.setPaneName(this.buildUniqueName(pane.getPaneName()));
        this.panes.put(pane.getPaneName(), pane);
        this.addTab(pane.getPaneName(), pane.getIcon(), pane.getUIComponent());
        this.notifyListeners(NotificationType.Added, pane);
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(this.getTabCount() - 1);
        }
        this.adjustCloseAllMenu();
        return pane;
    }

    protected void closeOldestPane() {
        SubPaneIFace pane = this.getOldestPane();
        if (pane != null) {
            this.removePane(pane);
        }
    }

    protected SubPaneIFace getOldestPane() {
        ArrayList<SubPaneIFace> subPanes = new ArrayList<SubPaneIFace>(SubPaneMgr.instance.panes.values());
        Collections.sort(subPanes, new Comparator<SubPaneIFace>(){

            @Override
            public int compare(SubPaneIFace o1, SubPaneIFace o2) {
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        for (SubPaneIFace sp : subPanes) {
            if (sp.getMultiView() != null) continue;
            return sp;
        }
        for (SubPaneIFace sp : subPanes) {
            if (sp.getMultiView() == null || sp.getMultiView().isEditable()) continue;
            return sp;
        }
        for (SubPaneIFace sp : subPanes) {
            if (sp.getMultiView() == null || !sp.getMultiView().isEditable() || sp.getMultiView().hasChanged()) continue;
            return sp;
        }
        return subPanes.get(0);
    }

    protected void adjustCloseAllMenu() {
        Action closeAllBut;
        Action closeAll;
        Action closeCurrent = UIRegistry.getAction("CloseCurrent");
        if (closeCurrent != null) {
            closeCurrent.setEnabled(this.panes.size() > 0);
        }
        if ((closeAll = UIRegistry.getAction("CloseAll")) != null) {
            closeAll.setEnabled(this.panes.size() > 0);
        }
        if ((closeAllBut = UIRegistry.getAction("CloseAllBut")) != null) {
            closeAllBut.setEnabled(this.panes.size() > 1);
        }
        this.checkForTaskableConfig();
    }

    public SubPaneIFace renamePane(SubPaneIFace pane, String newName) {
        int cnt = 1;
        String newNameStr = newName;
        while (this.panes.get(newNameStr) != null) {
            newNameStr = String.valueOf(newName) + " " + Integer.toString(cnt);
            ++cnt;
        }
        UIRegistry.getStatusBar().setText("");
        if (this.panes.get(pane.getPaneName()) != null) {
            this.panes.remove(pane.getPaneName());
            pane.setPaneName(newNameStr);
            int index = this.indexOfComponent(pane.getUIComponent());
            Component tabComp = this.getTabComponentAt(index);
            if (tabComp instanceof ExtendedTabPanel) {
                ((ExtendedTabPanel)tabComp).setTitle(pane.getPaneName());
            } else {
                this.setTitleAt(index, pane.getPaneName());
            }
            this.panes.put(pane.getPaneName(), pane);
        } else {
            log.error((Object)("Couldn't find pane named[" + pane.getPaneName() + "]"));
        }
        return pane;
    }

    public synchronized SubPaneIFace replacePane(SubPaneIFace oldPane, SubPaneIFace newPane) {
        UIRegistry.getStatusBar().setText("");
        SubPaneIFace fndPane = this.panes.get(oldPane.getPaneName());
        if (oldPane != fndPane) {
            this.addPane(newPane);
            this.notifyListeners(NotificationType.Added, newPane);
            return newPane;
        }
        final int index = this.indexOfComponent(oldPane.getUIComponent());
        if (index < 0 || index >= this.getComponentCount()) {
            log.error((Object)("Couldn't find index for panel [" + oldPane.getPaneName() + "] index was[" + index + "] number tab[" + this.getComponentCount() + "]"));
        }
        if (this.panes.get(oldPane.getPaneName()) != null) {
            this.notifyListeners(NotificationType.Added, newPane);
            this.insertTab(newPane.getPaneName(), newPane.getIcon(), newPane.getUIComponent(), null, index);
            String title = this.buildUniqueName(newPane.getPaneName());
            newPane.setPaneName(title);
            this.removePane(oldPane, false);
            this.panes.put(newPane.getPaneName(), newPane);
            this.adjustCloseAllMenu();
            this.checkForTaskableConfig();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (index > -1 && index < SubPaneMgr.this.getComponentCount()) {
                        SubPaneMgr.this.setSelectedIndex(index);
                    }
                }
            });
            return newPane;
        }
        log.error((Object)("Couldn't find pane named[" + oldPane.getPaneName() + "]"));
        return null;
    }

    protected void checkForTaskableConfig() {
        Action configTaskAction;
        if (this.currentPane != null && (configTaskAction = UIRegistry.getAction("ConfigureTask")) != null) {
            configTaskAction.setEnabled(this.currentPane.getTask().isConfigurable());
        }
    }

    public boolean removePane(SubPaneIFace pane) {
        return this.removePane(pane, true);
    }

    public boolean removePane(SubPaneIFace pane, boolean askForSave) {
        return this.removePane(pane, askForSave, askForSave);
    }

    protected synchronized boolean removePane(final SubPaneIFace pane, boolean askForSave, boolean doAboutToShutdown) {
        boolean okToShutdown;
        UIRegistry.getStatusBar().setText("");
        if (this.currentPane == pane) {
            pane.showingPane(false);
            this.currentPane = null;
        }
        boolean bl = okToShutdown = !doAboutToShutdown || pane.aboutToShutdown();
        if (askForSave && !okToShutdown) {
            return false;
        }
        if (this.panes.get(pane.getPaneName()) != null) {
            this.notifyListeners(NotificationType.Removed, pane);
            try {
                int inx = this.indexOfComponent(pane.getUIComponent());
                if (inx != -1 && inx < this.getTabCount()) {
                    this.removeTabAt(inx);
                }
                pane.getUIComponent().setVisible(false);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SubPaneMgr.class, ex);
                System.err.println(String.valueOf(this.getTabCount()) + "   - " + this.getComponentCount());
                log.error((Object)ex);
                ex.printStackTrace();
            }
            this.panes.remove(pane.getPaneName());
            if (!this.globalShutdown) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pane.shutdown();
                    }
                });
            } else {
                pane.shutdown();
            }
        } else {
            log.error((Object)("Couldn't find pane named[" + pane.getPaneName() + "]"));
            SubPaneIFace subPane = this.getCurrentSubPane();
            if (subPane != null) {
                if (!subPane.aboutToShutdown()) {
                    return false;
                }
                subPane.shutdown();
                try {
                    int inx = this.indexOfTab(pane.getTitle());
                    if (inx != -1 && inx < this.getTabCount()) {
                        this.removeTabAt(inx);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(SubPaneMgr.class, ex);
                    log.error((Object)ex);
                    ex.printStackTrace();
                }
            }
        }
        this.adjustCloseAllMenu();
        return true;
    }

    public static void replaceSimplePaneForTask(SubPaneIFace subPane) {
        for (SubPaneIFace sp : SubPaneMgr.instance.panes.values()) {
            if (sp.getTask() != subPane.getTask() || !(sp.getUIComponent() instanceof SimpleDescPane)) continue;
            instance.replacePane(sp, subPane);
            return;
        }
        instance.addPane(subPane);
    }

    public static SubPaneIFace getSubPaneWithRecordSet(RecordSetIFace rs) {
        SubPaneIFace subPane = null;
        if (rs != null) {
            for (SubPaneIFace sp : SubPaneMgr.instance.panes.values()) {
                RecordSetIFace sprs = sp.getRecordSet();
                if (sprs == null) continue;
                if (sprs == rs) {
                    return sp;
                }
                if (sprs.getRecordSetId() != null && rs.getRecordSetId() != null && sprs.getRecordSetId().equals(rs.getRecordSetId())) {
                    return sp;
                }
                if (!sprs.getDbTableId().equals(rs.getDbTableId()) || sprs.getNumItems() != rs.getNumItems()) continue;
                Hashtable<Integer, Boolean> hash = new Hashtable<Integer, Boolean>();
                for (RecordSetItemIFace rsi : rs.getItems()) {
                    hash.put(rsi.getRecordId(), true);
                }
                boolean allTheSame = true;
                for (RecordSetItemIFace rsi : sprs.getItems()) {
                    if (hash.get(rsi.getRecordId()) != null) continue;
                    allTheSame = false;
                    break;
                }
                if (!allTheSame) continue;
                return sp;
            }
        }
        return subPane;
    }

    public SubPaneIFace getSubPaneByName(String subPaneName) {
        for (SubPaneIFace sp : SubPaneMgr.instance.panes.values()) {
            if (!subPaneName.equals(sp.getPaneName())) continue;
            return sp;
        }
        return null;
    }

    public Collection<SubPaneIFace> getSubPanes() {
        return this.panes.values();
    }

    public boolean aboutToShutdown() {
        this.globalShutdown = true;
        ArrayList<SubPaneIFace> list = new ArrayList<SubPaneIFace>(this.panes.values());
        for (SubPaneIFace sp : list) {
            boolean ok = sp.aboutToShutdown();
            if (!ok) {
                this.globalShutdown = false;
                return false;
            }
            this.removePane(sp, false);
        }
        this.globalShutdown = false;
        return true;
    }

    public boolean isGlobalShutdown() {
        return this.globalShutdown;
    }

    public SubPaneIFace showPane(String name) {
        UIRegistry.getStatusBar().setText("");
        SubPaneIFace pane = this.panes.get(name);
        return this.showPane(pane);
    }

    public SubPaneIFace showPane(SubPaneIFace pane) {
        if (pane != null) {
            SubPaneIFace oldPane = this.getCurrentSubPane();
            if (oldPane != null && oldPane != pane) {
                oldPane.showingPane(false);
            }
        } else {
            throw new NullPointerException();
        }
        pane.showingPane(true);
        this.setSelectedComponent(pane.getUIComponent());
        this.checkForTaskableConfig();
        return pane;
    }

    public SubPaneIFace getSubPaneForComponent(Component comp) {
        if (comp instanceof SubPaneIFace) {
            return (SubPaneIFace)((Object)comp);
        }
        Enumeration<SubPaneIFace> e = this.panes.elements();
        while (e.hasMoreElements()) {
            SubPaneIFace sp = e.nextElement();
            if (sp.getUIComponent() != comp) continue;
            return sp;
        }
        log.error((Object)("Couldn't find SubPane for Component [" + comp.hashCode() + "][" + comp + "]"));
        return null;
    }

    public SubPaneIFace getCurrentSubPane() {
        int index = this.getSelectedIndex();
        return index > -1 ? this.getSubPaneForComponent(this.getComponentAt(index)) : null;
    }

    public SubPaneIFace getSubPaneAt(int index) {
        return this.getSubPaneForComponent(this.getComponentAt(index));
    }

    public boolean closeAll() {
        return this.closeAll(true);
    }

    public boolean closeAllExceptCurrent() {
        return this.closeAll(false);
    }

    protected boolean closeAll(boolean includeCurrent) {
        if (this.panes.values().size() > 0) {
            Taskable defaultTask;
            SubPaneIFace subPane = this.getCurrentSubPane();
            if (subPane != null) {
                Vector<SubPaneIFace> paneList = new Vector<SubPaneIFace>(this.panes.values());
                for (SubPaneIFace pane : paneList) {
                    this.showPane(pane);
                    if (!includeCurrent && (includeCurrent || pane == subPane) || this.removePane(pane)) continue;
                    return false;
                }
                if (includeCurrent) {
                    this.panes.clear();
                }
            }
            if (includeCurrent) {
                this.removeAll();
            }
            if (TaskMgr.getToolbarTaskCount() == 1 && (defaultTask = TaskMgr.getDefaultTaskable()) != null) {
                this.addPane(defaultTask.getStarterPane());
            }
        }
        return true;
    }

    @Override
    public synchronized void closeCurrent() {
        Action closeCurrent = UIRegistry.getAction("CloseCurrent");
        if (!closeCurrent.isEnabled()) {
            return;
        }
        closeCurrent.setEnabled(false);
        try {
            SubPaneIFace subPane = this.getCurrentSubPane();
            if (subPane != null) {
                if (!subPane.aboutToShutdown()) {
                    return;
                }
                boolean isCurrentPaneStarter = subPane.getTask().isStarterPane();
                boolean wasLastSingleTaskPane = this.panes.size() == 1 && TaskMgr.getToolbarTaskCount() == 1;
                Taskable task = subPane.getTask();
                if (task != null) {
                    if (!wasLastSingleTaskPane && !task.isStarterPane() && task.isShowDefault() && this.countPanesByTask(task) == 1) {
                        int index = this.indexOfComponent(subPane.getUIComponent());
                        if (index < 0) {
                            log.error((Object)("Couldn't find index for panel [" + subPane.getPaneName() + "] "));
                        }
                        this.replacePane(subPane, task.getStarterPane());
                    } else if (!this.removePane(subPane, true, false) && this.panes.size() > 0) {
                        return;
                    }
                    if (wasLastSingleTaskPane && !isCurrentPaneStarter) {
                        subPane = task.getStarterPane();
                        this.addPane(subPane);
                    }
                }
            }
        }
        finally {
            closeCurrent.setEnabled(true);
        }
    }

    protected int countPanesByTask(Taskable task) {
        int cnt = 0;
        for (SubPaneIFace sp : this.panes.values()) {
            if (sp.getTask() != task) continue;
            ++cnt;
        }
        return cnt;
    }

    public void addListener(SubPaneMgrListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SubPaneMgrListener l) {
        this.listeners.remove(l);
    }

    protected void notifyListeners(NotificationType type, SubPaneIFace subPane) {
        for (SubPaneMgrListener l : this.listeners) {
            if (type == NotificationType.Added) {
                l.subPaneAdded(subPane);
                continue;
            }
            if (type == NotificationType.Removed) {
                l.subPaneRemoved(subPane);
                continue;
            }
            if (type != NotificationType.Shown) continue;
            l.subPaneShown(subPane);
        }
    }

    public static void createTabActions() {
        if (UIRegistry.getAction("CloseCurrent") != null) {
            return;
        }
        AbstractAction closeCurrent = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SubPaneMgr.getInstance().closeCurrent();
            }
        };
        UIRegistry.registerAction("CloseCurrent", closeCurrent);
        AbstractAction closeAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SubPaneMgr.getInstance().closeAll();
            }
        };
        UIRegistry.registerAction("CloseAll", closeAll);
        AbstractAction closeAllBut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SubPaneMgr.getInstance().closeAllExceptCurrent();
            }
        };
        UIRegistry.registerAction("CloseAllBut", closeAllBut);
        AbstractAction configureToolAction = new AbstractAction(UIRegistry.getResourceString("Specify.CONFIG_TASK_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Taskable task;
                SubPaneIFace sp = SubPaneMgr.getInstance().getCurrentSubPane();
                if (sp != null && (task = sp.getTask()) != null && task.isConfigurable()) {
                    task.doConfigure();
                }
            }
        };
        UIRegistry.registerAction("ConfigureTask", configureToolAction);
        configureToolAction.setEnabled(false);
    }

    protected void createContextMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            String ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_CUR_MENU");
            String mnu = UIRegistry.getResourceString("Specify.SBP_CLOSE_CUR_MNEU");
            UIHelper.createMenuItemWithAction(this.popupMenu, ttl, mnu, ttl, true, UIRegistry.getAction("CloseCurrent"));
            ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALL_MENU");
            mnu = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALL_MNEU");
            UIHelper.createMenuItemWithAction(this.popupMenu, ttl, mnu, ttl, true, UIRegistry.getAction("CloseAll"));
            ttl = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALLBUT_MENU");
            mnu = UIRegistry.getResourceString("Specify.SBP_CLOSE_ALLBUT_MNEU");
            UIHelper.createMenuItemWithAction(this.popupMenu, ttl, mnu, ttl, true, UIRegistry.getAction("CloseAllBut"));
            this.popupMenu.addSeparator();
            JMenuItem configTaskMI = new JMenuItem(UIRegistry.getAction("ConfigureTask"));
            this.popupMenu.add(configTaskMI);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        if (index > -1) {
            SubPaneIFace subPane = this.getSubPaneAt(index);
            if (subPane != null && this.currentPane != subPane) {
                if (this.currentPane != null) {
                    this.currentPane.showingPane(false);
                }
                ContextMgr.requestContext(subPane.getTask());
                subPane.showingPane(true);
                this.notifyListeners(NotificationType.Shown, subPane);
            }
            this.currentPane = subPane;
        } else {
            ContextMgr.requestContext(null);
        }
        this.checkForTaskableConfig();
    }

    protected static enum NotificationType {
        Added,
        Removed,
        Shown;

    }

    public class TabSelectionFocusGainListener
    implements ComponentListener {
        protected Component focusable;

        public TabSelectionFocusGainListener(Component focusable) {
            this.focusable = focusable;
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TabSelectionFocusGainListener.this.focusable != null) {
                        TabSelectionFocusGainListener.this.focusable.requestFocusInWindow();
                        TabSelectionFocusGainListener.this.focusable = null;
                    }
                }
            });
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

