/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.ui.UIRegistry;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingWorker;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpecialMsgNotifier {
    private static final Logger log = Logger.getLogger(SpecialMsgNotifier.class);
    private static AtomicBoolean blockMsg = new AtomicBoolean(false);

    public void checkForMessages() {
        if (blockMsg.get()) {
            return;
        }
        SwingWorker<Integer, Integer> msgCheckWorker = new SwingWorker<Integer, Integer>(){
            protected String msg = null;

            @Override
            protected Integer doInBackground() throws Exception {
                if (!blockMsg.get()) {
                    try {
                        Thread.sleep(15000L);
                        String url = String.valueOf(UIRegistry.getResourceString("CGI_BASE_URL")) + "/getmsg2.php";
                        String installID = UsageTracker.getInstallId();
                        this.msg = SpecialMsgNotifier.this.send(url, installID);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                if (this.msg != null && StringUtils.isNotEmpty((String)this.msg) && !this.msg.equals("NOMSG")) {
                    String header;
                    String string = header = this.msg.length() > 6 ? this.msg.substring(0, 7).toUpperCase() : "";
                    if (header.startsWith("<HTML>")) {
                        UIRegistry.showLocalizedError("NO_INTERNET");
                    } else {
                        UIRegistry.showError(2, this.msg);
                    }
                }
            }
        };
        msgCheckWorker.execute();
    }

    protected String send(String url, String id) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)this.getClass().getName());
        PostMethod postMethod = new PostMethod(url);
        Vector<NameValuePair> postParams = new Vector<NameValuePair>();
        postParams.add(new NameValuePair("id", id));
        String resAppVersion = UIRegistry.getAppVersion();
        resAppVersion = StringUtils.isEmpty((String)resAppVersion) ? "Unknown" : resAppVersion;
        postParams.add(new NameValuePair("os_name", System.getProperty("os.name")));
        postParams.add(new NameValuePair("os_version", System.getProperty("os.version")));
        postParams.add(new NameValuePair("java_version", System.getProperty("java.version")));
        postParams.add(new NameValuePair("java_vendor", System.getProperty("java.vendor")));
        postParams.add(new NameValuePair("app_version", UIRegistry.getAppVersion()));
        NameValuePair[] paramArray = new NameValuePair[postParams.size()];
        int i = 0;
        while (i < paramArray.length) {
            paramArray[i] = (NameValuePair)postParams.get(i);
            ++i;
        }
        postMethod.setRequestBody(paramArray);
        try {
            String responseString;
            httpClient.executeMethod((HttpMethod)postMethod);
            int status = postMethod.getStatusCode();
            if (status == 200 && StringUtils.isNotEmpty((String)(responseString = postMethod.getResponseBodyAsString()))) {
                return responseString;
            }
        }
        catch (UnknownHostException ex) {
            log.debug((Object)"Couldn't reach host.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setBlockMsg(boolean blockMsg) {
        SpecialMsgNotifier.blockMsg.set(blockMsg);
    }
}

