/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.af.core.db.DBTableInfo;
import edu.ku.brc.af.ui.forms.DataGetterForObj;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.IconManager;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ServiceInfo
implements Comparable<ServiceInfo>,
Cloneable {
    private static final Logger log = Logger.getLogger(ServiceInfo.class);
    protected Integer priority;
    protected String name;
    protected int tableId;
    protected Taskable task;
    protected String tooltip;
    protected CommandAction command;
    protected boolean isDefault;
    protected Hashtable<String, ImageIcon> icons = new Hashtable();
    protected Boolean isPermissionOK = null;

    public ServiceInfo(Integer priority, String serviceName, int tableId, CommandAction command, Taskable task, String iconName, String tooltip) {
        this(priority, serviceName, tableId, command, task, iconName, tooltip, false);
    }

    public ServiceInfo(Integer priority, String serviceName, int tableId, CommandAction command, Taskable task, String iconName, String tooltip, boolean isDefault) {
        this.priority = priority;
        this.name = serviceName;
        this.tableId = tableId;
        this.command = command;
        this.task = task;
        this.tooltip = tooltip;
        this.isDefault = isDefault;
        this.addIcon(IconManager.getIcon(iconName, IconManager.IconSize.Std16), IconManager.IconSize.Std16);
        this.addIcon(IconManager.getIcon(iconName, IconManager.IconSize.Std20), IconManager.IconSize.Std20);
        this.addIcon(IconManager.getIcon(iconName, IconManager.IconSize.Std24), IconManager.IconSize.Std24);
        this.addIcon(IconManager.getIcon(iconName, IconManager.IconSize.Std32), IconManager.IconSize.Std32);
    }

    public void addIcon(ImageIcon icon, IconManager.IconSize iconSize) {
        if (icon != null) {
            this.icons.put(iconSize.toString(), icon);
        } else {
            log.error((Object)("Couldn't load icon for size [" + (Object)((Object)iconSize) + "]"));
        }
    }

    public ImageIcon getIcon(IconManager.IconSize iconSize) {
        return this.icons.get(iconSize.toString());
    }

    public ImageIcon getIcon(int iconSize) {
        return this.icons.get("Std" + Integer.toString(iconSize));
    }

    public String getName() {
        return this.name;
    }

    public int getTableId() {
        return this.tableId;
    }

    public Taskable getTask() {
        return this.task;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public CommandAction getCommandAction() {
        return this.command;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isPermissionOK() {
        if (this.isPermissionOK == null) {
            DBTableInfo tableInfo;
            if (!this.task.getPermissions().canView()) {
                this.isPermissionOK = false;
                return this.isPermissionOK;
            }
            this.isPermissionOK = this.tableId > 0 ? Boolean.valueOf((tableInfo = DBTableIdMgr.getInstance().getInfoById(this.tableId)) != null ? tableInfo.getPermissions().canView() : false) : (this.task != null ? Boolean.valueOf(this.task.getPermissions() == null || this.task.getPermissions().canView()) : Boolean.valueOf(true));
        }
        return this.isPermissionOK;
    }

    public void resetPermissions() {
        this.isPermissionOK = null;
    }

    public boolean isAvailable(int tableId) {
        return true;
    }

    public static String getHashKey(String name, Taskable task, int tableId) {
        return String.valueOf(name) + "_" + (task != null ? task.getName() : "") + "_" + (tableId != -1 ? Integer.toString(tableId) : "");
    }

    @Override
    public int compareTo(ServiceInfo si) {
        return this.priority.compareTo(si.priority);
    }

    public Object clone() throws CloneNotSupportedException {
        ServiceInfo result = (ServiceInfo)super.clone();
        result.command = (CommandAction)this.command.clone();
        return result;
    }

    public String toString() {
        return new DataGetterForObj().makeToString(this);
    }
}

