/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.af.core.db.DBTableIdMgr;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.UIRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.apache.commons.lang.StringUtils;

public abstract class SchemaI18NService {
    public static final String factoryName = "edu.ku.brc.af.core.SchemaI18NService";
    protected static SchemaI18NService instance = null;
    protected static Locale currentLocale;
    protected static String[] priorityLocales;
    protected Vector<Locale> locales = new Vector();
    protected Vector<JCheckBoxMenuItem> localeMenuItems = new Vector();

    static {
        String[] stringArray = new String[18];
        stringArray[0] = "en";
        stringArray[1] = "US";
        stringArray[3] = "da";
        stringArray[4] = "DK";
        stringArray[6] = "de";
        stringArray[7] = "DE";
        stringArray[9] = "pt";
        stringArray[10] = "PT";
        stringArray[12] = "pt";
        stringArray[13] = "BR";
        stringArray[15] = "sv";
        stringArray[16] = "SE";
        priorityLocales = stringArray;
        Locale defLocale = Locale.getDefault();
        currentLocale = new Locale(defLocale.getLanguage(), "", "");
    }

    public static SchemaI18NService getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SchemaI18NService.factoryName);
            }
        });
        if (factoryNameStr != null) {
            try {
                instance = (SchemaI18NService)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(SchemaI18NService.class, e);
                InternalError error = new InternalError("Can't instantiate SchemaI18NService factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        throw new RuntimeException("The System porpoerty [edu.ku.brc.af.core.SchemaI18NService] has not been set up!");
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static void setCurrentLocale(Locale currentLocale) {
        SchemaI18NService.currentLocale = currentLocale;
    }

    public static void initializeLocales() {
        Vector<Locale> locs;
        SchemaI18NService srv = SchemaI18NService.getInstance();
        if (srv != null && (locs = srv.getLocales()).size() == 0) {
            Locale[] localeArray = Locale.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale locale = localeArray[n2];
                if (StringUtils.isNotEmpty((String)locale.getCountry())) {
                    locs.add(locale);
                }
                ++n2;
            }
            Collections.sort(locs, new Comparator<Locale>(){

                @Override
                public int compare(Locale o1, Locale o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
        }
    }

    public abstract List<Locale> getLocalesFromData(Byte var1, int var2);

    public abstract void loadWithLocale(Byte var1, int var2, DBTableIdMgr var3, Locale var4);

    public Locale getLocaleByLangCountry(String lang, String country, String variant) {
        if (lang != null) {
            for (Locale l : this.locales) {
                if (!l.getLanguage().equals(lang)) continue;
                if (country == null && variant == null) {
                    return l;
                }
                if (l.getCountry() == null || !l.getCountry().equals(country)) continue;
                if (variant == null) {
                    return l;
                }
                if (l.getVariant() == null || !l.getVariant().equals(variant)) continue;
                return l;
            }
        }
        return null;
    }

    public Vector<Locale> getStdLocaleList(boolean includeSepLocale) {
        Vector<Locale> freqLocales = new Vector<Locale>();
        int i = 0;
        while (i < priorityLocales.length) {
            Object vari;
            String ctry;
            Locale l;
            String lang = priorityLocales[i++];
            if ((l = this.getLocaleByLangCountry(lang, ctry = priorityLocales[i++], (String)(vari = priorityLocales[i++]))) == null) continue;
            freqLocales.add(l);
        }
        HashSet<String> freqSet = new HashSet<String>();
        for (Locale l : freqLocales) {
            freqSet.add(l.getDisplayName());
        }
        Vector<Locale> stdLocaleList = new Vector<Locale>();
        for (Locale l : this.locales) {
            if (freqSet.contains(l.getDisplayName())) continue;
            stdLocaleList.add(l);
        }
        if (includeSepLocale) {
            stdLocaleList.insertElementAt(new Locale("-", "-", "-"), 0);
        }
        i = freqLocales.size() - 1;
        while (i > -1) {
            stdLocaleList.insertElementAt((Locale)freqLocales.get(i), 0);
            --i;
        }
        return stdLocaleList;
    }

    public Vector<Locale> getLocales() {
        return this.locales;
    }

    public JMenu createLocaleMenu(ActionListener al) {
        JMenu menu = new JMenu("Locale");
        for (Locale locale : this.getStdLocaleList(true)) {
            if (!locale.getLanguage().equals("-")) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(locale.getDisplayName());
                this.localeMenuItems.add(cbmi);
                menu.add(cbmi);
                cbmi.addActionListener(al);
                continue;
            }
            menu.addSeparator();
        }
        return menu;
    }

    public void checkCurrentLocaleMenu() {
        for (JCheckBoxMenuItem cbmi : this.localeMenuItems) {
            if (cbmi.getText().equals(currentLocale.getDisplayName())) {
                cbmi.setSelected(true);
                continue;
            }
            cbmi.setSelected(false);
        }
    }

    public Locale getLocaleByName(String displayName) {
        for (Locale locale : this.locales) {
            if (!locale.getDisplayName().equals(displayName)) continue;
            return locale;
        }
        return null;
    }

    public JMenu createLocaleMenu(final JFrame frame, final PropertyChangeListener pcl) {
        JMenu localeMenu = this.createLocaleMenu(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Locale newLocale = SchemaI18NService.this.getLocaleByName(((JCheckBoxMenuItem)e.getSource()).getText());
                SchemaI18NService.this.checkCurrentLocaleMenu();
                UIRegistry.pushWindow(frame);
                pcl.propertyChange(new PropertyChangeEvent(this, "locale", currentLocale, newLocale));
                UIRegistry.popWindow(frame);
            }
        });
        this.checkCurrentLocaleMenu();
        return localeMenu;
    }
}

