/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.dbsupport.RecordSetIFace;
import edu.ku.brc.exceptions.ExceptionTracker;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.lang.StringUtils;

public class RecordSetFactory {
    public static final String factoryName = "RecordSetFactory";
    protected static RecordSetFactory instance = null;

    protected RecordSetFactory() {
    }

    public static RecordSetFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        String factoryNameStr = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(RecordSetFactory.factoryName);
            }
        });
        if (StringUtils.isNotEmpty((String)factoryNameStr)) {
            try {
                instance = (RecordSetFactory)Class.forName(factoryNameStr).newInstance();
                return instance;
            }
            catch (Exception e) {
                UsageTracker.incrHandledUsageCount();
                ExceptionTracker.getInstance().capture(RecordSetFactory.class, e);
                InternalError error = new InternalError("Can't instantiate RecordSet factory " + factoryNameStr);
                error.initCause(e);
                throw error;
            }
        }
        return null;
    }

    public RecordSetIFace createRecordSet() {
        throw new RuntimeException("Must create your own implementation.");
    }

    public RecordSetIFace createRecordSet(String name, int dbTableId, Byte type) {
        throw new RuntimeException("Must create your own implementation.");
    }
}

