/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.ContextMgr;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.prefs.AppPreferences;
import edu.ku.brc.exceptions.ConfigurationException;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.CommandListener;
import edu.ku.brc.ui.JTiledPanel;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.dnd.Trash;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;

public class NavBoxMgr
extends JTiledPanel
implements CommandListener {
    private static final String PREFS = "Preferences";
    private static final NavBoxMgr instance = new NavBoxMgr();
    private static Trash trash;
    private List<NavBoxIFace> list = Collections.synchronizedList(new ArrayList());
    private NavBoxLayoutManager layout = new NavBoxLayoutManager(5, 5);
    private JSplitPane splitPane;

    protected NavBoxMgr() {
        this.setLayout(this.layout);
        this.setBackground(NavBoxMgr.getBGColor());
        CommandDispatcher.register(PREFS, this);
        trash = Trash.getInstance();
        MouseAdapter mouseListener = new MouseAdapter(){

            private boolean showIfPopupTrigger(MouseEvent mouseEvent) {
                JPopupMenu popupMenu;
                Taskable currTask = ContextMgr.getCurrentContext();
                if (currTask != null && mouseEvent.isPopupTrigger() && currTask.isConfigurable() && (popupMenu = currTask.getPopupMenu()) != null && popupMenu.getComponentCount() > 0) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    return true;
                }
                return false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showIfPopupTrigger(mouseEvent);
            }
        };
        this.addMouseListener(mouseListener);
        SkinItem skinItem = SkinsMgr.getSkinItem("NavBoxMgr");
        if (skinItem != null) {
            skinItem.setupPanel(this);
        } else {
            this.setOpaque(true);
        }
    }

    public static Color getBGColor() {
        return Color.WHITE;
    }

    public void setSplitPane(JSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    public static NavBoxMgr getInstance() {
        return instance;
    }

    public static void register(Taskable task) {
        List<NavBoxIFace> list = task.getNavBoxes();
        if (list != null) {
            if (instance.getComponentCount() == 0 && list.size() > 0) {
                instance.add(trash);
                ((GhostGlassPane)UIRegistry.get("glasspane")).add(trash);
            }
            for (NavBoxIFace box : list) {
                instance.addBox(box);
                box.getUIComponent().invalidate();
                box.getUIComponent().doLayout();
            }
        }
        instance.doLayout();
        instance.repaint();
        instance.adjustSplitter();
    }

    public void adjustSplitter() {
        if (this.splitPane != null) {
            if (this.getComponentCount() > 0) {
                this.splitPane.setDividerLocation(this.getPreferredSize().width);
            } else {
                this.splitPane.setDividerLocation(0);
            }
        }
    }

    public void closeSplitter() {
        if (this.splitPane != null) {
            this.splitPane.setDividerLocation(0.0);
        }
    }

    public static void unregister() {
        ((GhostGlassPane)UIRegistry.get("glasspane")).clearActionableList();
        for (NavBoxIFace box : NavBoxMgr.instance.list) {
            box.setIsManaged(false);
        }
        NavBoxMgr.instance.layout.removeAll();
        instance.removeAll();
        NavBoxMgr.instance.list.clear();
        instance.repaint();
    }

    protected boolean exists(String name) {
        for (NavBoxIFace box : this.list) {
            if (!box.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void addBoxInternal(NavBoxIFace box, boolean ignoreAlreadyThere) {
        if (box == null) {
            throw new NullPointerException("Null pane when adding to NavBoxMgr");
        }
        if (!this.exists(box.getName())) {
            this.list.add(box);
            this.add(box.getUIComponent());
            this.invalidate();
            this.doLayout();
            this.adjustSplitter();
            box.setIsManaged(true);
            GhostGlassPane glassPane = (GhostGlassPane)UIRegistry.get("glasspane");
            for (NavBoxItemIFace item : box.getItems()) {
                if (!(item instanceof GhostActionable)) continue;
                glassPane.add((GhostActionable)((Object)item));
            }
        } else if (ignoreAlreadyThere) {
            throw new ConfigurationException("Adding a new NavBox with duplicate name[" + box.getName() + "]");
        }
    }

    public static void addBox(NavBoxIFace box, boolean ignoreAlreadyThere) {
        instance.addBoxInternal(box, ignoreAlreadyThere);
    }

    public void addBox(NavBoxIFace box) {
        NavBoxMgr.addBox(box, false);
    }

    public void removeBox(NavBoxIFace box, boolean notify) {
        if (this.list.contains(box)) {
            this.list.remove(box);
            box.setIsManaged(false);
            this.remove(box.getUIComponent());
            this.invalidate();
            this.doLayout();
            this.repaint();
        } else if (notify) {
            throw new ConfigurationException("Can't find an existing NavBox with name[" + box.getName() + "] to remove.");
        }
    }

    protected void prefsChanged(AppPreferences appPrefs) {
        if (appPrefs == AppPreferences.getRemote()) {
            AppPreferences ap = AppPreferences.getLocalPrefs();
            String key = "ui.formatting.controlSizes";
            String fontName = ap.get(String.valueOf(key) + ".FN", UIRegistry.getBaseFont().getFamily());
            int size = ap.getInt(String.valueOf(key) + ".SZ", UIRegistry.getBaseFont().getSize());
            Font font = UIRegistry.adjustPerDefaultFont(new Font(fontName, 0, size));
            for (NavBoxIFace nb : this.list) {
                boolean changed = false;
                for (NavBoxItemIFace nbi : nb.getItems()) {
                    Font f = nbi.getUIComponent().getFont();
                    if (!font.getFamily().equals(f.getFamily()) || f.getSize() != font.getSize()) continue;
                    nbi.getUIComponent().setFont(font);
                    changed = true;
                }
                if (!changed) continue;
                nb.getUIComponent().validate();
            }
        }
    }

    @Override
    public void doCommand(CommandAction cmdAction) {
        if (cmdAction.isType(PREFS)) {
            this.prefsChanged((AppPreferences)cmdAction.getData());
        }
    }
}

