/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.ui.dnd.Trash;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Vector;

public class NavBoxLayoutManager
implements LayoutManager2 {
    private Vector<Component> comps = new Vector();
    private Dimension preferredSize = new Dimension();
    private Dimension minimumSize = new Dimension();
    private int borderPadding;
    private int ySeparation;

    public NavBoxLayoutManager(int borderPadding, int ySeparation) {
        this.borderPadding = borderPadding;
        this.ySeparation = ySeparation;
    }

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
        if (arg1 == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(arg1);
    }

    @Override
    public void removeLayoutComponent(Component target) {
        if (target == null) {
            throw new NullPointerException("Null component in removeLayoutComponent");
        }
        this.comps.removeElement(target);
    }

    public void moveLayoutComponent(Component arg0, Component arg1) {
        int toIdx;
        int fromIdx = this.comps.indexOf(arg0);
        if (fromIdx == (toIdx = this.comps.indexOf(arg1))) {
            return;
        }
        this.comps.remove(fromIdx);
        this.comps.insertElementAt(arg0, toIdx);
    }

    @Override
    public synchronized Dimension preferredLayoutSize(Container target) {
        this.calcPreferredSize();
        return new Dimension(this.preferredSize);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        return new Dimension(this.minimumSize);
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension parentSize = target.getSize();
        parentSize.width -= 2 * this.borderPadding;
        parentSize.height -= 2 * this.borderPadding;
        int x = this.borderPadding;
        int y = this.borderPadding;
        Trash trash = null;
        for (Component comp : this.comps) {
            Dimension size = comp.getPreferredSize();
            if (comp instanceof Trash) {
                trash = (Trash)comp;
                continue;
            }
            comp.setBounds(x, y, parentSize.width, size.height);
            y += size.height + this.ySeparation;
        }
        if (trash != null) {
            Dimension size = trash.getPreferredSize();
            int trashY = parentSize.height - size.height - 1;
            trash.setBounds((parentSize.width - size.width) / 2, trashY > y ? trashY : y, size.width, size.height);
        }
    }

    protected void calcPreferredSize() {
        this.preferredSize.setSize(this.borderPadding * 2, this.borderPadding);
        for (Component comp : this.comps) {
            Dimension size = comp.getPreferredSize();
            this.preferredSize.width = Math.max(this.preferredSize.width, size.width + 2 * this.borderPadding);
            this.preferredSize.height += size.height + this.ySeparation;
            this.minimumSize.width = Math.max(this.minimumSize.width, comp.getMinimumSize().width + 2 * this.borderPadding);
        }
        this.preferredSize.height -= this.ySeparation;
    }

    public synchronized void removeAll() {
        this.comps.clear();
    }

    @Override
    public synchronized void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new NullPointerException("Null component in addLayoutComponent");
        }
        this.comps.addElement(comp);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.preferredSize.setSize(0, 0);
        this.calcPreferredSize();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        this.calcPreferredSize();
        return new Dimension(this.minimumSize);
    }
}

