/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.TaskCommandDef;
import edu.ku.brc.af.core.Taskable;
import edu.ku.brc.af.core.UsageTracker;
import edu.ku.brc.exceptions.ExceptionTracker;
import edu.ku.brc.ui.CommandAction;
import edu.ku.brc.ui.CommandDispatcher;
import edu.ku.brc.ui.dnd.DataActionEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NavBoxAction
implements ActionListener {
    public static final String ORGINATING_TASK = "OriginatingTask";
    private static final Logger log = Logger.getLogger(NavBoxAction.class);
    protected Taskable originatingTask = null;
    protected String type;
    protected String action;
    protected Properties properties = null;
    protected CommandAction cmdAction = null;

    public NavBoxAction(TaskCommandDef tcd) {
        this(tcd, null);
    }

    public NavBoxAction(TaskCommandDef tcd, Taskable origTask) {
        this.originatingTask = origTask;
        this.type = tcd.getParams().getProperty("type");
        this.action = tcd.getParams().getProperty("action");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)tcd.getParams());
        this.setOriginatingTask(origTask);
    }

    public NavBoxAction(CommandAction cmdAction) {
        this.cmdAction = cmdAction;
    }

    public NavBoxAction(String type, String action) {
        this(type, action, null);
    }

    public NavBoxAction(String type, String action, Taskable origTask) {
        this.type = type;
        this.action = action;
        this.setOriginatingTask(origTask);
    }

    public void setOriginatingTask(Taskable origTask) {
        this.originatingTask = origTask;
        if (origTask != null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(ORGINATING_TASK, this.originatingTask);
        }
    }

    public Object getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public String getPropertyAsString(String name) {
        if (this.properties != null) {
            Object obj = this.properties.get(name);
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(name, value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isDataActionEvent = e instanceof DataActionEvent;
        if (this.cmdAction != null) {
            if (isDataActionEvent) {
                try {
                    CommandAction cachedCA = (CommandAction)this.cmdAction.clone();
                    this.cmdAction.setData(((DataActionEvent)e).getData());
                    CommandDispatcher.dispatch(this.cmdAction);
                    this.cmdAction.set(cachedCA);
                }
                catch (CloneNotSupportedException ex) {
                    UsageTracker.incrHandledUsageCount();
                    ExceptionTracker.getInstance().capture(NavBoxAction.class, ex);
                    ex.printStackTrace();
                }
            } else {
                CommandDispatcher.dispatch(this.cmdAction);
            }
        } else {
            Object data = null;
            if (e instanceof DataActionEvent) {
                data = ((DataActionEvent)e).getData();
            }
            if (StringUtils.isNotEmpty((String)this.type) && StringUtils.isNotEmpty((String)this.action)) {
                CommandAction cmd = new CommandAction(this.type, this.action, data);
                cmd.addProperties(this.properties);
                CommandDispatcher.dispatch(cmd);
            } else {
                log.debug((Object)"Type and/or Action was NULL!");
            }
        }
    }
}

