/*
 * Decompiled with CFR 0.152.
 */
package edu.ku.brc.af.core;

import edu.ku.brc.af.core.NavBoxButton;
import edu.ku.brc.af.core.NavBoxIFace;
import edu.ku.brc.af.core.NavBoxItemIFace;
import edu.ku.brc.af.core.NavBoxLayoutManager;
import edu.ku.brc.af.core.NavBoxMgr;
import edu.ku.brc.ui.IconManager;
import edu.ku.brc.ui.RolloverCommand;
import edu.ku.brc.ui.UIHelper;
import edu.ku.brc.ui.UIRegistry;
import edu.ku.brc.ui.dnd.GhostActionable;
import edu.ku.brc.ui.dnd.GhostGlassPane;
import edu.ku.brc.ui.skin.SkinItem;
import edu.ku.brc.ui.skin.SkinsMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NavBox
extends JPanel
implements NavBoxIFace {
    private static final Logger log = Logger.getLogger(NavBox.class);
    private static final int MAX_HEIGHT = 180;
    protected String name;
    protected NavBoxIFace.Scope scope;
    protected NavBoxMgr mgr;
    protected Vector<NavBoxItemIFace> items = new Vector();
    protected boolean scrollable;
    protected JPanel itemsPanel;
    protected boolean collapsed = false;
    protected ImageIcon icon = null;
    protected ImageIcon collapsableIconOpen = null;
    protected ImageIcon collapsableIconClosed = null;
    protected Rectangle iconRect = null;
    protected int minHeight = -1;
    protected boolean isManaged = false;

    public NavBox(String name) {
        this(name, false, false);
    }

    public NavBox(String name, boolean collapsable, boolean scrollable) {
        this.name = name;
        this.setLayout(new BoxLayout(this, 1));
        this.scrollable = scrollable;
        SkinItem skinItem = SkinsMgr.getSkinItem("NavBox");
        if (scrollable) {
            this.itemsPanel = new JPanel();
            this.itemsPanel.setLayout(new NavBoxLayoutManager(0, 0));
            this.itemsPanel.setBorder(null);
            if (skinItem != null) {
                this.itemsPanel.setOpaque(skinItem.isOpaque());
                skinItem.setupPanel(this.itemsPanel);
            } else {
                this.itemsPanel.setBackground(NavBoxMgr.getBGColor());
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder(22, 4, 4, 4));
        this.setBackground(NavBoxMgr.getBGColor());
        this.setOpaque(!SkinsMgr.hasSkins());
        if (scrollable) {
            JScrollPane scrollPane = new JScrollPane(this.itemsPanel);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setBorder(null);
            this.add(scrollPane);
        }
    }

    @Override
    public NavBoxIFace.Scope getScope() {
        return this.scope;
    }

    @Override
    public void setScope(NavBoxIFace.Scope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public List<NavBoxItemIFace> getItems() {
        return this.items;
    }

    public Component insertSorted(NavBoxItemIFace item) {
        int insertionInx = Math.abs(Collections.binarySearch(this.items, item)) - 1;
        return this.insert(item, true, true, insertionInx);
    }

    public Component insert(NavBoxItemIFace item, boolean doLayout, boolean doSort, int position) {
        if (position == -1 || position == this.items.size()) {
            if (this.scrollable) {
                this.itemsPanel.add(item.getUIComponent());
            } else {
                super.add(item.getUIComponent());
            }
            this.items.addElement(item);
        } else {
            this.items.insertElementAt(item, position);
            if (doSort) {
                Collections.sort(this.items);
            }
            if (this.scrollable) {
                this.itemsPanel.removeAll();
                for (NavBoxItemIFace nb : this.items) {
                    this.itemsPanel.add(nb.getUIComponent());
                }
            } else {
                this.removeAll();
                for (NavBoxItemIFace nb : this.items) {
                    super.add(nb.getUIComponent());
                }
            }
        }
        if (this.isManaged && item instanceof GhostActionable) {
            ((GhostGlassPane)UIRegistry.get("glasspane")).add((GhostActionable)((Object)item));
        }
        item.getUIComponent().setBackground(this.getBackground());
        item.getUIComponent().setOpaque(!SkinsMgr.hasSkins());
        if (doLayout) {
            NavBox.refresh(this);
        }
        return item.getUIComponent();
    }

    public void sort() {
        Collections.sort(this.items);
        this.itemsPanel.removeAll();
        for (NavBoxItemIFace nb : this.items) {
            this.itemsPanel.add(nb.getUIComponent());
        }
        NavBox.refresh(this);
    }

    public Component add(NavBoxItemIFace item, boolean notify) {
        return this.insert(item, notify, false, this.items.size());
    }

    @Override
    public Component add(NavBoxItemIFace item) {
        return this.add(item, false);
    }

    @Override
    public void remove(NavBoxItemIFace item) {
        if (this.scrollable) {
            this.itemsPanel.remove(item.getUIComponent());
        } else {
            this.remove(item.getUIComponent());
        }
        this.items.remove(item);
        if (this.isManaged && item instanceof GhostActionable) {
            ((GhostGlassPane)UIRegistry.get("glasspane")).remove((GhostActionable)((Object)item));
        }
        NavBox.refresh(this);
    }

    @Override
    public void setIsManaged(boolean isManaged) {
        this.isManaged = isManaged;
    }

    public void clear() {
        if (this.scrollable) {
            this.itemsPanel.removeAll();
        } else {
            this.removeAll();
        }
        if (this.isManaged) {
            for (NavBoxItemIFace item : this.items) {
                if (!(item instanceof GhostActionable)) continue;
                ((GhostGlassPane)UIRegistry.get("glasspane")).add((GhostActionable)((Object)item));
            }
        }
        this.items.clear();
        NavBox.refresh(this);
    }

    public int getCount() {
        return this.items.size();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = fm.stringWidth(this.name);
        Insets insets = this.getBorder().getBorderInsets(this);
        size.width = Math.max(size.width, width += insets.left + insets.right);
        if (this.scrollable && size.height > 180) {
            size.height = 180;
        }
        if (this.collapsed) {
            size.height = this.minHeight;
        }
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = this.getSize();
        FontMetrics fm = g.getFontMetrics();
        int strW = fm.stringWidth(this.name);
        int x = (dim.width - strW) / 2;
        Insets ins = this.getBorder().getBorderInsets(this);
        int y = 2 + fm.getAscent();
        int lineW = dim.width - ins.left - ins.right;
        x = ins.left;
        int txtY = y;
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(x, y += 3, x + lineW, y);
        this.minHeight = ++y;
        g.setColor(Color.LIGHT_GRAY.darker());
        g.drawLine(++x, y, x + lineW, y);
        ((Graphics2D)g).setRenderingHints(UIHelper.createTextRenderingHints());
        g.setColor(Color.BLUE.darker());
        g.drawString(this.name, x, txtY);
        if (this.collapsableIconOpen != null) {
            if (this.iconRect == null) {
                this.iconRect = this.getBounds();
                this.iconRect.x = this.iconRect.width - this.collapsableIconOpen.getIconWidth();
                this.iconRect.y = 0;
            }
            g.drawImage(this.icon.getImage(), this.iconRect.x, this.iconRect.y, null);
        }
    }

    @Override
    public void setMgr(NavBoxMgr mgr) {
        this.mgr = mgr;
    }

    public static NavBoxItemIFace createBtn(String label, String iconName, IconManager.IconSize iconSize, ActionListener al) {
        ImageIcon icon = null;
        if (iconName != null) {
            icon = IconManager.getImage(iconName, iconSize);
        }
        NavBoxButton btn = new NavBoxButton(label, icon);
        if (al != null) {
            btn.addActionListener(al);
        }
        return btn;
    }

    public static NavBoxItemIFace createBtn(String label, String iconName, IconManager.IconSize iconSize) {
        return NavBox.createBtn(label, iconName, iconSize, null);
    }

    public static NavBoxItemIFace createBtnWithTT(String label, String iconName, String toolTip, IconManager.IconSize iconSize, ActionListener al) {
        NavBoxItemIFace nbi = NavBox.createBtn(label, iconName, iconSize, al);
        if (StringUtils.isNotEmpty((String)toolTip)) {
            nbi.setToolTip(toolTip);
        }
        return nbi;
    }

    public static void refresh(NavBoxIFace nb) {
        NavBox box = (NavBox)nb;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (NavBoxItemIFace nbii : NavBox.this.getItems()) {
                    if (!(nbii instanceof RolloverCommand)) continue;
                    RolloverCommand rc = (RolloverCommand)((Object)nbii);
                    rc.revalidate();
                }
                NavBox.this.revalidate();
                if (NavBox.this.itemsPanel != null) {
                    NavBox.this.itemsPanel.validate();
                    NavBox.this.itemsPanel.invalidate();
                }
                NavBoxMgr.getInstance().invalidate();
                NavBoxMgr.getInstance().doLayout();
                NavBoxMgr.getInstance().repaint();
                UIRegistry.forceTopFrameRepaint();
            }
        });
    }

    public static void refresh(NavBoxItemIFace nbi) {
        if (nbi != null) {
            JComponent comp = nbi.getUIComponent();
            ((Component)comp).invalidate();
            ((Component)comp).doLayout();
            comp.setSize(((Component)comp).getPreferredSize());
            comp.repaint();
            log.debug((Object)("comp " + ((Component)comp).getPreferredSize() + " " + comp.getSize()));
            Container parentComp = nbi.getUIComponent().getParent();
            if (parentComp instanceof NavBox) {
                NavBox.refresh((NavBox)parentComp);
            } else if (parentComp instanceof JScrollPane) {
                parentComp = parentComp.getParent().getParent();
                NavBox.refresh((NavBox)parentComp);
            }
        }
    }
}

